/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.mfa;

import com.google.zxing.WriterException;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import com.warrenstrange.googleauth.ICredentialRepository;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.identity.uaa.authentication.UaaPrincipal;
import org.cloudfoundry.identity.uaa.mfa.MfaProvider;
import org.cloudfoundry.identity.uaa.mfa.MfaProviderProvisioning;
import org.cloudfoundry.identity.uaa.mfa.MfaRegisterQRGenerator;
import org.cloudfoundry.identity.uaa.mfa.UserGoogleMfaCredentials;
import org.cloudfoundry.identity.uaa.mfa.UserMfaCredentialsProvisioning;
import org.cloudfoundry.identity.uaa.mfa.exception.UserMfaConfigDoesNotExistException;
import org.cloudfoundry.identity.uaa.zone.IdentityZone;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;

public class UserGoogleMfaCredentialsProvisioning
implements ICredentialRepository {
    private static Log logger = LogFactory.getLog(UserGoogleMfaCredentialsProvisioning.class);
    private MfaProviderProvisioning mfaProviderProvisioning;
    private GoogleAuthenticator authenticator;
    private UserMfaCredentialsProvisioning<UserGoogleMfaCredentials> jdbcProvisioner;

    public void setAuthenticator(GoogleAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public UserGoogleMfaCredentials getUserGoogleMfaCredentials(String userId) {
        MfaProvider provider = this.mfaProviderProvisioning.retrieveByName(IdentityZoneHolder.get().getConfig().getMfaConfig().getProviderName(), IdentityZoneHolder.get().getId());
        return this.getUserGoogleMfaCredentials(userId, provider.getId());
    }

    public UserGoogleMfaCredentials getUserGoogleMfaCredentials(String userId, String providerId) {
        try {
            return this.jdbcProvisioner.retrieve(userId, providerId);
        }
        catch (UserMfaConfigDoesNotExistException e) {
            logger.debug((Object)("Unable to find MFA config for user:" + userId));
            return null;
        }
    }

    public String getSecretKey(String userId) {
        throw new UnsupportedOperationException();
    }

    public String getOtpAuthURL(String qrIssuer, UserGoogleMfaCredentials credentials, String userName) throws IOException, WriterException {
        return MfaRegisterQRGenerator.getQRCodePngDataUri(qrIssuer, userName, credentials.getSecretKey());
    }

    public UserGoogleMfaCredentials createUserCredentials(String userId) {
        GoogleAuthenticatorKey credentials = this.authenticator.createCredentials(userId);
        UserGoogleMfaCredentials creds = new UserGoogleMfaCredentials(userId, credentials.getKey(), credentials.getVerificationCode(), credentials.getScratchCodes());
        return creds;
    }

    public boolean isValidCode(UserGoogleMfaCredentials credentials, Integer code) {
        return this.authenticator.authorize(credentials.getSecretKey(), code.intValue());
    }

    public void saveUserCredentials(String userId, String secretKey, int validationCode, List<Integer> scratchCodes) {
    }

    public void saveUserCredentials(UserGoogleMfaCredentials credentials) {
        IdentityZone zone = IdentityZoneHolder.get();
        this.jdbcProvisioner.save(credentials, zone.getId());
    }

    public boolean activeUserCredentialExists(String userId, String providerId) {
        return this.getUserGoogleMfaCredentials(userId, providerId) != null;
    }

    public boolean isFirstTimeMFAUser(UaaPrincipal uaaPrincipal) {
        if (uaaPrincipal == null) {
            throw new RuntimeException("User information is not present in session.");
        }
        return this.getUserGoogleMfaCredentials(uaaPrincipal.getId()) == null;
    }

    public void setJdbcProvisioner(UserMfaCredentialsProvisioning<UserGoogleMfaCredentials> jdbcProvisioner) {
        this.jdbcProvisioner = jdbcProvisioner;
    }

    public void setMfaProviderProvisioning(MfaProviderProvisioning mfaProviderProvisioning) {
        this.mfaProviderProvisioning = mfaProviderProvisioning;
    }
}

