/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.health;

import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class HealthzEndpoint {
    private static Log logger = LogFactory.getLog(HealthzEndpoint.class);
    private volatile boolean stopping = false;
    private final Thread shutdownhook;
    private final long sleepTime;

    public HealthzEndpoint(long sleepTime) {
        this.sleepTime = sleepTime;
        this.shutdownhook = new Thread(() -> {
            this.stopping = true;
            logger.warn((Object)"Shutdown hook received, future requests to this endpoint will return 503");
            try {
                if (sleepTime > 0L) {
                    logger.debug((Object)("Healthz is sleeping shutdown thread for " + sleepTime + " ms."));
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Shutdown sleep interrupted.", (Throwable)e);
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownhook);
    }

    @RequestMapping(value={"/healthz"})
    @ResponseBody
    public String getHealthz(HttpServletResponse response) throws Exception {
        if (this.stopping) {
            logger.debug((Object)"Received /healthz request during shutdown. Returning 'stopping'");
            response.setStatus(503);
            return "stopping\n";
        }
        return "ok\n";
    }

    public long getSleepTime() {
        return this.sleepTime;
    }
}

