/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.listener;

import org.cloudfoundry.identity.uaa.authentication.UaaAuthenticationDetails;
import org.cloudfoundry.identity.uaa.authentication.event.PrincipalAuthenticationFailureEvent;
import org.cloudfoundry.identity.uaa.authentication.event.PrincipalNotFoundEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class BadCredentialsListener
implements ApplicationListener<AuthenticationFailureBadCredentialsEvent>,
ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        AuthenticationFailureBadCredentialsEvent bce = event;
        String principal = bce.getAuthentication().getName();
        UaaAuthenticationDetails details = (UaaAuthenticationDetails)bce.getAuthentication().getDetails();
        if (bce.getException() instanceof UsernameNotFoundException) {
            this.publisher.publishEvent((ApplicationEvent)new PrincipalNotFoundEvent(principal, details));
        } else {
            this.publisher.publishEvent((ApplicationEvent)new PrincipalAuthenticationFailureEvent(principal, details));
        }
    }
}

