/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication.listener;

import org.cloudfoundry.identity.uaa.authentication.UaaAuthentication;
import org.cloudfoundry.identity.uaa.authentication.event.AbstractUaaAuthenticationEvent;
import org.cloudfoundry.identity.uaa.authentication.event.IdentityProviderAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.event.MfaAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.authentication.event.UserAuthenticationSuccessEvent;
import org.cloudfoundry.identity.uaa.mfa.MfaChecker;
import org.cloudfoundry.identity.uaa.scim.ScimUserProvisioning;
import org.cloudfoundry.identity.uaa.user.UaaUser;
import org.cloudfoundry.identity.uaa.zone.IdentityZoneHolder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.Authentication;

public class AuthenticationSuccessListener
implements ApplicationListener<AbstractUaaAuthenticationEvent>,
ApplicationEventPublisherAware {
    private final ScimUserProvisioning scimUserProvisioning;
    private final MfaChecker checker;
    private ApplicationEventPublisher publisher;

    public AuthenticationSuccessListener(ScimUserProvisioning scimUserProvisioning, MfaChecker checker) {
        this.scimUserProvisioning = scimUserProvisioning;
        this.checker = checker;
    }

    public void onApplicationEvent(AbstractUaaAuthenticationEvent event) {
        if (event instanceof UserAuthenticationSuccessEvent) {
            this.onApplicationEvent((UserAuthenticationSuccessEvent)event);
        } else if (event instanceof IdentityProviderAuthenticationSuccessEvent) {
            IdentityProviderAuthenticationSuccessEvent passwordAuthEvent = (IdentityProviderAuthenticationSuccessEvent)event;
            UserAuthenticationSuccessEvent userEvent = new UserAuthenticationSuccessEvent(passwordAuthEvent.getUser(), (Authentication)passwordAuthEvent.getSource());
            if (!this.checker.isMfaEnabled(userEvent.getIdentityZone(), userEvent.getUser().getOrigin())) {
                this.publisher.publishEvent((ApplicationEvent)userEvent);
            }
        } else if (event instanceof MfaAuthenticationSuccessEvent) {
            MfaAuthenticationSuccessEvent mfaEvent = (MfaAuthenticationSuccessEvent)event;
            UserAuthenticationSuccessEvent userEvent = new UserAuthenticationSuccessEvent(mfaEvent.getUser(), (Authentication)mfaEvent.getSource());
            this.publisher.publishEvent((ApplicationEvent)userEvent);
        }
    }

    protected void onApplicationEvent(UserAuthenticationSuccessEvent event) {
        UaaUser user = event.getUser();
        if (user.isLegacyVerificationBehavior() && !user.isVerified()) {
            this.scimUserProvisioning.verifyUser(user.getId(), -1, IdentityZoneHolder.get().getId());
        }
        UaaAuthentication authentication = (UaaAuthentication)event.getAuthentication();
        authentication.setLastLoginSuccessTime(user.getLastLogonTime());
        this.scimUserProvisioning.updateLastLogonTime(user.getId(), IdentityZoneHolder.get().getId());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    public void publish(ApplicationEvent event) {
        if (this.publisher != null) {
            this.publisher.publishEvent(event);
        }
    }
}

