/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.identity.uaa.authentication;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cloudfoundry.identity.uaa.util.UaaStringUtils;
import org.springframework.security.core.GrantedAuthority;

public interface UaaAuthenticationJsonBase {
    public static final String DETAILS = "details";
    public static final String PRINCIPAL = "principal";
    public static final String AUTHORITIES = "authorities";
    public static final String EXTERNAL_GROUPS = "externalGroups";
    public static final String EXPIRES_AT = "expiresAt";
    public static final String AUTH_TIME = "authenticatedTime";
    public static final String AUTHENTICATED = "authenticated";
    public static final String USER_ATTRIBUTES = "userAttributes";
    public static final String AUTHENTICATION_METHODS = "authenticationMethods";
    public static final String AUTHN_CONTEXT_CLASS_REF = "authContextClassRef";
    public static final String PREVIOIUS_LOGIN_SUCCESS_TIME = "previousLoginSuccessTime";
    public static final String NULL_STRING = "null";

    default public Set<String> serializeAuthorites(Collection<? extends GrantedAuthority> authorities) {
        return UaaStringUtils.getStringsFromAuthorities(authorities);
    }

    default public List<? extends GrantedAuthority> deserializeAuthorites(Collection<String> authorities) {
        return UaaStringUtils.getAuthoritiesFromStrings(authorities);
    }
}

