/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.cloudfoundry.reactor.util._OperatorContext;
import org.immutables.value.Generated;

@Generated(from="_OperatorContext", generator="Immutables")
public final class OperatorContext
implements _OperatorContext {
    private final ConnectionContext connectionContext;
    private final ErrorPayloadMapper errorPayloadMapper;
    private final String root;
    private final TokenProvider tokenProvider;

    private OperatorContext(ConnectionContext connectionContext, String root) {
        this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
        this.root = Objects.requireNonNull(root, "root");
        this.errorPayloadMapper = null;
        this.tokenProvider = null;
    }

    private OperatorContext(ConnectionContext connectionContext, ErrorPayloadMapper errorPayloadMapper, String root, TokenProvider tokenProvider) {
        this.connectionContext = connectionContext;
        this.errorPayloadMapper = errorPayloadMapper;
        this.root = root;
        this.tokenProvider = tokenProvider;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Optional<ErrorPayloadMapper> getErrorPayloadMapper() {
        return Optional.ofNullable(this.errorPayloadMapper);
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public Optional<TokenProvider> getTokenProvider() {
        return Optional.ofNullable(this.tokenProvider);
    }

    public final OperatorContext withConnectionContext(ConnectionContext value) {
        if (this.connectionContext == value) {
            return this;
        }
        ConnectionContext newValue = Objects.requireNonNull(value, "connectionContext");
        return new OperatorContext(newValue, this.errorPayloadMapper, this.root, this.tokenProvider);
    }

    public final OperatorContext withErrorPayloadMapper(ErrorPayloadMapper value) {
        ErrorPayloadMapper newValue = Objects.requireNonNull(value, "errorPayloadMapper");
        if (this.errorPayloadMapper == newValue) {
            return this;
        }
        return new OperatorContext(this.connectionContext, newValue, this.root, this.tokenProvider);
    }

    public final OperatorContext withErrorPayloadMapper(Optional<? extends ErrorPayloadMapper> optional) {
        ErrorPayloadMapper value = optional.orElse(null);
        if (this.errorPayloadMapper == value) {
            return this;
        }
        return new OperatorContext(this.connectionContext, value, this.root, this.tokenProvider);
    }

    public final OperatorContext withRoot(String value) {
        String newValue = Objects.requireNonNull(value, "root");
        if (this.root.equals(newValue)) {
            return this;
        }
        return new OperatorContext(this.connectionContext, this.errorPayloadMapper, newValue, this.tokenProvider);
    }

    public final OperatorContext withTokenProvider(TokenProvider value) {
        TokenProvider newValue = Objects.requireNonNull(value, "tokenProvider");
        if (this.tokenProvider == newValue) {
            return this;
        }
        return new OperatorContext(this.connectionContext, this.errorPayloadMapper, this.root, newValue);
    }

    public final OperatorContext withTokenProvider(Optional<? extends TokenProvider> optional) {
        TokenProvider value = optional.orElse(null);
        if (this.tokenProvider == value) {
            return this;
        }
        return new OperatorContext(this.connectionContext, this.errorPayloadMapper, this.root, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OperatorContext && this.equalTo((OperatorContext)another);
    }

    private boolean equalTo(OperatorContext another) {
        return this.connectionContext.equals(another.connectionContext) && Objects.equals(this.errorPayloadMapper, another.errorPayloadMapper) && this.root.equals(another.root) && Objects.equals(this.tokenProvider, another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorPayloadMapper);
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + Objects.hashCode(this.tokenProvider);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OperatorContext{");
        builder.append("connectionContext=").append(this.connectionContext);
        if (this.errorPayloadMapper != null) {
            builder.append(", ");
            builder.append("errorPayloadMapper=").append(this.errorPayloadMapper);
        }
        builder.append(", ");
        builder.append("root=").append(this.root);
        if (this.tokenProvider != null) {
            builder.append(", ");
            builder.append("tokenProvider=").append(this.tokenProvider);
        }
        return builder.append("}").toString();
    }

    public static OperatorContext of(ConnectionContext connectionContext, String root) {
        return new OperatorContext(connectionContext, root);
    }

    public static OperatorContext copyOf(_OperatorContext instance) {
        if (instance instanceof OperatorContext) {
            return (OperatorContext)instance;
        }
        return OperatorContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_OperatorContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_ROOT = 2L;
        private long initBits = 3L;
        private ConnectionContext connectionContext;
        private ErrorPayloadMapper errorPayloadMapper;
        private String root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(_OperatorContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            Optional<ErrorPayloadMapper> errorPayloadMapperOptional = instance.getErrorPayloadMapper();
            if (errorPayloadMapperOptional.isPresent()) {
                this.errorPayloadMapper(errorPayloadMapperOptional);
            }
            this.root(instance.getRoot());
            Optional<TokenProvider> tokenProviderOptional = instance.getTokenProvider();
            if (tokenProviderOptional.isPresent()) {
                this.tokenProvider(tokenProviderOptional);
            }
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder errorPayloadMapper(ErrorPayloadMapper errorPayloadMapper) {
            this.errorPayloadMapper = Objects.requireNonNull(errorPayloadMapper, "errorPayloadMapper");
            return this;
        }

        public final Builder errorPayloadMapper(Optional<? extends ErrorPayloadMapper> errorPayloadMapper) {
            this.errorPayloadMapper = errorPayloadMapper.orElse(null);
            return this;
        }

        public final Builder root(String root) {
            this.root = Objects.requireNonNull(root, "root");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            return this;
        }

        public final Builder tokenProvider(Optional<? extends TokenProvider> tokenProvider) {
            this.tokenProvider = tokenProvider.orElse(null);
            return this;
        }

        public OperatorContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new OperatorContext(this.connectionContext, this.errorPayloadMapper, this.root, this.tokenProvider);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("root");
            }
            return "Cannot build OperatorContext, some of required attributes are not set " + attributes;
        }
    }
}

