/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.domains;

import java.util.Map;
import org.cloudfoundry.client.v3.domains.CheckReservedRoutesRequest;
import org.cloudfoundry.client.v3.domains.CheckReservedRoutesResponse;
import org.cloudfoundry.client.v3.domains.CreateDomainRequest;
import org.cloudfoundry.client.v3.domains.CreateDomainResponse;
import org.cloudfoundry.client.v3.domains.DeleteDomainRequest;
import org.cloudfoundry.client.v3.domains.DomainsV3;
import org.cloudfoundry.client.v3.domains.GetDomainRequest;
import org.cloudfoundry.client.v3.domains.GetDomainResponse;
import org.cloudfoundry.client.v3.domains.ListDomainsRequest;
import org.cloudfoundry.client.v3.domains.ListDomainsResponse;
import org.cloudfoundry.client.v3.domains.ShareDomainRequest;
import org.cloudfoundry.client.v3.domains.ShareDomainResponse;
import org.cloudfoundry.client.v3.domains.UnshareDomainRequest;
import org.cloudfoundry.client.v3.domains.UpdateDomainRequest;
import org.cloudfoundry.client.v3.domains.UpdateDomainResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorDomainsV3
extends AbstractClientV3Operations
implements DomainsV3 {
    public ReactorDomainsV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    public Mono<CheckReservedRoutesResponse> checkReservedRoutes(CheckReservedRoutesRequest request) {
        return this.get((Object)request, CheckReservedRoutesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains", request.getDomainId(), "route_reservations"})).checkpoint();
    }

    public Mono<CreateDomainResponse> create(CreateDomainRequest request) {
        return this.post(request, CreateDomainResponse.class, builder -> builder.pathSegment(new String[]{"domains"})).checkpoint();
    }

    public Mono<String> delete(DeleteDomainRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"domains", request.getDomainId()})).checkpoint();
    }

    public Mono<GetDomainResponse> get(GetDomainRequest request) {
        return this.get((Object)request, GetDomainResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains", request.getDomainId()})).checkpoint();
    }

    public Mono<ListDomainsResponse> list(ListDomainsRequest request) {
        return this.get((Object)request, ListDomainsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"domains"})).checkpoint();
    }

    public Mono<ShareDomainResponse> share(ShareDomainRequest request) {
        return this.post(request, ShareDomainResponse.class, builder -> builder.pathSegment(new String[]{"domains", request.getDomainId(), "relationships", "shared_organizations"})).checkpoint();
    }

    public Mono<Void> unshare(UnshareDomainRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"domains", request.getDomainId(), "relationships", "shared_organizations", request.getOrganizationId()})).checkpoint();
    }

    public Mono<UpdateDomainResponse> update(UpdateDomainRequest request) {
        return this.patch(request, UpdateDomainResponse.class, builder -> builder.pathSegment(new String[]{"domains", request.getDomainId()})).checkpoint();
    }
}

