/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.SecureRandom;
import jdk.internal.util.StaticProperty;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs;
    private String path;
    private transient int prefixLength;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy char separatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String separator;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy char pathSeparatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String pathSeparator;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    int getPrefixLength();

    private File(String var1, int var2);

    private File(String var1, File var2);

    @FromByteCode
    @FromByteCode
    public File(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var1);

    @FromByteCode
    @FromByteCode
    public File(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy String var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var2);

    @FromByteCode
    @FromByteCode
    public File(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy File var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var2);

    @FromByteCode
    @FromByteCode
    public File(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy URI var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String getName();

    @Pure
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy String getParent(@GuardSatisfied File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy File getParentFile(@GuardSatisfied File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String getPath();

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isAbsolute(@GuardSatisfied File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String getAbsolutePath();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File getAbsoluteFile();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String getCanonicalPath() throws IOException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File getCanonicalFile() throws IOException;

    private static String slashify(String var0, boolean var1);

    @Deprecated
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy URL toURL() throws MalformedURLException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy URI toURI();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean canRead();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean canWrite();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean exists();

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isDirectory(@GuardSatisfied File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isFile(@GuardSatisfied File this);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isHidden(@GuardSatisfied File this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long lastModified();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long length();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean createNewFile() throws IOException;

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean delete();

    @FromByteCode
    @FromByteCode
    public void deleteOnExit();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] list();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] list(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy FilenameFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] listFiles();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] listFiles(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy FilenameFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] listFiles(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy FileFilter var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean mkdir();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean mkdirs();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean renameTo(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setLastModified(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setReadOnly();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setWritable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setWritable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setReadable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setReadable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setExecutable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean setExecutable(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean canExecute();

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] listRoots();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long getTotalSpace();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long getFreeSpace();

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long getUsableSpace();

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File createTempFile(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0, @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy String var1, @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy File var2) throws IOException;

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy File createTempFile(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0, @Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy String var1) throws IOException;

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int compareTo(@GuardSatisfied File this, @UnknownKeyFor @NonNull @Initialized @GuardSatisfied @LockPossiblyHeld File var1);

    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean equals(@GuardSatisfied File this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Pure
    @FromByteCode
    @Pure
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int hashCode(@GuardSatisfied File this);

    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String toString(@GuardSatisfied File this);

    private synchronized void writeObject(ObjectOutputStream var1) throws IOException;

    private synchronized void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public Path toPath();

    static;

    private static class TempDirectory {
        private static final File TMPDIR = new File(StaticProperty.javaIoTmpDir());
        private static final SecureRandom RANDOM = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return TMPDIR;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = RANDOM.nextLong();
            String nus = Long.toUnsignedString((long)n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = FS.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = FS.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

