/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.ASCII;
import java.util.regex.CharPredicates;
import java.util.regex.IntHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;
import org.checkerframework.framework.qual.FromStubFile;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public final class Pattern
implements Serializable {
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int UNIX_LINES = 1;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int CASE_INSENSITIVE = 2;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int COMMENTS = 4;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int MULTILINE = 8;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int LITERAL = 16;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int DOTALL = 32;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int UNICODE_CASE = 64;
    public static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int CANON_EQ = 128;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = 5073258162644648461L;
    private String pattern;
    private int flags;
    private volatile transient boolean compiled;
    private transient String normalizedPattern;
    transient Node root;
    transient Node matchRoot;
    transient int[] buffer;
    volatile transient Map<String, Integer> namedGroups;
    transient GroupHead[] groupNodes;
    private transient int[] temp;
    transient int capturingGroupCount;
    transient int localCount;
    private transient int cursor;
    private transient int patternLength;
    private transient boolean hasSupplementary;
    static final int MAX_REPS = Integer.MAX_VALUE;
    static final int GREEDY = 0;
    static final int LAZY = 1;
    static final int POSSESSIVE = 2;
    static final int INDEPENDENT = 3;
    static Node lookbehindEnd;
    static Node accept;
    static Node lastAccept;

    @Pure
    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Pattern compile(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0);

    @Pure
    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Pattern compile(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String pattern();

    @SideEffectFree
    @FromByteCode
    @SideEffectFree
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String toString(@GuardSatisfied Pattern this);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Matcher matcher(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy CharSequence var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int flags();

    @FromByteCode
    @FromByteCode
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean matches(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy CharSequence var1);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] split(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy CharSequence var1, @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var2);

    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] split(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy CharSequence var1);

    @Pure
    @FromStubFile
    @Pure
    @FromStubFile
    public static @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String quote(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy String var0);

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    private Pattern(String var1, int var2);

    private void normalize();

    private int normalizeCharClass(StringBuilder var1, int var2);

    private String produceEquivalentAlternation(String var1);

    private String[] producePermutations(String var1);

    private int getClass(int var1);

    private String composeOneStep(String var1);

    private void RemoveQEQuoting();

    private void compile();

    Map<String, Integer> namedGroups();

    private static void printObjectTree(Node var0);

    private boolean has(int var1);

    private void accept(int var1, String var2);

    private void mark(int var1);

    private int peek();

    private int read();

    private int readEscaped();

    private int next();

    private int nextEscaped();

    private int peekPastWhitespace(int var1);

    private int parsePastWhitespace(int var1);

    private int parsePastLine();

    private int peekPastLine();

    private boolean isLineSeparator(int var1);

    private int skip();

    private void unread();

    private PatternSyntaxException error(String var1);

    private boolean findSupplementary(int var1, int var2);

    private static final boolean isSupplementary(int var0);

    private Node expr(Node var1);

    private Node sequence(Node var1);

    private Node atom();

    private void append(int var1, int var2);

    private Node ref(int var1);

    private int escape(boolean var1, boolean var2);

    private CharProperty clazz(boolean var1);

    private CharProperty bitsOrSingle(BitClass var1, int var2);

    private CharProperty range(BitClass var1);

    private int single();

    private CharProperty family(boolean var1, boolean var2);

    private CharProperty unicodeScriptPropertyFor(String var1);

    private CharProperty unicodeBlockPropertyFor(String var1);

    private CharProperty charPropertyNodeFor(String var1);

    private String groupname(int var1);

    private Node group0();

    private Node createGroup(boolean var1);

    private void addFlag();

    private void subFlag();

    private Node closure(Node var1);

    private int c();

    private int o();

    private int x();

    private int cursor();

    private void setcursor(int var1);

    private int uxxxx();

    private int u();

    private static final int countChars(CharSequence var0, int var1, int var2);

    private static final int countCodePoints(CharSequence var0);

    private CharProperty newSingle(int var1);

    private Node newSlice(int[] var1, int var2, boolean var3);

    private static boolean inRange(int var0, int var1, int var2);

    private static CharProperty rangeFor(int var0, int var1);

    private CharProperty caseInsensitiveRangeFor(int var1, int var2);

    private static CharProperty union(CharProperty var0, CharProperty var1);

    private static CharProperty intersection(CharProperty var0, CharProperty var1);

    private static CharProperty setDifference(CharProperty var0, CharProperty var1);

    private static boolean hasBaseCharacter(Matcher var0, int var1, CharSequence var2);

    static;

    static final class TreeInfo {
        int minLength;
        int maxLength;
        boolean maxValid;
        boolean deterministic;

        TreeInfo() {
            this.reset();
        }

        void reset() {
            this.minLength = 0;
            this.maxLength = 0;
            this.maxValid = true;
            this.deterministic = true;
        }
    }

    static final class BitClass
    implements BmpCharPredicate {
        final boolean[] bits = new boolean[256];

        BitClass() {
        }

        BitClass add(int c, int flags) {
            assert (c >= 0 && c <= 255);
            if ((flags & 2) != 0) {
                if (ASCII.isAscii(c)) {
                    this.bits[ASCII.toUpper((int)c)] = true;
                    this.bits[ASCII.toLower((int)c)] = true;
                } else if ((flags & 0x40) != 0) {
                    this.bits[Character.toLowerCase((int)c)] = true;
                    this.bits[Character.toUpperCase((int)c)] = true;
                }
            }
            this.bits[c] = true;
            return this;
        }

        @Override
        public boolean is(int ch) {
            return ch < 256 && this.bits[ch];
        }
    }

    static class Node {
        Node next = accept;

        Node() {
        }

        boolean match(Matcher matcher, int i, CharSequence seq) {
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }

        boolean study(TreeInfo info) {
            if (this.next != null) {
                return this.next.study(info);
            }
            return info.deterministic;
        }
    }

    static class LastNode
    extends Node {
        LastNode() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (matcher.acceptMode == 1 && i != matcher.to) {
                return false;
            }
            matcher.last = i;
            matcher.groups[0] = matcher.first;
            matcher.groups[1] = matcher.last;
            return true;
        }
    }

    static class Start
    extends Node {
        int minLength;

        Start(Node node) {
            this.next = node;
            TreeInfo info = new TreeInfo();
            this.next.study(info);
            this.minLength = info.minLength;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int guard = matcher.to - this.minLength;
            while (i <= guard) {
                if (this.next.match(matcher, i, seq)) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            this.next.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static final class StartS
    extends Start {
        StartS(Node node) {
            super(node);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.to - this.minLength) {
                matcher.hitEnd = true;
                return false;
            }
            int guard = matcher.to - this.minLength;
            while (i <= guard) {
                if (this.next.match(matcher, i, seq)) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                if (i == guard) break;
                if (!Character.isHighSurrogate(seq.charAt(i++)) || i >= seq.length() || !Character.isLowSurrogate(seq.charAt(i))) continue;
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static final class Begin
    extends Node {
        Begin() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int fromIndex;
            int n = fromIndex = matcher.anchoringBounds ? matcher.from : 0;
            if (i == fromIndex && this.next.match(matcher, i, seq)) {
                matcher.first = i;
                matcher.groups[0] = i;
                matcher.groups[1] = matcher.last;
                return true;
            }
            return false;
        }
    }

    static final class End
    extends Node {
        End() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i == endIndex) {
                matcher.hitEnd = true;
                return this.next.match(matcher, i, seq);
            }
            return false;
        }
    }

    static final class Caret
    extends Node {
        Caret() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex) {
                char ch = seq.charAt(i - 1);
                if (ch != '\n' && ch != '\r' && (ch | '\u0001') != 8233 && ch != '\u0085') {
                    return false;
                }
                if (ch == '\r' && seq.charAt(i) == '\n') {
                    return false;
                }
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class UnixCaret
    extends Node {
        UnixCaret() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (!matcher.anchoringBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i == endIndex) {
                matcher.hitEnd = true;
                return false;
            }
            if (i > startIndex && (ch = seq.charAt(i - 1)) != '\n') {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class LastMatch
    extends Node {
        LastMatch() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i != matcher.oldLast) {
                return false;
            }
            return this.next.match(matcher, i, seq);
        }
    }

    static final class Dollar
    extends Node {
        boolean multiline;

        Dollar(boolean mul) {
            this.multiline = mul;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            char ch;
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (!this.multiline) {
                if (i < endIndex - 2) {
                    return false;
                }
                if (i == endIndex - 2) {
                    ch = seq.charAt(i);
                    if (ch != '\r') {
                        return false;
                    }
                    ch = seq.charAt(i + 1);
                    if (ch != '\n') {
                        return false;
                    }
                }
            }
            if (i < endIndex) {
                ch = seq.charAt(i);
                if (ch == '\n') {
                    if (i > 0 && seq.charAt(i - 1) == '\r') {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else if (ch == '\r' || ch == '\u0085' || (ch | '\u0001') == 8233) {
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static final class UnixDollar
    extends Node {
        boolean multiline;

        UnixDollar(boolean mul) {
            this.multiline = mul;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int endIndex;
            int n = endIndex = matcher.anchoringBounds ? matcher.to : matcher.getTextLength();
            if (i < endIndex) {
                char ch = seq.charAt(i);
                if (ch == '\n') {
                    if (!this.multiline && i != endIndex - 1) {
                        return false;
                    }
                    if (this.multiline) {
                        return this.next.match(matcher, i, seq);
                    }
                } else {
                    return false;
                }
            }
            matcher.hitEnd = true;
            matcher.requireEnd = true;
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            this.next.study(info);
            return info.deterministic;
        }
    }

    static class CharProperty
    extends Node {
        final CharPredicate predicate;

        CharProperty(CharPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int ch;
            if (i < matcher.to && (i += Character.charCount(ch = Character.codePointAt(seq, i))) <= matcher.to) {
                return this.predicate.is(ch) && this.next.match(matcher, i, seq);
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            ++info.minLength;
            ++info.maxLength;
            return this.next.study(info);
        }
    }

    private static class BmpCharProperty
    extends CharProperty {
        BmpCharProperty(BmpCharPredicate predicate) {
            super(predicate);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i < matcher.to) {
                return this.predicate.is(seq.charAt(i)) && this.next.match(matcher, i + 1, seq);
            }
            matcher.hitEnd = true;
            return false;
        }
    }

    static class SliceNode
    extends Node {
        int[] buffer;

        SliceNode(int[] buf) {
            this.buffer = buf;
        }

        @Override
        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxLength += this.buffer.length;
            return this.next.study(info);
        }
    }

    static class Slice
    extends SliceNode {
        Slice(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (buf[j] == seq.charAt(i + j)) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static class SliceI
    extends SliceNode {
        SliceI(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] == c || buf[j] == ASCII.toLower(c)) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static final class SliceU
    extends SliceNode {
        SliceU(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int len = buf.length;
            for (int j = 0; j < len; ++j) {
                if (i + j >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                char c = seq.charAt(i + j);
                if (buf[j] == c || buf[j] == Character.toLowerCase(Character.toUpperCase((int)c))) continue;
                return false;
            }
            return this.next.match(matcher, i + len, seq);
        }
    }

    static final class SliceS
    extends Slice {
        SliceS(int[] buf) {
            super(buf);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c) {
                    return false;
                }
                if ((x += Character.charCount(c)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, x, seq);
        }
    }

    static class SliceIS
    extends SliceNode {
        SliceIS(int[] buf) {
            super(buf);
        }

        int toLower(int c) {
            return ASCII.toLower(c);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] buf = this.buffer;
            int x = i;
            for (int j = 0; j < buf.length; ++j) {
                if (x >= matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                int c = Character.codePointAt(seq, x);
                if (buf[j] != c && buf[j] != this.toLower(c)) {
                    return false;
                }
                if ((x += Character.charCount(c)) <= matcher.to) continue;
                matcher.hitEnd = true;
                return false;
            }
            return this.next.match(matcher, x, seq);
        }
    }

    static final class SliceUS
    extends SliceIS {
        SliceUS(int[] buf) {
            super(buf);
        }

        @Override
        int toLower(int c) {
            return Character.toLowerCase(Character.toUpperCase(c));
        }
    }

    static final class Ques
    extends Node {
        Node atom;
        Qtype type;

        Ques(Node node, Qtype type) {
            this.atom = node;
            this.type = type;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            switch (this.type.ordinal()) {
                case 0: {
                    return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq) || this.next.match(matcher, i, seq);
                }
                case 1: {
                    return this.next.match(matcher, i, seq) || this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
                }
                case 2: {
                    if (this.atom.match(matcher, i, seq)) {
                        i = matcher.last;
                    }
                    return this.next.match(matcher, i, seq);
                }
            }
            return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            if (this.type != Qtype.INDEPENDENT) {
                int minL = info.minLength;
                this.atom.study(info);
                info.minLength = minL;
                info.deterministic = false;
                return this.next.study(info);
            }
            this.atom.study(info);
            return this.next.study(info);
        }
    }

    static final class Curly
    extends Node {
        Node atom;
        Qtype type;
        int cmin;
        int cmax;

        Curly(Node node, int cmin, int cmax, Qtype type) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j;
            for (j = 0; j < this.cmin; ++j) {
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                i = matcher.last;
            }
            if (this.type == Qtype.GREEDY) {
                return this.match0(matcher, i, j, seq);
            }
            if (this.type == Qtype.LAZY) {
                return this.match1(matcher, i, j, seq);
            }
            return this.match2(matcher, i, j, seq);
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int k;
            if (j >= this.cmax) {
                return this.next.match(matcher, i, seq);
            }
            int backLimit = j++;
            if (this.atom.match(matcher, i, seq) && (k = matcher.last - i) != 0) {
                i = matcher.last;
                while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                    if (i + k != matcher.last) {
                        if (!this.match0(matcher, matcher.last, j + 1, seq)) break;
                        return true;
                    }
                    i += k;
                    ++j;
                }
                while (j >= backLimit) {
                    if (this.next.match(matcher, i, seq)) {
                        return true;
                    }
                    i -= k;
                    --j;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq) && i != matcher.last) {
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class GroupCurly
    extends Node {
        Node atom;
        Qtype type;
        int cmin;
        int cmax;
        int localIndex;
        int groupIndex;
        boolean capture;

        GroupCurly(Node node, int cmin, int cmax, Qtype type, int local, int group, boolean capture) {
            this.atom = node;
            this.type = type;
            this.cmin = cmin;
            this.cmax = cmax;
            this.localIndex = local;
            this.groupIndex = group;
            this.capture = capture;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] groups = matcher.groups;
            int[] locals = matcher.locals;
            int save0 = locals[this.localIndex];
            int save1 = 0;
            int save2 = 0;
            if (this.capture) {
                save1 = groups[this.groupIndex];
                save2 = groups[this.groupIndex + 1];
            }
            locals[this.localIndex] = -1;
            boolean ret = true;
            for (int j = 0; j < this.cmin; ++j) {
                if (this.atom.match(matcher, i, seq)) {
                    if (this.capture) {
                        groups[this.groupIndex] = i;
                        groups[this.groupIndex + 1] = matcher.last;
                    }
                } else {
                    ret = false;
                    break;
                }
                i = matcher.last;
            }
            if (ret) {
                ret = this.type == Qtype.GREEDY ? this.match0(matcher, i, this.cmin, seq) : (this.type == Qtype.LAZY ? this.match1(matcher, i, this.cmin, seq) : this.match2(matcher, i, this.cmin, seq));
            }
            if (!ret) {
                locals[this.localIndex] = save0;
                if (this.capture) {
                    groups[this.groupIndex] = save1;
                    groups[this.groupIndex + 1] = save2;
                }
            }
            return ret;
        }

        boolean match0(Matcher matcher, int i, int j, CharSequence seq) {
            int min = j;
            int[] groups = matcher.groups;
            int save0 = 0;
            int save1 = 0;
            if (this.capture) {
                save0 = groups[this.groupIndex];
                save1 = groups[this.groupIndex + 1];
            }
            if (j < this.cmax && this.atom.match(matcher, i, seq)) {
                int k = matcher.last - i;
                if (k <= 0) {
                    if (this.capture) {
                        groups[this.groupIndex] = i;
                        groups[this.groupIndex + 1] = i + k;
                    }
                    i += k;
                } else {
                    block13: {
                        do {
                            if (this.capture) {
                                groups[this.groupIndex] = i;
                                groups[this.groupIndex + 1] = i + k;
                            }
                            if (++j >= this.cmax || !this.atom.match(matcher, i += k, seq)) break block13;
                        } while (i + k == matcher.last);
                        if (this.match0(matcher, i, j, seq)) {
                            return true;
                        }
                    }
                    while (j > min) {
                        if (this.next.match(matcher, i, seq)) {
                            if (this.capture) {
                                groups[this.groupIndex + 1] = i;
                                groups[this.groupIndex] = i - k;
                            }
                            return true;
                        }
                        i -= k;
                        if (this.capture) {
                            groups[this.groupIndex + 1] = i;
                            groups[this.groupIndex] = i - k;
                        }
                        --j;
                    }
                }
            }
            if (this.capture) {
                groups[this.groupIndex] = save0;
                groups[this.groupIndex + 1] = save1;
            }
            return this.next.match(matcher, i, seq);
        }

        boolean match1(Matcher matcher, int i, int j, CharSequence seq) {
            while (!this.next.match(matcher, i, seq)) {
                if (j >= this.cmax) {
                    return false;
                }
                if (!this.atom.match(matcher, i, seq)) {
                    return false;
                }
                if (i == matcher.last) {
                    return false;
                }
                if (this.capture) {
                    matcher.groups[this.groupIndex] = i;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                i = matcher.last;
                ++j;
            }
            return true;
        }

        boolean match2(Matcher matcher, int i, int j, CharSequence seq) {
            while (j < this.cmax && this.atom.match(matcher, i, seq)) {
                if (this.capture) {
                    matcher.groups[this.groupIndex] = i;
                    matcher.groups[this.groupIndex + 1] = matcher.last;
                }
                if (i == matcher.last) break;
                i = matcher.last;
                ++j;
            }
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            boolean detm = info.deterministic;
            info.reset();
            this.atom.study(info);
            int temp = info.minLength * this.cmin + minL;
            if (temp < minL) {
                temp = 0xFFFFFFF;
            }
            info.minLength = temp;
            if (maxV & info.maxValid) {
                info.maxLength = temp = info.maxLength * this.cmax + maxL;
                if (temp < maxL) {
                    info.maxValid = false;
                }
            } else {
                info.maxValid = false;
            }
            info.deterministic = info.deterministic && this.cmin == this.cmax ? detm : false;
            return this.next.study(info);
        }
    }

    static final class BranchConn
    extends Node {
        BranchConn() {
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            return info.deterministic;
        }
    }

    static final class Branch
    extends Node {
        Node[] atoms = new Node[2];
        int size = 2;
        Node conn;

        Branch(Node first, Node second, Node branchConn) {
            this.conn = branchConn;
            this.atoms[0] = first;
            this.atoms[1] = second;
        }

        void add(Node node) {
            if (this.size >= this.atoms.length) {
                Node[] tmp = new Node[this.atoms.length * 2];
                System.arraycopy(this.atoms, 0, tmp, 0, this.atoms.length);
                this.atoms = tmp;
            }
            this.atoms[this.size++] = node;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            for (int n = 0; n < this.size; ++n) {
                if (!(this.atoms[n] == null ? this.conn.next.match(matcher, i, seq) : this.atoms[n].match(matcher, i, seq))) continue;
                return true;
            }
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            int minL = info.minLength;
            int maxL = info.maxLength;
            boolean maxV = info.maxValid;
            int minL2 = Integer.MAX_VALUE;
            int maxL2 = -1;
            for (int n = 0; n < this.size; ++n) {
                info.reset();
                if (this.atoms[n] != null) {
                    this.atoms[n].study(info);
                }
                minL2 = Math.min(minL2, info.minLength);
                maxL2 = Math.max(maxL2, info.maxLength);
                maxV &= info.maxValid;
            }
            info.reset();
            this.conn.next.study(info);
            info.minLength += (minL += minL2);
            info.maxLength += (maxL += maxL2);
            info.maxValid &= maxV;
            info.deterministic = false;
            return false;
        }
    }

    static final class GroupHead
    extends Node {
        int localIndex;
        GroupTail tail;

        GroupHead(int localCount) {
            this.localIndex = localCount;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.localIndex];
            matcher.locals[this.localIndex] = i;
            boolean ret = this.next.match(matcher, i, seq);
            matcher.locals[this.localIndex] = save;
            return ret;
        }
    }

    static final class GroupTail
    extends Node {
        int localIndex;
        int groupIndex;

        GroupTail(int localCount, int groupCount) {
            this.localIndex = localCount;
            this.groupIndex = groupCount + groupCount;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int tmp = matcher.locals[this.localIndex];
            if (tmp >= 0) {
                int groupStart = matcher.groups[this.groupIndex];
                int groupEnd = matcher.groups[this.groupIndex + 1];
                matcher.groups[this.groupIndex] = tmp;
                matcher.groups[this.groupIndex + 1] = i;
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                matcher.groups[this.groupIndex] = groupStart;
                matcher.groups[this.groupIndex + 1] = groupEnd;
                return false;
            }
            matcher.last = i;
            return true;
        }
    }

    static final class Prolog
    extends Node {
        Loop loop;

        Prolog(Loop loop) {
            this.loop = loop;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return this.loop.matchInit(matcher, i, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            return this.loop.study(info);
        }
    }

    static class Loop
    extends Node {
        Node body;
        int countIndex;
        int beginIndex;
        int cmin;
        int cmax;
        int posIndex;

        Loop(int countIndex, int beginIndex) {
            this.countIndex = countIndex;
            this.beginIndex = beginIndex;
            this.posIndex = -1;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (!b) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return b;
                }
                if (count < this.cmax) {
                    if (this.posIndex != -1 && matcher.localsPos[this.posIndex].contains(i)) {
                        return this.next.match(matcher, i, seq);
                    }
                    matcher.locals[this.countIndex] = count + 1;
                    boolean b = this.body.match(matcher, i, seq);
                    if (b) {
                        return true;
                    }
                    matcher.locals[this.countIndex] = count;
                    if (this.posIndex != -1) {
                        matcher.localsPos[this.posIndex].add(i);
                    }
                }
            }
            return this.next.match(matcher, i, seq);
        }

        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            boolean ret;
            int save = matcher.locals[this.countIndex];
            if (this.posIndex != -1 && matcher.localsPos[this.posIndex] == null) {
                matcher.localsPos[this.posIndex] = new IntHashSet();
            }
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
                if (!ret) {
                    ret = this.next.match(matcher, i, seq);
                }
            } else {
                ret = this.next.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static final class LazyLoop
    extends Loop {
        LazyLoop(int countIndex, int beginIndex) {
            super(countIndex, beginIndex);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (i > matcher.locals[this.beginIndex]) {
                int count = matcher.locals[this.countIndex];
                if (count < this.cmin) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                if (this.next.match(matcher, i, seq)) {
                    return true;
                }
                if (count < this.cmax) {
                    matcher.locals[this.countIndex] = count + 1;
                    boolean result = this.body.match(matcher, i, seq);
                    if (!result) {
                        matcher.locals[this.countIndex] = count;
                    }
                    return result;
                }
                return false;
            }
            return this.next.match(matcher, i, seq);
        }

        @Override
        boolean matchInit(Matcher matcher, int i, CharSequence seq) {
            int save = matcher.locals[this.countIndex];
            boolean ret = false;
            if (0 < this.cmin) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            } else if (this.next.match(matcher, i, seq)) {
                ret = true;
            } else if (0 < this.cmax) {
                matcher.locals[this.countIndex] = 1;
                ret = this.body.match(matcher, i, seq);
            }
            matcher.locals[this.countIndex] = save;
            return ret;
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            info.deterministic = false;
            return false;
        }
    }

    static class BackRef
    extends Node {
        int groupIndex;

        BackRef(int groupCount) {
            this.groupIndex = groupCount + groupCount;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSize = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSize > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            for (int index = 0; index < groupSize; ++index) {
                if (seq.charAt(i + index) == seq.charAt(j + index)) continue;
                return false;
            }
            return this.next.match(matcher, i + groupSize, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static class CIBackRef
    extends Node {
        int groupIndex;
        boolean doUnicodeCase;

        CIBackRef(int groupCount, boolean doUnicodeCase) {
            this.groupIndex = groupCount + groupCount;
            this.doUnicodeCase = doUnicodeCase;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int j = matcher.groups[this.groupIndex];
            int k = matcher.groups[this.groupIndex + 1];
            int groupSizeChars = k - j;
            if (j < 0) {
                return false;
            }
            if (i + groupSizeChars > matcher.to) {
                matcher.hitEnd = true;
                return false;
            }
            int x = i;
            int groupCodepoints = groupSizeChars;
            for (int index = 0; index < groupCodepoints; ++index) {
                int cc2;
                int cc1;
                int c2;
                int c1 = Character.codePointAt(seq, x);
                if (c1 != (c2 = Character.codePointAt(seq, j)) && (this.doUnicodeCase ? (cc1 = Character.toUpperCase(c1)) != (cc2 = Character.toUpperCase(c2)) && Character.toLowerCase(cc1) != Character.toLowerCase(cc2) : ASCII.toLower(c1) != ASCII.toLower(c2))) {
                    return false;
                }
                x += Character.charCount(c1);
                j += Character.charCount(c2);
                if (c1 < 65536) continue;
                --groupCodepoints;
            }
            return this.next.match(matcher, i + groupSizeChars, seq);
        }

        @Override
        boolean study(TreeInfo info) {
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class First
    extends Node {
        Node atom;

        First(Node node) {
            this.atom = BnM.optimize(node);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            if (this.atom instanceof BnM) {
                return this.atom.match(matcher, i, seq) && this.next.match(matcher, matcher.last, seq);
            }
            while (true) {
                if (i > matcher.to) {
                    matcher.hitEnd = true;
                    return false;
                }
                if (this.atom.match(matcher, i, seq)) {
                    return this.next.match(matcher, matcher.last, seq);
                }
                i += Pattern.countChars(seq, i, 1);
                ++matcher.first;
            }
        }

        @Override
        boolean study(TreeInfo info) {
            this.atom.study(info);
            info.maxValid = false;
            info.deterministic = false;
            return this.next.study(info);
        }
    }

    static final class Pos
    extends Node {
        Node cond;

        Pos(Node cond) {
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            boolean conditionMatched;
            int savedTo = matcher.to;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                conditionMatched = this.cond.match(matcher, i, seq);
            }
            finally {
                matcher.to = savedTo;
            }
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class Neg
    extends Node {
        Node cond;

        Neg(Node cond) {
            this.cond = cond;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            boolean conditionMatched;
            int savedTo = matcher.to;
            if (matcher.transparentBounds) {
                matcher.to = matcher.getTextLength();
            }
            try {
                if (i < matcher.to) {
                    conditionMatched = !this.cond.match(matcher, i, seq);
                } else {
                    matcher.requireEnd = true;
                    conditionMatched = !this.cond.match(matcher, i, seq);
                }
            }
            finally {
                matcher.to = savedTo;
            }
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static class Behind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        Behind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class BehindS
    extends Behind {
        BehindS(Node cond, int rmax, int rmin) {
            super(cond, rmax, rmin);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            boolean conditionMatched = false;
            int from = Math.max(i - rmaxChars, startIndex);
            int savedLBT = matcher.lookbehindTo;
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static class NotBehind
    extends Node {
        Node cond;
        int rmax;
        int rmin;

        NotBehind(Node cond, int rmax, int rmin) {
            this.cond = cond;
            this.rmax = rmax;
            this.rmin = rmin;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int savedLBT = matcher.lookbehindTo;
            int savedFrom = matcher.from;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - this.rmax, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - this.rmin; !conditionMatched && j >= from; --j) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return !conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class NotBehindS
    extends NotBehind {
        NotBehindS(Node cond, int rmax, int rmin) {
            super(cond, rmax, rmin);
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int rmaxChars = Pattern.countChars(seq, i, -this.rmax);
            int rminChars = Pattern.countChars(seq, i, -this.rmin);
            int savedFrom = matcher.from;
            int savedLBT = matcher.lookbehindTo;
            boolean conditionMatched = false;
            int startIndex = !matcher.transparentBounds ? matcher.from : 0;
            int from = Math.max(i - rmaxChars, startIndex);
            matcher.lookbehindTo = i;
            if (matcher.transparentBounds) {
                matcher.from = 0;
            }
            for (int j = i - rminChars; !conditionMatched && j >= from; j -= j > from ? Pattern.countChars(seq, j, -1) : 1) {
                conditionMatched = this.cond.match(matcher, j, seq);
            }
            matcher.from = savedFrom;
            matcher.lookbehindTo = savedLBT;
            return !conditionMatched && this.next.match(matcher, i, seq);
        }
    }

    static final class Bound
    extends Node {
        static int LEFT = 1;
        static int RIGHT = 2;
        static int BOTH = 3;
        static int NONE = 4;
        int type;
        boolean useUWORD;

        Bound(int n, boolean useUWORD) {
            this.type = n;
            this.useUWORD = useUWORD;
        }

        boolean isWord(int ch) {
            return this.useUWORD ? CharPredicates.WORD().is(ch) : CharPredicates.ASCII_WORD().is(ch);
        }

        int check(Matcher matcher, int i, CharSequence seq) {
            int ch;
            boolean left = false;
            int startIndex = matcher.from;
            int endIndex = matcher.to;
            if (matcher.transparentBounds) {
                startIndex = 0;
                endIndex = matcher.getTextLength();
            }
            if (i > startIndex) {
                ch = Character.codePointBefore(seq, i);
                left = this.isWord(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i - 1, seq);
            }
            boolean right = false;
            if (i < endIndex) {
                ch = Character.codePointAt(seq, i);
                right = this.isWord(ch) || Character.getType(ch) == 6 && Pattern.hasBaseCharacter(matcher, i, seq);
            } else {
                matcher.hitEnd = true;
                matcher.requireEnd = true;
            }
            return left ^ right ? (right ? LEFT : RIGHT) : NONE;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            return (this.check(matcher, i, seq) & this.type) > 0 && this.next.match(matcher, i, seq);
        }
    }

    static class BnM
    extends Node {
        int[] buffer;
        int[] lastOcc;
        int[] optoSft;

        static Node optimize(Node node) {
            int i;
            if (!(node instanceof Slice)) {
                return node;
            }
            int[] src = ((Slice)node).buffer;
            int patternLength = src.length;
            if (patternLength < 4) {
                return node;
            }
            int[] lastOcc = new int[128];
            int[] optoSft = new int[patternLength];
            for (i = 0; i < patternLength; ++i) {
                lastOcc[src[i] & 0x7F] = i + 1;
            }
            block1: for (i = patternLength; i > 0; --i) {
                int j;
                for (j = patternLength - 1; j >= i; --j) {
                    if (src[j] != src[j - i]) continue block1;
                    optoSft[j - 1] = i;
                }
                while (j > 0) {
                    optoSft[--j] = i;
                }
            }
            optoSft[patternLength - 1] = 1;
            if (node instanceof SliceS) {
                return new BnMS(src, lastOcc, optoSft, node.next);
            }
            return new BnM(src, lastOcc, optoSft, node.next);
        }

        BnM(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            this.buffer = src;
            this.lastOcc = lastOcc;
            this.optoSft = optoSft;
            this.next = next;
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - patternLength;
            block0: while (i <= last) {
                for (int j = patternLength - 1; j >= 0; --j) {
                    char ch = seq.charAt(i + j);
                    if (ch == src[j]) continue;
                    i += Math.max(j + 1 - this.lastOcc[ch & 0x7F], this.optoSft[j]);
                    continue block0;
                }
                matcher.first = i;
                boolean ret = this.next.match(matcher, i + patternLength, seq);
                if (ret) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                ++i;
            }
            matcher.hitEnd = true;
            return false;
        }

        @Override
        boolean study(TreeInfo info) {
            info.minLength += this.buffer.length;
            info.maxValid = false;
            return this.next.study(info);
        }
    }

    static final class BnMS
    extends BnM {
        int lengthInChars;

        BnMS(int[] src, int[] lastOcc, int[] optoSft, Node next) {
            super(src, lastOcc, optoSft, next);
            for (int cp : this.buffer) {
                this.lengthInChars += Character.charCount(cp);
            }
        }

        @Override
        boolean match(Matcher matcher, int i, CharSequence seq) {
            int[] src = this.buffer;
            int patternLength = src.length;
            int last = matcher.to - this.lengthInChars;
            block0: while (i <= last) {
                int j = Pattern.countChars(seq, i, patternLength);
                int x = patternLength - 1;
                while (j > 0) {
                    int ch = Character.codePointBefore(seq, i + j);
                    if (ch != src[x]) {
                        int n = Math.max(x + 1 - this.lastOcc[ch & 0x7F], this.optoSft[x]);
                        i += Pattern.countChars(seq, i, n);
                        continue block0;
                    }
                    j -= Character.charCount(ch);
                    --x;
                }
                matcher.first = i;
                boolean ret = this.next.match(matcher, i + this.lengthInChars, seq);
                if (ret) {
                    matcher.groups[0] = matcher.first = i;
                    matcher.groups[1] = matcher.last;
                    return true;
                }
                i += Pattern.countChars(seq, i, 1);
            }
            matcher.hitEnd = true;
            return false;
        }
    }
}

