/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.block;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.dataflow.cfg.block.Block;
import org.plumelib.util.ArraySet;

public abstract class BlockImpl
implements Block {
    protected final Block.BlockType type;
    protected final Set<BlockImpl> predecessors;
    private static final AtomicLong nextUid = new AtomicLong(0L);
    private final transient long uid = nextUid.getAndIncrement();

    public long getUid(@UnknownInitialization BlockImpl this) {
        return this.uid;
    }

    protected BlockImpl(Block.BlockType type) {
        this.type = type;
        this.predecessors = new ArraySet(2);
    }

    @Override
    public Block.BlockType getType() {
        return this.type;
    }

    @Override
    public Set<Block> getPredecessors() {
        return new ArraySet(this.predecessors);
    }

    public void addPredecessor(BlockImpl pred) {
        this.predecessors.add(pred);
    }

    public void removePredecessor(BlockImpl pred) {
        this.predecessors.remove(pred);
    }
}

