/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil.javacparse;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

class FileJavaFileObject
extends SimpleJavaFileObject {
    private String javaCode;

    public FileJavaFileObject(String filename) throws IOException {
        super(Path.of(filename, new String[0]).toUri(), JavaFileObject.Kind.SOURCE);
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException("file does not exist: " + filename);
        }
        if (!file.canRead()) {
            throw new IOException("cannot read file: " + filename);
        }
        this.javaCode = new String(Files.readAllBytes(Path.of(filename, new String[0])), Charset.defaultCharset());
    }

    public FileJavaFileObject(Path pathname) throws IOException {
        this(pathname.toString());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
        return this.javaCode;
    }
}

