/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.ThrowTree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.node.Node;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;

public class ThrowNode
extends Node {
    protected final ThrowTree tree;
    protected final Node expression;

    public ThrowNode(ThrowTree tree, Node expression, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.expression = expression;
    }

    public Node getExpression() {
        return this.expression;
    }

    @Override
    public ThrowTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitThrow(this, p);
    }

    public String toString() {
        return "throw " + this.expression;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ThrowNode)) {
            return false;
        }
        ThrowNode other = (ThrowNode)obj;
        return this.getExpression().equals(other.getExpression());
    }

    public int hashCode() {
        return Objects.hash(ThrowNode.class, this.expression);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.expression);
    }
}

