/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.com.google.common.collect;

import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.NonNegative;
import org.checkerframework.shaded.checker.index.qual.Positive;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.shaded.com.google.common.annotations.GwtCompatible;
import org.checkerframework.shaded.com.google.common.base.Preconditions;
import org.checkerframework.shaded.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.shaded.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(@UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized Object key, @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized Object value) {
        if (key == null) {
            throw new NullPointerException("null key in entry: null=" + value);
        }
        if (value == null) {
            throw new NullPointerException("null value in entry: " + key + "=null");
        }
    }

    @CanIgnoreReturnValue
    static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int checkNonnegative(@NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int value, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    @CanIgnoreReturnValue
    static @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long checkNonnegative(@NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed long value, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String name) {
        if (value < 0L) {
            throw new IllegalArgumentException(name + " cannot be negative but was: " + value);
        }
        return value;
    }

    static void checkPositive(@Positive @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int value, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed String name) {
        if (value <= 0) {
            throw new IllegalArgumentException(name + " must be positive but was: " + value);
        }
    }

    static void checkRemove(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

