/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.expression;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.shaded.checker.formatter.qual.ConversionCategory;
import org.checkerframework.shaded.checker.formatter.qual.Format;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.shaded.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.expression.ArrayAccess;
import org.checkerframework.shaded.dataflow.expression.ArrayCreation;
import org.checkerframework.shaded.dataflow.expression.BinaryOperation;
import org.checkerframework.shaded.dataflow.expression.ClassName;
import org.checkerframework.shaded.dataflow.expression.FieldAccess;
import org.checkerframework.shaded.dataflow.expression.FormalParameter;
import org.checkerframework.shaded.dataflow.expression.JavaExpression;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionParseException;
import org.checkerframework.shaded.dataflow.expression.JavaExpressionParseUtil;
import org.checkerframework.shaded.dataflow.expression.LocalVariable;
import org.checkerframework.shaded.dataflow.expression.MethodCall;
import org.checkerframework.shaded.dataflow.expression.SuperReference;
import org.checkerframework.shaded.dataflow.expression.ThisReference;
import org.checkerframework.shaded.dataflow.expression.UnaryOperation;
import org.checkerframework.shaded.dataflow.expression.ValueLiteral;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.ElementUtils;
import org.checkerframework.shaded.javacutil.Resolver;
import org.checkerframework.shaded.javacutil.TypesUtils;
import org.checkerframework.shaded.javacutil.javacparse.JavacParse;
import org.checkerframework.shaded.javacutil.javacparse.JavacParseResult;
import org.checkerframework.shaded.javacutil.trees.TreeBuilder;
import org.checkerframework.shaded.org.plumelib.util.CollectionsPlume;

class ExpressionTreeToJavaExpressionVisitor
extends SimpleTreeVisitor<JavaExpression, Void> {
    public static final @Format(value={ConversionCategory.INT, ConversionCategory.GENERAL}) String FORMAL_PARAM_NAME_STRING = "Use \"#%d\" rather than \"%s\"";
    private static final Set<Tree.Kind> COMPARISON_OPERATORS = EnumSet.of(Tree.Kind.EQUAL_TO, new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_EQUAL});
    private final ProcessingEnvironment env;
    private final Types types;
    private @MonotonicNonNull Resolver resolver = null;
    private final TypeMirror stringTypeMirror;
    private final TypeMirror booleanTypeMirror;
    private final TreePath pathToCompilationUnit;
    private final @Nullable TreePath localVarPath;
    private final TypeMirror enclosingType;
    private final @Nullable ThisReference thisReference;
    private final @Nullable List<FormalParameter> parameters;

    private ExpressionTreeToJavaExpressionVisitor(TypeMirror enclosingType, @Nullable ThisReference thisReference, @Nullable List<FormalParameter> parameters, @Nullable TreePath localVarPath, TreePath pathToCompilationUnit, ProcessingEnvironment env) {
        this.pathToCompilationUnit = pathToCompilationUnit;
        this.localVarPath = localVarPath;
        this.env = env;
        this.types = env.getTypeUtils();
        this.stringTypeMirror = ElementUtils.getTypeElement(env, String.class).asType();
        this.booleanTypeMirror = this.types.getPrimitiveType(TypeKind.BOOLEAN);
        this.enclosingType = enclosingType;
        this.thisReference = thisReference;
        this.parameters = parameters;
    }

    public static JavaExpression convert(ExpressionTree exprTree, TypeMirror enclosingType, @Nullable ThisReference thisReference, @Nullable List<FormalParameter> parameters, @Nullable TreePath localVarPath, TreePath pathToCompilationUnit, ProcessingEnvironment env) throws JavaExpressionParseException {
        try {
            return exprTree.accept(new ExpressionTreeToJavaExpressionVisitor(enclosingType, thisReference, parameters, localVarPath, pathToCompilationUnit, env), null);
        }
        catch (JavaExpressionParseException.JavaExpressionParseExceptionUnchecked e) {
            throw e.getCheckedException();
        }
    }

    @EnsuresNonNull(value={"resolver"})
    private void setResolverField() {
        if (this.resolver == null) {
            this.resolver = new Resolver(this.env);
        }
    }

    @Override
    public JavaExpression defaultAction(Tree treeNode, Void unused) {
        throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(treeNode.toString(), "ExpressionTreeToJavaExpressionVisitor has no override for " + treeNode.getClass().getSimpleName()));
    }

    @Override
    public JavaExpression visitLiteral(LiteralTree exprTree, Void unused) {
        TypeMirror type;
        Object value = exprTree.getValue();
        if (value == null) {
            type = this.types.getNullType();
        } else if (value instanceof Integer) {
            type = this.types.getPrimitiveType(TypeKind.INT);
        } else if (value instanceof Boolean) {
            type = this.types.getPrimitiveType(TypeKind.BOOLEAN);
        } else if (value instanceof Long) {
            type = this.types.getPrimitiveType(TypeKind.LONG);
        } else if (value instanceof Double) {
            type = this.types.getPrimitiveType(TypeKind.DOUBLE);
        } else if (value instanceof Float) {
            type = this.types.getPrimitiveType(TypeKind.FLOAT);
        } else if (value instanceof Character) {
            type = this.types.getPrimitiveType(TypeKind.CHAR);
        } else if (value instanceof String) {
            type = this.stringTypeMirror;
        } else {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(value.toString(), "Unsupported literal type: " + value.getClass()));
        }
        return new ValueLiteral(type, value);
    }

    @Override
    public JavaExpression visitParenthesized(ParenthesizedTree exprTree, Void unused) {
        return exprTree.getExpression().accept(this, null);
    }

    @Override
    public JavaExpression visitArrayAccess(ArrayAccessTree exprTree, Void unused) {
        JavaExpression array = exprTree.getExpression().accept(this, null);
        TypeMirror arrayType = array.getType();
        if (arrayType.getKind() != TypeKind.ARRAY) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), String.format("expected an array, found %s of type %s [%s]", new Object[]{array, arrayType, arrayType.getKind()})));
        }
        Type componentType = ((Type.ArrayType)arrayType).getComponentType();
        JavaExpression index = exprTree.getIndex().accept(this, null);
        return new ArrayAccess(componentType, array, index);
    }

    @Override
    public JavaExpression visitIdentifier(IdentifierTree idTree, Void unused) {
        Element classElem;
        TypeMirror classType;
        VariableElement varElem;
        this.setResolverField();
        String idName = idTree.getName().toString();
        if (idName.equals("this") || idName.equals("super")) {
            if (this.thisReference == null) {
                throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(idName, "\"" + idName + "\" is not allowed here"));
            }
            if (idName.equals("this")) {
                return this.thisReference;
            }
            TypeMirror superclass = TypesUtils.getSuperclass(this.enclosingType, this.types);
            if (superclass == null) {
                throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct("super", this.enclosingType + " has no superclass"));
            }
            return new SuperReference(superclass);
        }
        JavaExpression parameter = this.parseAsParameter(idName);
        if (parameter != null) {
            return parameter;
        }
        if (this.localVarPath != null && (varElem = this.resolver.findLocalVariableOrParameter(idName, this.localVarPath)) != null) {
            return new LocalVariable(varElem);
        }
        JavaExpression fieldAccessReceiver = this.thisReference != null ? this.thisReference : new ClassName(this.enclosingType);
        FieldAccess fieldAccess = this.getIdentifierAsFieldAccess(fieldAccessReceiver, idName);
        if (fieldAccess != null) {
            return fieldAccess;
        }
        if (this.localVarPath != null && (classType = ElementUtils.getType(classElem = this.resolver.findClass(idName, this.localVarPath))) != null) {
            return new ClassName(classType);
        }
        ClassName classType2 = this.getIdentifierAsUnqualifiedClassName(idName);
        if (classType2 != null) {
            return classType2;
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                VariableElement varElt = this.parameters.get(i).getElement();
                if (!varElt.getSimpleName().contentEquals(idName)) continue;
                throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(idName, String.format(FORMAL_PARAM_NAME_STRING, i + 1, idName)));
            }
        }
        throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(idName, "identifier not found"));
    }

    private @Nullable JavaExpression parseAsParameter(String s) {
        if (!s.startsWith("_param_")) {
            return null;
        }
        int idx = Integer.parseInt(s.substring(JavaExpressionParseUtil.PARAMETER_PREFIX_LENGTH));
        if (idx == 0) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct("#0", "Use \"this\" for the receiver or \"#1\" for the first formal parameter"));
        }
        if (this.parameters == null) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(s, "no parameters found"));
        }
        if (idx > this.parameters.size()) {
            JavaExpressionParseException jepe = new JavaExpressionParseException("flowexpr.parse.index.too.big", Integer.toString(idx), Integer.toString(this.parameters.size()));
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(jepe);
        }
        return this.parameters.get(idx - 1);
    }

    @Override
    public JavaExpression visitPrimitiveType(PrimitiveTypeTree node, Void unused) {
        TypeKind typeKind = node.getPrimitiveTypeKind();
        if (typeKind == TypeKind.VOID) {
            return new ClassName(this.types.getNoType(typeKind));
        }
        return new ClassName(this.types.getPrimitiveType(typeKind));
    }

    @Override
    public JavaExpression visitArrayType(ArrayTypeTree node, Void unused) {
        Tree elementTypeTree = node.getType();
        JavaExpression elementTypeJE = elementTypeTree.accept(this, null);
        if (elementTypeJE instanceof ClassName) {
            return new ClassName(this.types.getArrayType(((ClassName)elementTypeJE).getType()));
        }
        throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(node.toString(), "array element type is " + elementTypeJE.getClass().getSimpleName()));
    }

    protected @Nullable ClassName getIdentifierAsInnerClassName(TypeMirror type, String identifier) {
        if (type.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element outerClass = ((DeclaredType)type).asElement();
        for (Element element : outerClass.getEnclosedElements()) {
            if (!element.getKind().isClass() && !element.getKind().isInterface() || !element.getSimpleName().contentEquals(identifier)) continue;
            return new ClassName(ElementUtils.getType(element));
        }
        return null;
    }

    protected @Nullable ClassName getIdentifierAsUnqualifiedClassName(String identifier) {
        TypeMirror classType;
        PackageElement pkg;
        Symbol.PackageSymbol packageSymbol;
        Symbol.ClassSymbol classSymbol;
        TypeMirror searchType = this.enclosingType;
        while (searchType.getKind() == TypeKind.DECLARED) {
            DeclaredType searchDeclaredType = (DeclaredType)searchType;
            if (searchDeclaredType.asElement().getSimpleName().contentEquals(identifier)) {
                return new ClassName(searchType);
            }
            ClassName className = this.getIdentifierAsInnerClassName(searchType, identifier);
            if (className != null) {
                return className;
            }
            searchType = ExpressionTreeToJavaExpressionVisitor.getTypeOfEnclosingClass(searchDeclaredType);
        }
        this.setResolverField();
        if (this.enclosingType.getKind() == TypeKind.DECLARED && (classSymbol = this.resolver.findClassInPackage(identifier, packageSymbol = (Symbol.PackageSymbol)ElementUtils.enclosingPackage(((DeclaredType)this.enclosingType).asElement()), this.pathToCompilationUnit)) != null) {
            return new ClassName(classSymbol.asType());
        }
        packageSymbol = this.resolver.findPackage("java.lang", this.pathToCompilationUnit);
        if (packageSymbol == null) {
            throw new BugInCF("Can't find the java.lang package.");
        }
        classSymbol = this.resolver.findClassInPackage(identifier, packageSymbol, this.pathToCompilationUnit);
        if (classSymbol != null) {
            return new ClassName(classSymbol.asType());
        }
        Element classElem = this.resolver.findClass(identifier, this.pathToCompilationUnit);
        if (classElem != null && (pkg = ElementUtils.enclosingPackage(classElem)) != null && pkg.isUnnamed() && (classType = ElementUtils.getType(classElem)) != null) {
            return new ClassName(classType);
        }
        return null;
    }

    protected @Nullable FieldAccess getIdentifierAsFieldAccess(JavaExpression receiverExpr, String identifier) {
        boolean fieldDeclaredInReceiverType;
        VariableElement fieldElem;
        this.setResolverField();
        TypeMirror enclosingTypeOfField = receiverExpr.getType();
        if (identifier.equals("length") && enclosingTypeOfField.getKind() == TypeKind.ARRAY) {
            fieldElem = this.resolver.findField(identifier, enclosingTypeOfField, this.pathToCompilationUnit);
            if (fieldElem == null) {
                throw new BugInCF("length field not found for type %s", enclosingTypeOfField);
            }
        } else {
            VariableElement thisFieldElem;
            fieldElem = null;
            while (enclosingTypeOfField.getKind() == TypeKind.DECLARED && (fieldElem = this.resolver.findField(identifier, enclosingTypeOfField, this.pathToCompilationUnit)) == null) {
                enclosingTypeOfField = ExpressionTreeToJavaExpressionVisitor.getTypeOfEnclosingClass((DeclaredType)enclosingTypeOfField);
            }
            if (fieldElem == null) {
                return null;
            }
            if (receiverExpr instanceof SuperReference && this.thisReference != null && this.thisReference.getType().getKind() == TypeKind.DECLARED && (thisFieldElem = this.resolver.findField(identifier, this.thisReference.getType(), this.pathToCompilationUnit)) == null) {
                receiverExpr = this.thisReference;
            }
        }
        if (ElementUtils.isStatic(fieldElem)) {
            Element classElem = fieldElem.getEnclosingElement();
            ClassName staticClassReceiver = new ClassName(ElementUtils.getType(classElem));
            return new FieldAccess((JavaExpression)staticClassReceiver, fieldElem);
        }
        if (receiverExpr instanceof ClassName) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(identifier.toString(), "a non-static field " + fieldElem.getSimpleName().toString() + " cannot have a class name " + receiverExpr + " as a receiver."));
        }
        boolean bl = fieldDeclaredInReceiverType = enclosingTypeOfField == receiverExpr.getType();
        if (fieldDeclaredInReceiverType) {
            TypeMirror fieldType = ElementUtils.getType(fieldElem);
            return new FieldAccess(receiverExpr, fieldType, fieldElem);
        }
        if (!(receiverExpr instanceof ThisReference)) {
            String msg = String.format("%s is declared in an outer type of the type of the receiver expression, %s.", identifier, receiverExpr);
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(identifier, msg));
        }
        TypeElement receiverTypeElement = TypesUtils.getTypeElement(receiverExpr.getType());
        if (receiverTypeElement == null || ElementUtils.isStatic(receiverTypeElement)) {
            String msg = String.format("%s is a non-static field declared in an outer type this.", identifier);
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(identifier, msg));
        }
        ThisReference locationOfField = new ThisReference(enclosingTypeOfField);
        return new FieldAccess((JavaExpression)locationOfField, fieldElem);
    }

    @Override
    public JavaExpression visitMethodInvocation(MethodInvocationTree invocation, Void unused) {
        JavaExpression receiverExpr;
        boolean isInstance;
        ExecutableElement methodElement;
        String methodName;
        TypeMirror receiverType;
        JavaExpression receiverExprTmp;
        this.setResolverField();
        ExpressionTree methodSelect = invocation.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree) {
            MemberSelectTree memberSelect = (MemberSelectTree)methodSelect;
            receiverExprTmp = memberSelect.getExpression().accept(this, null);
            receiverType = receiverExprTmp.getType();
            methodName = memberSelect.getIdentifier().toString();
        } else if (methodSelect instanceof IdentifierTree) {
            methodName = ((IdentifierTree)methodSelect).getName().toString();
            receiverExprTmp = null;
            receiverType = this.enclosingType;
        } else {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(invocation.toString(), "unsupported method invocation syntax"));
        }
        List<JavaExpression> arguments = CollectionsPlume.mapList(argument -> argument.accept(this, null), invocation.getArguments());
        try {
            methodElement = this.getMethodElement(methodName, receiverType, this.pathToCompilationUnit, arguments, this.resolver);
        }
        catch (JavaExpressionParseException e) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(e);
        }
        for (int i = 0; i < arguments.size(); ++i) {
            VariableElement parameter = methodElement.getParameters().get(i);
            TypeMirror parameterType = parameter.asType();
            JavaExpression argument2 = arguments.get(i);
            TypeMirror argumentType = argument2.getType();
            if (!TypesUtils.isBoxedPrimitive(parameterType) || !TypesUtils.isPrimitive(argumentType)) continue;
            Symbol.MethodSymbol valueOfMethod = TreeBuilder.getValueOfMethod(this.env, parameterType);
            MethodCall boxedParam = new MethodCall(parameterType, valueOfMethod, new ClassName(parameterType), Collections.singletonList(argument2));
            arguments.set(i, boxedParam);
        }
        boolean isStatic = ElementUtils.isStatic(methodElement);
        boolean bl = isInstance = !isStatic;
        if (methodSelect instanceof MemberSelectTree) {
            assert (receiverExprTmp != null) : "@AssumeAssertion(nullness): established in `if` above";
            receiverExpr = receiverExprTmp;
            if (isInstance && receiverExpr instanceof ClassName) {
                throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(invocation.toString(), "Use a value, not a class name, as the receiver when calling an instance method"));
            }
            if (isStatic && !(receiverExpr instanceof ClassName)) {
                receiverExpr = new ClassName(receiverExpr.getType());
            }
        } else if (methodSelect instanceof IdentifierTree) {
            if (isInstance) {
                assert (this.thisReference != null) : "@AssumeAssertion(nullness): isInstance => thisReference";
                receiverExpr = this.thisReference;
            } else {
                Element classElem = methodElement.getEnclosingElement();
                receiverExpr = new ClassName(ElementUtils.getType(classElem));
            }
            receiverType = receiverExpr.getType();
        } else {
            throw new BugInCF("this can't happen");
        }
        TypeMirror returnType = isInstance ? TypesUtils.substituteMethodReturnType(methodElement, receiverType, this.env) : ElementUtils.getType(methodElement);
        return new MethodCall(returnType, methodElement, receiverExpr, arguments);
    }

    private ExecutableElement getMethodElement(String methodName, TypeMirror receiverType, TreePath pathToCompilationUnit, List<JavaExpression> arguments, Resolver resolver) throws JavaExpressionParseException {
        List<TypeMirror> argumentTypes = CollectionsPlume.mapList(JavaExpression::getType, arguments);
        if (receiverType.getKind() == TypeKind.ARRAY) {
            ExecutableElement element = resolver.findMethod(methodName, receiverType, pathToCompilationUnit, argumentTypes);
            if (element == null) {
                throw JavaExpressionParseException.construct(methodName, "no such method");
            }
            return element;
        }
        while (receiverType.getKind() == TypeKind.DECLARED) {
            ExecutableElement element = resolver.findMethod(methodName, receiverType, pathToCompilationUnit, argumentTypes);
            if (element != null) {
                return element;
            }
            receiverType = ExpressionTreeToJavaExpressionVisitor.getTypeOfEnclosingClass((DeclaredType)receiverType);
        }
        throw JavaExpressionParseException.construct(methodName, "no such method");
    }

    @Override
    public JavaExpression visitMemberSelect(MemberSelectTree exprTree, Void unused) {
        this.setResolverField();
        ExpressionTree scope = exprTree.getExpression();
        String name = exprTree.getIdentifier().toString();
        if (name.equals("class")) {
            JavaExpression className = scope.accept(this, null);
            if (className instanceof ClassName) {
                return className;
            }
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), "\".class\" preceded by " + className.getClass().getSimpleName()));
        }
        if (name.equals("this")) {
            JavaExpression className = scope.accept(this, null);
            if (className instanceof ClassName) {
                return new ThisReference(className.getType());
            }
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), "\".this\" preceded by " + className.getClass().getSimpleName()));
        }
        Symbol.PackageSymbol packageSymbol = this.resolver.findPackage(scope.toString(), this.pathToCompilationUnit);
        if (packageSymbol != null) {
            Symbol.ClassSymbol classSymbol = this.resolver.findClassInPackage(name, packageSymbol, this.pathToCompilationUnit);
            if (classSymbol != null) {
                return new ClassName(classSymbol.asType());
            }
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), "could not find class " + name + " in package " + scope.toString()));
        }
        JavaExpression receiver = scope.accept(this, null);
        FieldAccess fieldAccess = this.getIdentifierAsFieldAccess(receiver, name);
        if (fieldAccess != null) {
            return fieldAccess;
        }
        ClassName innerClass = this.getIdentifierAsInnerClassName(receiver.getType(), name);
        if (innerClass != null) {
            return innerClass;
        }
        throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(name, String.format("field or class %s not found in %s", name, receiver)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JavaExpression visitNewArray(NewArrayTree exprTree, Void unused) {
        void var5_9;
        void var6_13;
        TypeMirror typeMirror;
        ArrayList<@Nullable JavaExpression> dimensions = new ArrayList<JavaExpression>();
        for (ExpressionTree expressionTree : exprTree.getDimensions()) {
            dimensions.add(expressionTree == null ? null : expressionTree.accept(this, null));
        }
        if (dimensions.isEmpty()) {
            dimensions.add(null);
        }
        ArrayList<JavaExpression> initializers = new ArrayList<JavaExpression>();
        if (exprTree.getInitializers() != null) {
            for (ExpressionTree expressionTree : exprTree.getInitializers()) {
                initializers.add(expressionTree.accept(this, null));
            }
        }
        if ((typeMirror = this.convertTreeToTypeMirror((JCTree)exprTree.getType())) == null) {
            throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.getType().toString(), "type not parsable"));
        }
        boolean bl = false;
        while (var6_13 < dimensions.size()) {
            ArrayType arrayType = TypesUtils.createArrayType((TypeMirror)var5_9, this.env.getTypeUtils());
            ++var6_13;
        }
        return new ArrayCreation((TypeMirror)var5_9, dimensions, initializers);
    }

    @Override
    public JavaExpression visitUnary(UnaryTree exprTree, Void unused) {
        Tree.Kind treeKind = exprTree.getKind();
        JavaExpression operand = exprTree.getExpression().accept(this, null);
        switch (treeKind) {
            case UNARY_PLUS: {
                return operand;
            }
            case UNARY_MINUS: {
                if (!(operand instanceof ValueLiteral)) break;
                return ((ValueLiteral)operand).negate();
            }
        }
        return new UnaryOperation(operand.getType(), treeKind, operand);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JavaExpression visitBinary(BinaryTree exprTree, Void unused) {
        TypeMirror type;
        Tree.Kind operator = exprTree.getKind();
        JavaExpression leftJe = exprTree.getLeftOperand().accept(this, null);
        JavaExpression rightJe = exprTree.getRightOperand().accept(this, null);
        TypeMirror leftType = leftJe.getType();
        TypeMirror rightType = rightJe.getType();
        if (operator == Tree.Kind.PLUS && (TypesUtils.isString(leftType) || TypesUtils.isString(rightType))) {
            type = this.stringTypeMirror;
            return new BinaryOperation(type, operator, leftJe, rightJe);
        } else if (COMPARISON_OPERATORS.contains((Object)operator)) {
            if (!this.types.isSubtype(leftType, rightType) && !this.types.isSubtype(rightType, leftType)) throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), String.format("inconsistent types %s %s for %s", leftType, rightType, exprTree)));
            type = this.booleanTypeMirror;
            return new BinaryOperation(type, operator, leftJe, rightJe);
        } else if (this.types.isSubtype(leftType, rightType)) {
            type = rightType;
            return new BinaryOperation(type, operator, leftJe, rightJe);
        } else {
            if (!this.types.isSubtype(rightType, leftType)) throw new JavaExpressionParseException.JavaExpressionParseExceptionUnchecked(JavaExpressionParseException.construct(exprTree.toString(), String.format("inconsistent types %s %s for %s", leftType, rightType, exprTree)));
            type = leftType;
        }
        return new BinaryOperation(type, operator, leftJe, rightJe);
    }

    private @Nullable TypeMirror convertTreeToTypeMirror(JCTree typeTree) {
        if (typeTree instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)((Object)typeTree);
            String identifier = memberSelectTree.getIdentifier().toString();
            JavacParseResult<ExpressionTree> jpr = JavacParse.parseExpression(identifier);
            if (jpr.hasParseError()) {
                throw new Error(identifier + " :" + jpr.getParseErrorMessages());
            }
            ExpressionTree parsed = jpr.getTree();
            if (parsed instanceof IdentifierTree) {
                return parsed.accept(this, null).getType();
            }
            String msg = String.format("parsed is not IdentifierTree: %s [%s]", parsed, parsed.getClass().getSimpleName());
            throw new BugInCF(msg);
        }
        if (typeTree instanceof IdentifierTree) {
            try {
                return typeTree.accept(this, null).getType();
            }
            catch (Throwable e) {
                throw new BugInCF("Problem while parsing " + typeTree, e);
            }
        }
        if (typeTree instanceof JCTree.JCPrimitiveTypeTree) {
            switch (((JCTree.JCPrimitiveTypeTree)typeTree).getPrimitiveTypeKind()) {
                case BOOLEAN: {
                    return this.types.getPrimitiveType(TypeKind.BOOLEAN);
                }
                case BYTE: {
                    return this.types.getPrimitiveType(TypeKind.BYTE);
                }
                case SHORT: {
                    return this.types.getPrimitiveType(TypeKind.SHORT);
                }
                case INT: {
                    return this.types.getPrimitiveType(TypeKind.INT);
                }
                case CHAR: {
                    return this.types.getPrimitiveType(TypeKind.CHAR);
                }
                case FLOAT: {
                    return this.types.getPrimitiveType(TypeKind.FLOAT);
                }
                case LONG: {
                    return this.types.getPrimitiveType(TypeKind.LONG);
                }
                case DOUBLE: {
                    return this.types.getPrimitiveType(TypeKind.DOUBLE);
                }
                case VOID: {
                    return this.types.getNoType(TypeKind.VOID);
                }
            }
            return null;
        }
        if (typeTree instanceof JCTree.JCArrayTypeTree) {
            TypeMirror componentType = this.convertTreeToTypeMirror(((JCTree.JCArrayTypeTree)typeTree).getType());
            if (componentType == null) {
                return null;
            }
            return this.types.getArrayType(componentType);
        }
        System.out.printf("convertTreeToTypeMirror does not handle %s [%s]%n", typeTree, typeTree.getClass().getSimpleName());
        return null;
    }

    private static TypeMirror getTypeOfEnclosingClass(DeclaredType type) {
        if (type instanceof Type.ClassType) {
            Symbol sym = ((Type.ClassType)type).tsym.owner;
            if (sym == null) {
                return Type.noType;
            }
            Symbol.ClassSymbol cs = sym.enclClass();
            if (cs == null) {
                return Type.noType;
            }
            return cs.asType();
        }
        return type.getEnclosingType();
    }
}

