/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.visualize;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.analysis.AbstractValue;
import org.checkerframework.nullaway.dataflow.analysis.Analysis;
import org.checkerframework.nullaway.dataflow.analysis.Store;
import org.checkerframework.nullaway.dataflow.analysis.TransferFunction;
import org.checkerframework.nullaway.dataflow.analysis.TransferInput;
import org.checkerframework.nullaway.dataflow.analysis.TransferResult;
import org.checkerframework.nullaway.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.nullaway.dataflow.cfg.block.Block;
import org.checkerframework.nullaway.dataflow.cfg.block.ConditionalBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.ExceptionBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SingleSuccessorBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.visualize.CFGVisualizer;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.org.plumelib.util.StringsPlume;
import org.checkerframework.nullaway.org.plumelib.util.UniqueId;

public abstract class AbstractCFGVisualizer<V extends AbstractValue<V>, S extends Store<S>, T extends TransferFunction<V, S>>
implements CFGVisualizer<V, S, T> {
    protected boolean verbose;
    protected static final String lineSeparator = System.lineSeparator();
    protected static final String storeEntryIndent = "  ";

    @Override
    public void init(Map<String, Object> args) {
        this.verbose = AbstractCFGVisualizer.toBoolean(args.get("verbose"));
    }

    private static boolean toBoolean(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return (Boolean)o;
    }

    protected String visualizeGraph(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        return this.visualizeGraphHeader() + this.visualizeGraphWithoutHeaderAndFooter(cfg, entry, analysis) + this.visualizeGraphFooter();
    }

    protected String visualizeGraphWithoutHeaderAndFooter(ControlFlowGraph cfg, Block entry, @Nullable Analysis<V, S, T> analysis) {
        LinkedHashSet<Block> visited = new LinkedHashSet<Block>();
        StringBuilder sbGraph = new StringBuilder();
        ArrayDeque<Block> workList = new ArrayDeque<Block>();
        workList.add(entry);
        visited.add(entry);
        while (!workList.isEmpty()) {
            Block cur = (Block)workList.remove();
            this.handleSuccessorsHelper(cur, visited, workList, sbGraph);
        }
        sbGraph.append(lineSeparator);
        sbGraph.append(this.visualizeNodes(visited, cfg, analysis));
        return sbGraph.toString();
    }

    protected void handleSuccessorsHelper(Block cur, Set<Block> visited, Queue<Block> workList, StringBuilder sbGraph) {
        if (cur.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
            ConditionalBlock ccur = (ConditionalBlock)cur;
            Block thenSuccessor = ccur.getThenSuccessor();
            sbGraph.append(this.visualizeEdge(ccur.getUid(), thenSuccessor.getUid(), ccur.getThenFlowRule().toString()));
            sbGraph.append(lineSeparator);
            this.addBlock(thenSuccessor, visited, workList);
            Block elseSuccessor = ccur.getElseSuccessor();
            sbGraph.append(this.visualizeEdge(ccur.getUid(), elseSuccessor.getUid(), ccur.getElseFlowRule().toString()));
            sbGraph.append(lineSeparator);
            this.addBlock(elseSuccessor, visited, workList);
        } else {
            SingleSuccessorBlock sscur = (SingleSuccessorBlock)cur;
            Block succ = sscur.getSuccessor();
            if (succ != null) {
                sbGraph.append(this.visualizeEdge(cur.getUid(), succ.getUid(), sscur.getFlowRule().name()));
                sbGraph.append(lineSeparator);
                this.addBlock(succ, visited, workList);
            }
        }
        if (cur.getType() == Block.BlockType.EXCEPTION_BLOCK) {
            ExceptionBlock ecur = (ExceptionBlock)cur;
            for (Map.Entry<TypeMirror, Set<Block>> e : ecur.getExceptionalSuccessors().entrySet()) {
                TypeMirror cause = e.getKey();
                String exception = cause.toString();
                if (exception.startsWith("java.lang.")) {
                    exception = exception.replace("java.lang.", "");
                }
                for (Block b : e.getValue()) {
                    sbGraph.append(this.visualizeEdge(cur.getUid(), b.getUid(), exception));
                    sbGraph.append(lineSeparator);
                    this.addBlock(b, visited, workList);
                }
            }
        }
    }

    protected void addBlock(Block b, Set<Block> visited, Queue<Block> workList) {
        if (visited.add(b)) {
            workList.add(b);
        }
    }

    protected String visualizeBlockWithSeparator(Block bb, @Nullable Analysis<V, S, T> analysis, String separator) {
        StringBuilder sbBlock = new StringBuilder();
        String contents = this.loopOverBlockContents(bb, analysis, separator);
        if (!contents.isEmpty()) {
            sbBlock.append(contents);
        }
        if (sbBlock.length() == 0) {
            if (bb.getType() == Block.BlockType.SPECIAL_BLOCK) {
                sbBlock.append(this.visualizeSpecialBlock((SpecialBlock)bb));
            } else if (bb.getType() == Block.BlockType.CONDITIONAL_BLOCK) {
                sbBlock.append(this.visualizeConditionalBlock((ConditionalBlock)bb));
            } else {
                sbBlock.append("<empty block>");
            }
        }
        if (analysis != null) {
            Node lastNode;
            sbBlock.insert(0, this.visualizeBlockTransferInputBefore(bb, analysis) + separator);
            if (this.verbose && (lastNode = bb.getLastNode()) != null) {
                if (!sbBlock.toString().endsWith(separator)) {
                    sbBlock.append(separator);
                }
                sbBlock.append(this.visualizeBlockTransferInputAfter(bb, analysis) + separator);
            }
        }
        return sbBlock.toString();
    }

    protected String loopOverBlockContents(Block bb, @Nullable Analysis<V, S, T> analysis, String separator) {
        List<Node> contents = this.addBlockContent(bb);
        StringJoiner sjBlockContents = new StringJoiner(separator);
        for (Node n : contents) {
            sjBlockContents.add(this.visualizeBlockNode(n, analysis));
        }
        return sjBlockContents.toString();
    }

    protected List<Node> addBlockContent(Block bb) {
        return bb.getNodes();
    }

    protected String escapeString(String str) {
        return str;
    }

    protected final String escapeString(Object obj) {
        return this.escapeString(obj.toString());
    }

    @Override
    public String visualizeBlockNode(Node n, @Nullable Analysis<V, S, T> analysis) {
        V value;
        StringBuilder sbBlockNode = new StringBuilder();
        sbBlockNode.append(this.escapeString(n)).append("   [ ").append(this.getNodeSimpleName(n)).append(" ]");
        if (analysis != null && (value = analysis.getValue(n)) != null) {
            sbBlockNode.append("    > ").append(this.escapeString(value));
        }
        return sbBlockNode.toString();
    }

    protected String visualizeBlockTransferInputHelper(VisualizeWhere where, Block bb, Analysis<V, S, T> analysis, String separator) {
        UniqueId storesFromId;
        S regularStore;
        if (analysis == null) {
            throw new BugInCF("analysis must be non-null when visualizing the transfer input of a block.");
        }
        Analysis.Direction analysisDirection = analysis.getDirection();
        S thenStore = null;
        S elseStore = null;
        Object resultValue = null;
        boolean isTwoStores = false;
        if (analysisDirection == Analysis.Direction.FORWARD && where == VisualizeWhere.AFTER) {
            TransferResult<V, S> tResult;
            regularStore = analysis.getResult().getStoreAfter(bb);
            storesFromId = analysis.getResult();
            Node lastNode = bb.getLastNode();
            if (lastNode != null && (tResult = analysis.getResult().lookupResult(lastNode)) != null) {
                resultValue = tResult.getResultValue();
            }
        } else if (analysisDirection == Analysis.Direction.BACKWARD && where == VisualizeWhere.BEFORE) {
            regularStore = analysis.getResult().getStoreBefore(bb);
            storesFromId = analysis.getResult();
        } else {
            TransferInput<V, S> input = analysis.getInput(bb);
            if (input == null) {
                regularStore = null;
                storesFromId = null;
            } else {
                storesFromId = input;
                isTwoStores = input.containsTwoStores();
                regularStore = input.getRegularStore();
                thenStore = input.getThenStore();
                elseStore = input.getElseStore();
            }
        }
        StringBuilder sbStore = new StringBuilder();
        if (this.verbose) {
            sbStore.append((storesFromId == null ? "null" : storesFromId.getClassAndUid()) + separator);
        }
        sbStore.append(where == VisualizeWhere.BEFORE ? "Before: " : "After: ");
        if (this.verbose && resultValue != null) {
            sbStore.append("resultValue=" + resultValue);
            sbStore.append(separator);
        }
        if (regularStore == null) {
            sbStore.append("()");
        } else if (!isTwoStores) {
            sbStore.append(this.visualizeStore(regularStore));
        } else {
            assert (thenStore != null) : "@AssumeAssertion(nullness): invariant";
            assert (elseStore != null) : "@AssumeAssertion(nullness): invariant";
            sbStore.append("then=");
            sbStore.append(this.visualizeStore(thenStore));
            sbStore.append(",");
            sbStore.append(separator);
            sbStore.append("else=");
            sbStore.append(this.visualizeStore(elseStore));
        }
        if (where == VisualizeWhere.BEFORE) {
            sbStore.append(separator + "~~~~~~~~~");
        } else {
            sbStore.insert(0, "~~~~~~~~~" + separator);
        }
        return sbStore.toString();
    }

    protected String visualizeSpecialBlockHelper(SpecialBlock sbb) {
        switch (sbb.getSpecialType()) {
            case ENTRY: {
                return "<entry>";
            }
            case EXIT: {
                return "<exit>";
            }
            case EXCEPTIONAL_EXIT: {
                return "<exceptional-exit>";
            }
        }
        throw new BugInCF("Unrecognized special block type: " + (Object)((Object)sbb.getType()));
    }

    protected IdentityHashMap<Block, List<Integer>> getProcessOrder(ControlFlowGraph cfg) {
        IdentityHashMap<Block, List<Integer>> depthFirstOrder = new IdentityHashMap<Block, List<Integer>>();
        int count = 1;
        for (Block b : cfg.getDepthFirstOrderedBlocks()) {
            depthFirstOrder.computeIfAbsent(b, k -> new ArrayList());
            @NonNull List<Integer> blockIds = depthFirstOrder.get(b);
            blockIds.add(count++);
        }
        return depthFirstOrder;
    }

    @Override
    public String visualizeStore(S store) {
        return store.visualize(this);
    }

    protected abstract String visualizeNodes(Set<Block> var1, ControlFlowGraph var2, @Nullable Analysis<V, S, T> var3);

    protected abstract String visualizeEdge(Object var1, Object var2, String var3);

    protected abstract String visualizeGraphHeader();

    protected abstract String visualizeGraphFooter();

    protected String getProcessOrderSimpleString(List<Integer> order) {
        return "Process order: " + StringsPlume.join((CharSequence)",", order);
    }

    protected String getNodeSimpleName(Node n) {
        String name = n.getClass().getSimpleName();
        return name.replace("Node", "");
    }

    protected static enum VisualizeWhere {
        BEFORE,
        AFTER;

    }
}

