/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.com.google.common.collect;

import java.util.function.BiConsumer;
import javax.annotation.CheckForNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.NonNegative;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.EnsuresKeyForIf;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.com.google.common.annotations.GwtCompatible;
import org.checkerframework.nullaway.com.google.common.annotations.GwtIncompatible;
import org.checkerframework.nullaway.com.google.common.annotations.J2ktIncompatible;
import org.checkerframework.nullaway.com.google.common.base.Preconditions;
import org.checkerframework.nullaway.com.google.common.collect.CollectPreconditions;
import org.checkerframework.nullaway.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.checkerframework.nullaway.com.google.common.collect.ImmutableBiMap;
import org.checkerframework.nullaway.com.google.common.collect.ImmutableSet;
import org.checkerframework.nullaway.com.google.common.collect.Maps;
import org.checkerframework.nullaway.com.google.errorprone.annotations.concurrent.LazyInit;
import org.checkerframework.nullaway.com.google.j2objc.annotations.RetainedWith;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableBiMap<@SubstringIndexBottom K, @SubstringIndexBottom V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    @CheckForNull
    private final transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed ImmutableBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @Signed ImmutableBiMap<V, K> lazyInverse;

    SingletonImmutableBiMap(K singleKey, V singleValue) {
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = null;
    }

    private SingletonImmutableBiMap(K singleKey, V singleValue, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableBiMap<V, K> inverse) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = inverse;
    }

    @Override
    @CheckForNull
    @Pure
    public @Nullable V get(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    @Override
    @Pure
    public @NonNegative @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int size() {
        return 1;
    }

    @Override
    public void forEach(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed BiConsumer<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super K, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized @UnknownSignedness ? super V> action) {
        Preconditions.checkNotNull(action).accept(this.singleKey, this.singleValue);
    }

    @Override
    @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean containsKey(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    @Pure
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean containsValue(@CheckForNull @UnknownSignedness @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @Nullable @Initialized Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed boolean isPartialView() {
        return false;
    }

    @Override
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableSet< @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed ImmutableBiMap<V, K> inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> result = this.lazyInverse;
        if (result == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return result;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed Object writeReplace() {
        return super.writeReplace();
    }
}

