/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.com.google.common.util.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.com.google.common.annotations.GwtCompatible;
import org.checkerframework.com.google.common.collect.ImmutableCollection;
import org.checkerframework.com.google.common.collect.ImmutableList;
import org.checkerframework.com.google.common.collect.Lists;
import org.checkerframework.com.google.common.util.concurrent.AggregateFuture;
import org.checkerframework.com.google.common.util.concurrent.ListenableFuture;
import org.checkerframework.nullaway.checker.index.qual.LessThanBottom;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundBottom;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenBottom;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundBottom;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.signedness.qual.Signed;
import org.checkerframework.nullaway.checker.signedness.qual.SignednessBottom;
import org.checkerframework.nullaway.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.nullaway.common.value.qual.BottomVal;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;

@GwtCompatible(emulated=true)
abstract class CollectionFuture<@SubstringIndexBottom V, @SubstringIndexBottom C>
extends AggregateFuture<V, C> {
    private @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness List<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Present<V>> values;

    CollectionFuture(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ImmutableCollection<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @UnknownKeyFor @NonNull @Initialized @SignednessBottom ? extends @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ListenableFuture<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @UnknownKeyFor @NonNull @Initialized @SignednessBottom ? extends V>> futures, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        ImmutableList<Present<V>> values = futures.isEmpty() ? ImmutableList.of() : Lists.newArrayListWithCapacity(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            values.add(null);
        }
        this.values = values;
    }

    @Override
    final void collectOneValue(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @Signed int index, @Nullable V returnValue) {
        List<Present<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, new Present<V>(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<Present<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness List<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Present<V>> var1);

    private static final class Present<@SubstringIndexBottom V> {
        V value;

        Present(V value) {
            this.value = value;
        }
    }

    static final class ListFuture<@SubstringIndexBottom V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ImmutableCollection<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @UnknownKeyFor @NonNull @Initialized @SignednessBottom ? extends @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness ListenableFuture<@SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @UnknownKeyFor @NonNull @Initialized @SignednessBottom ? extends V>> futures, @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness List<V> combine(@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness List<@SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownKeyFor @NonNull @Initialized @UnknownSignedness Present<V>> values) {
            ArrayList<Object> result = Lists.newArrayListWithCapacity(values.size());
            for (Present<V> element : values) {
                result.add(element != null ? (Object)element.value : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

