/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.javacutil;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacScope;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.NonNull;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.javacutil.BugInCF;
import org.checkerframework.errorprone.javacutil.ElementUtils;

public class Resolver {
    private final Resolve resolve;
    private final Names names;
    private final Trees trees;
    private final Log log;
    private static final Method FIND_METHOD;
    private static final Method FIND_VAR;
    private static final Method FIND_IDENT;
    private static final Method FIND_IDENT_IN_TYPE;
    private static final Method FIND_IDENT_IN_PACKAGE;
    private static final Method FIND_TYPE;
    private static final Class<?> ACCESSERROR;
    private static final Method ACCESSERROR_ACCESS;
    private static final int sourceVersionNumber;
    private static final boolean atLeastJava13;
    private static final boolean atLeastJava23;

    public Resolver(ProcessingEnvironment env) {
        Context context = ((JavacProcessingEnvironment)env).getContext();
        this.resolve = Resolve.instance(context);
        this.names = Names.instance(context);
        this.trees = Trees.instance(env);
        this.log = Log.instance(context);
    }

    public Env<AttrContext> getEnvForPath(TreePath path) {
        TreePath iter = path;
        JavacScope scope = null;
        while (scope == null && iter != null) {
            try {
                scope = (JavacScope)this.trees.getScope(iter);
            }
            catch (NullPointerException t) {
                iter = iter.getParentPath();
            }
        }
        if (scope != null) {
            return scope.getEnv();
        }
        throw new BugInCF("Could not determine any possible scope for path: " + path.getLeaf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Symbol.PackageSymbol findPackage(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = atLeastJava13 ? this.wrapInvocationOnResolveInstance(FIND_IDENT, null, env, this.names.fromString(name), Kinds.KindSelector.PCK) : this.wrapInvocationOnResolveInstance(FIND_IDENT, env, this.names.fromString(name), Kinds.KindSelector.PCK);
            if (res.getKind() == ElementKind.PACKAGE) {
                Symbol.PackageSymbol ps = (Symbol.PackageSymbol)res;
                Symbol.PackageSymbol packageSymbol = ps.exists() ? ps : null;
                return packageSymbol;
            }
            Symbol.PackageSymbol packageSymbol = null;
            return packageSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable VariableElement findField(String name, TypeMirror type, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = atLeastJava13 ? this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_TYPE, null, env, type, this.names.fromString(name), Kinds.KindSelector.VAR) : this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_TYPE, env, type, this.names.fromString(name), Kinds.KindSelector.VAR);
            if (res.getKind().isField()) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            if (res.getKind() == ElementKind.OTHER && ACCESSERROR.isInstance(res)) {
                VariableElement variableElement = (VariableElement)((Object)this.wrapInvocation(res, ACCESSERROR_ACCESS, null, null));
                return variableElement;
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable VariableElement findLocalVariableOrParameter(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = atLeastJava23 ? this.wrapInvocationOnResolveInstance(FIND_VAR, null, env, this.names.fromString(name)) : this.wrapInvocationOnResolveInstance(FIND_VAR, env, this.names.fromString(name));
            switch (res.getKind()) {
                case EXCEPTION_PARAMETER: 
                case LOCAL_VARIABLE: 
                case PARAMETER: 
                case RESOURCE_VARIABLE: {
                    VariableElement variableElement = (VariableElement)((Object)res);
                    return variableElement;
                }
                case ENUM_CONSTANT: 
                case FIELD: {
                    VariableElement variableElement = null;
                    return variableElement;
                }
            }
            if (ElementUtils.isBindingVariable(res)) {
                VariableElement variableElement = (VariableElement)((Object)res);
                return variableElement;
            }
            if (res instanceof VariableElement) {
                throw new BugInCF("unhandled variable ElementKind " + (Object)((Object)res.getKind()));
            }
            VariableElement variableElement = null;
            return variableElement;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element findClass(String name, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol symbol = this.wrapInvocationOnResolveInstance(FIND_TYPE, env, this.names.fromString(name));
            return symbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Symbol.ClassSymbol findClassInPackage(String name, Symbol.PackageSymbol pck, TreePath path) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Symbol res = atLeastJava13 ? this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_PACKAGE, null, env, pck, this.names.fromString(name), Kinds.KindSelector.TYP) : this.wrapInvocationOnResolveInstance(FIND_IDENT_IN_PACKAGE, env, pck, this.names.fromString(name), Kinds.KindSelector.TYP);
            if (ElementUtils.isTypeElement(res)) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)res;
                return classSymbol;
            }
            Symbol.ClassSymbol classSymbol = null;
            return classSymbol;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    public @Nullable ExecutableElement findMethod(String methodName, TypeMirror receiverType, TreePath path, java.util.List<TypeMirror> argumentTypes) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            Env<AttrContext> env = this.getEnvForPath(path);
            Type site = (Type)receiverType;
            Name name = this.names.fromString(methodName);
            List<Type> argtypes = List.nil();
            for (TypeMirror a : argumentTypes) {
                argtypes = argtypes.append((Type)a);
            }
            List typeargtypes = List.nil();
            boolean allowBoxing = true;
            boolean useVarargs = false;
            try {
                Object methodContext = this.buildMethodContext();
                Object oldContext = this.getField(this.resolve, "currentResolutionContext");
                this.setField(this.resolve, "currentResolutionContext", methodContext);
                Symbol resolveResult = this.wrapInvocationOnResolveInstance(FIND_METHOD, env, site, name, argtypes, typeargtypes, allowBoxing, useVarargs);
                this.setField(this.resolve, "currentResolutionContext", oldContext);
                ExecutableElement methodResult = resolveResult.getKind() == ElementKind.METHOD || resolveResult.getKind() == ElementKind.CONSTRUCTOR ? (ExecutableElement)((Object)resolveResult) : (resolveResult.getKind() == ElementKind.OTHER && ACCESSERROR.isInstance(resolveResult) ? (ExecutableElement)((Object)this.wrapInvocation(resolveResult, ACCESSERROR_ACCESS, null, null)) : null);
                ExecutableElement executableElement = methodResult;
                return executableElement;
            }
            catch (Throwable t) {
                AssertionError err = new AssertionError((Object)String.format("Unexpected reflection error in findMethod(%s, %s, ..., %s)", methodName, receiverType, argumentTypes));
                ((Throwable)((Object)err)).initCause(t);
                throw err;
            }
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Object buildMethodContext() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchFieldException {
        Class<?> methCtxClss = Class.forName("com.sun.tools.javac.comp.Resolve$MethodResolutionContext");
        Constructor<?> constructor = methCtxClss.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        Object methodContext = constructor.newInstance(this.resolve);
        this.setField(methodContext, "attrMode", (Object)DeferredAttr.AttrMode.CHECK);
        List phases = (List)this.getField(this.resolve, "methodResolutionSteps");
        assert (phases != null) : "@AssumeAssertion(nullness): assumption";
        this.setField(methodContext, "step", phases.get(1));
        return methodContext;
    }

    private void setField(Object receiver, String fieldName, @Nullable Object value) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        f.set(receiver, value);
    }

    private @Nullable Object getField(Object receiver, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field f = receiver.getClass().getDeclaredField(fieldName);
        f.setAccessible(true);
        return f.get(receiver);
    }

    private Symbol wrapInvocationOnResolveInstance(Method method, Object ... args) {
        return this.wrapInvocation(this.resolve, method, args);
    }

    private Symbol wrapInvocation(Object receiver, Method method, Object ... args) {
        try {
            @NonNull Symbol res = (Symbol)method.invoke(receiver, args);
            return res;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new BugInCF(e, "Unexpected reflection error in wrapInvocation(%s, %s, %s)", receiver, method, Arrays.toString(args));
        }
    }

    static {
        sourceVersionNumber = Integer.parseInt(SourceVersion.latest().toString().substring("RELEASE_".length()));
        atLeastJava13 = sourceVersionNumber >= 13;
        atLeastJava23 = sourceVersionNumber >= 23;
        try {
            FIND_METHOD = Resolve.class.getDeclaredMethod("findMethod", Env.class, Type.class, Name.class, List.class, List.class, Boolean.TYPE, Boolean.TYPE);
            FIND_METHOD.setAccessible(true);
            FIND_VAR = atLeastJava23 ? Resolve.class.getDeclaredMethod("findVar", JCDiagnostic.DiagnosticPosition.class, Env.class, Name.class) : Resolve.class.getDeclaredMethod("findVar", Env.class, Name.class);
            FIND_VAR.setAccessible(true);
            FIND_IDENT = atLeastJava13 ? Resolve.class.getDeclaredMethod("findIdent", JCDiagnostic.DiagnosticPosition.class, Env.class, Name.class, Kinds.KindSelector.class) : Resolve.class.getDeclaredMethod("findIdent", Env.class, Name.class, Kinds.KindSelector.class);
            FIND_IDENT.setAccessible(true);
            FIND_IDENT_IN_TYPE = atLeastJava13 ? Resolve.class.getDeclaredMethod("findIdentInType", JCDiagnostic.DiagnosticPosition.class, Env.class, Type.class, Name.class, Kinds.KindSelector.class) : Resolve.class.getDeclaredMethod("findIdentInType", Env.class, Type.class, Name.class, Kinds.KindSelector.class);
            FIND_IDENT_IN_TYPE.setAccessible(true);
            FIND_IDENT_IN_PACKAGE = atLeastJava13 ? Resolve.class.getDeclaredMethod("findIdentInPackage", JCDiagnostic.DiagnosticPosition.class, Env.class, Symbol.TypeSymbol.class, Name.class, Kinds.KindSelector.class) : Resolve.class.getDeclaredMethod("findIdentInPackage", Env.class, Symbol.TypeSymbol.class, Name.class, Kinds.KindSelector.class);
            FIND_IDENT_IN_PACKAGE.setAccessible(true);
            FIND_TYPE = Resolve.class.getDeclaredMethod("findType", Env.class, Name.class);
            FIND_TYPE.setAccessible(true);
        }
        catch (Exception e) {
            AssertionError err = new AssertionError((Object)"Compiler 'Resolve' class doesn't contain required 'find*' method");
            ((Throwable)((Object)err)).initCause(e);
            throw err;
        }
        try {
            ACCESSERROR = Class.forName("com.sun.tools.javac.comp.Resolve$AccessError");
            ACCESSERROR_ACCESS = ACCESSERROR.getMethod("access", Name.class, Symbol.TypeSymbol.class);
            ACCESSERROR_ACCESS.setAccessible(true);
        }
        catch (ClassNotFoundException e) {
            throw new BugInCF("Compiler 'Resolve$AccessError' class could not be retrieved.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BugInCF("Compiler 'Resolve$AccessError' class doesn't contain required 'access' method", (Throwable)e);
        }
    }
}

