/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Position;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class Scanner
implements Lexer {
    private Tokens tokens;
    private Tokens.Token token;
    private Tokens.Token prevToken;
    private List<Tokens.Token> savedTokens = new ArrayList<Tokens.Token>();
    private JavaTokenizer tokenizer;

    protected Scanner(ScannerFactory fac, CharBuffer buf) {
        this(fac, new JavaTokenizer(fac, buf));
    }

    protected Scanner(ScannerFactory fac, char[] buf, int inputLength) {
        this(fac, new JavaTokenizer(fac, buf, inputLength));
    }

    protected Scanner(ScannerFactory fac, JavaTokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this.tokens = fac.tokens;
        this.token = this.prevToken = Tokens.DUMMY;
    }

    @Override
    public Tokens.Token token() {
        return this.token(0);
    }

    @Override
    public Tokens.Token token(int lookahead) {
        if (lookahead == 0) {
            return this.token;
        }
        this.ensureLookahead(lookahead);
        return this.savedTokens.get(lookahead - 1);
    }

    private void ensureLookahead(int lookahead) {
        for (int i = this.savedTokens.size(); i < lookahead; ++i) {
            this.savedTokens.add(this.tokenizer.readToken());
        }
    }

    @Override
    public Tokens.Token prevToken() {
        return this.prevToken;
    }

    @Override
    public void nextToken() {
        this.prevToken = this.token;
        this.token = !this.savedTokens.isEmpty() ? this.savedTokens.remove(0) : this.tokenizer.readToken();
    }

    @Override
    public Tokens.Token split() {
        Tokens.Token[] splitTokens = this.token.split(this.tokens);
        this.prevToken = splitTokens[0];
        this.token = splitTokens[1];
        return this.token;
    }

    @Override
    public Position.LineMap getLineMap() {
        return this.tokenizer.getLineMap();
    }

    @Override
    public int errPos() {
        return this.tokenizer.errPos();
    }

    @Override
    public void errPos(int pos) {
        this.tokenizer.errPos(pos);
    }

    boolean inAnnotationComment() {
        return this.tokenizer.magic || this.tokenizer.magicAt || this.tokenizer.magicID || this.tokenizer.voodoo;
    }
}

