/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public abstract class AbstractLog {
    protected JCDiagnostic.Factory diags;
    protected DiagnosticSource source;
    protected Map<JavaFileObject, DiagnosticSource> sourceMap;

    AbstractLog(JCDiagnostic.Factory diags) {
        this.diags = diags;
        this.sourceMap = new HashMap<JavaFileObject, DiagnosticSource>();
    }

    public JavaFileObject useSource(JavaFileObject file) {
        JavaFileObject prev = this.source == null ? null : this.source.getFile();
        this.source = this.getSource(file);
        return prev;
    }

    protected DiagnosticSource getSource(JavaFileObject file) {
        if (file == null) {
            return DiagnosticSource.NO_SOURCE;
        }
        DiagnosticSource s = this.sourceMap.get(file);
        if (s == null) {
            s = new DiagnosticSource(file, this);
            this.sourceMap.put(file, s);
        }
        return s;
    }

    public DiagnosticSource currentSource() {
        return this.source;
    }

    public void error(String key, Object ... args) {
        this.report(this.diags.error(this.source, null, key, args));
    }

    public void error(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.error(this.source, pos, key, args));
    }

    public void error(JCDiagnostic.DiagnosticFlag flag, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        JCDiagnostic d = this.diags.error(this.source, pos, key, args);
        d.setFlag(flag);
        this.report(d);
    }

    public void error(int pos, String key, Object ... args) {
        this.report(this.diags.error(this.source, this.wrap(pos), key, args));
    }

    public void error(JCDiagnostic.DiagnosticFlag flag, int pos, String key, Object ... args) {
        JCDiagnostic d = this.diags.error(this.source, this.wrap(pos), key, args);
        d.setFlag(flag);
        this.report(d);
    }

    public void warning(String key, Object ... args) {
        this.report(this.diags.warning(this.source, null, key, args));
    }

    public void warning(Lint.LintCategory lc, String key, Object ... args) {
        this.report(this.diags.warning(lc, key, args));
    }

    public void warning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.warning(this.source, pos, key, args));
    }

    public void warning(Lint.LintCategory lc, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.warning(lc, this.source, pos, key, args));
    }

    public void warning(int pos, String key, Object ... args) {
        this.report(this.diags.warning(this.source, this.wrap(pos), key, args));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.mandatoryWarning(this.source, pos, key, args));
    }

    public void mandatoryWarning(Lint.LintCategory lc, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.mandatoryWarning(lc, this.source, pos, key, args));
    }

    public void note(String key, Object ... args) {
        this.report(this.diags.note(this.source, null, key, args));
    }

    public void note(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        this.report(this.diags.note(this.source, pos, key, args));
    }

    public void note(int pos, String key, Object ... args) {
        this.report(this.diags.note(this.source, this.wrap(pos), key, args));
    }

    public void note(JavaFileObject file, String key, Object ... args) {
        this.report(this.diags.note(this.getSource(file), null, key, args));
    }

    public void mandatoryNote(JavaFileObject file, String key, Object ... args) {
        this.report(this.diags.mandatoryNote(this.getSource(file), key, args));
    }

    protected abstract void report(JCDiagnostic var1);

    protected abstract void directError(String var1, Object ... var2);

    private JCDiagnostic.DiagnosticPosition wrap(int pos) {
        return pos == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(pos);
    }
}

