/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.Map;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    final Attr attr;
    final TreeMaker make;
    final Log log;
    final Symtab syms;
    final Names names;
    final Resolve rs;
    final Types types;
    final ConstFold cfolder;
    final Check chk;
    private int enterCount = 0;
    ListBuffer<Worker> q = new ListBuffer();
    ListBuffer<Worker> typesQ = new ListBuffer();
    ListBuffer<Worker> repeatedQ = new ListBuffer();
    ListBuffer<Worker> afterRepeatedQ = new ListBuffer();
    ListBuffer<Worker> validateQ = new ListBuffer();

    public static Annotate instance(Context context) {
        Annotate instance = context.get(annotateKey);
        if (instance == null) {
            instance = new Annotate(context);
        }
        return instance;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
    }

    public void earlier(Worker a) {
        this.q.prepend(a);
    }

    public void normal(Worker a) {
        this.q.append(a);
    }

    public void typeAnnotation(Worker a) {
        this.typesQ.append(a);
    }

    public void repeated(Worker a) {
        this.repeatedQ.append(a);
    }

    public void afterRepeated(Worker a) {
        this.afterRepeatedQ.append(a);
    }

    public void validate(Worker a) {
        this.validateQ.append(a);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    public void enterDoneWithoutFlush() {
        --this.enterCount;
    }

    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.repeatedQ.nonEmpty()) {
                this.repeatedQ.next().run();
            }
            while (this.afterRepeatedQ.nonEmpty()) {
                this.afterRepeatedQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        return this.enterAnnotation(a, expected, env, false);
    }

    Attribute.TypeCompound enterTypeAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env) {
        return (Attribute.TypeCompound)this.enterAnnotation(a, expected, env, true);
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation a, Type expected, Env<AttrContext> env, boolean typeAnnotation) {
        Attribute.Compound ac;
        Type at = a.annotationType.type != null ? a.annotationType.type : this.attr.attribType(a.annotationType, env);
        a.type = this.chk.checkType(a.annotationType.pos(), at, expected);
        if (a.type.isErroneous()) {
            this.attr.postAttr(a);
            if (typeAnnotation) {
                return new Attribute.TypeCompound(a.type, List.nil(), new TypeAnnotationPosition());
            }
            return new Attribute.Compound(a.type, List.nil());
        }
        if ((a.type.tsym.flags() & 0x2000L) == 0L) {
            this.log.error(a.annotationType.pos(), "not.annotation.type", a.type.toString());
            this.attr.postAttr(a);
            if (typeAnnotation) {
                return new Attribute.TypeCompound(a.type, List.nil(), null);
            }
            return new Attribute.Compound(a.type, List.nil());
        }
        List<JCTree.JCExpression> args = a.args;
        if (args.length() == 1 && !((JCTree.JCExpression)args.head).hasTag(JCTree.Tag.ASSIGN)) {
            args.head = this.make.at(((JCTree.JCExpression)args.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)args.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> buf = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> tl = args;
        while (tl.nonEmpty()) {
            JCTree.JCExpression t = (JCTree.JCExpression)tl.head;
            if (!t.hasTag(JCTree.Tag.ASSIGN)) {
                this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
            } else {
                JCTree.JCAssign assign = (JCTree.JCAssign)t;
                if (!assign.lhs.hasTag(JCTree.Tag.IDENT)) {
                    this.log.error(t.pos(), "annotation.value.must.be.name.value", new Object[0]);
                } else {
                    Symbol method;
                    JCTree.JCIdent left = (JCTree.JCIdent)assign.lhs;
                    left.sym = method = this.rs.resolveQualifiedMethod(assign.rhs.pos(), env, a.type, left.name, List.nil(), null);
                    left.type = method.type;
                    if (method.owner != a.type.tsym) {
                        this.log.error(left.pos(), "no.annotation.member", left.name, a.type);
                    }
                    Type result = method.type.getReturnType();
                    Attribute value = this.enterAttributeValue(result, assign.rhs, env);
                    if (!method.type.isErroneous()) {
                        buf.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)method, value));
                    }
                    t.type = result;
                }
            }
            tl = tl.tail;
        }
        if (typeAnnotation) {
            if (a.attribute == null || !(a.attribute instanceof Attribute.TypeCompound)) {
                Attribute.TypeCompound tc = new Attribute.TypeCompound(a.type, buf.toList(), new TypeAnnotationPosition());
                a.attribute = tc;
                return tc;
            }
            return a.attribute;
        }
        a.attribute = ac = new Attribute.Compound(a.type, buf.toList());
        return ac;
    }

    Attribute enterAttributeValue(Type expected, JCTree.JCExpression tree, Env<AttrContext> env) {
        try {
            expected.tsym.complete();
        }
        catch (Symbol.CompletionFailure e) {
            this.log.error(tree.pos(), "cant.resolve", Kinds.kindName(e.sym), e.sym);
            expected = this.syms.errType;
        }
        if (expected.hasTag(TypeTag.ARRAY)) {
            if (!tree.hasTag(JCTree.Tag.NEWARRAY)) {
                tree = this.make.at(tree.pos).NewArray(null, List.nil(), List.of(tree));
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            ListBuffer<Attribute> buf = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                buf.append(this.enterAttributeValue(this.types.elemtype(expected), (JCTree.JCExpression)l.head, env));
                l = l.tail;
            }
            na.type = expected;
            return new Attribute.Array(expected, buf.toArray(new Attribute[buf.length()]));
        }
        if (tree.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!expected.isErroneous()) {
                this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
            }
            JCTree.JCNewArray na = (JCTree.JCNewArray)tree;
            if (na.elemtype != null) {
                this.log.error(na.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            List<JCTree.JCExpression> l = na.elems;
            while (l.nonEmpty()) {
                this.enterAttributeValue(this.syms.errType, (JCTree.JCExpression)l.head, env);
                l = l.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if ((expected.tsym.flags() & 0x2000L) != 0L) {
            if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.enterAnnotation((JCTree.JCAnnotation)tree, expected, env);
            }
            this.log.error(tree.pos(), "annotation.value.must.be.annotation", new Object[0]);
            expected = this.syms.errType;
        }
        if (tree.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!expected.isErroneous()) {
                this.log.error(tree.pos(), "annotation.not.valid.for.type", expected);
            }
            this.enterAnnotation((JCTree.JCAnnotation)tree, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)tree).annotationType.type);
        }
        if (expected.isPrimitive() || this.types.isSameType(expected, this.syms.stringType)) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                return new Attribute.Error(result.getOriginalType());
            }
            if (result.constValue() == null) {
                this.log.error(tree.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(expected);
            }
            result = this.cfolder.coerce(result, expected);
            return new Attribute.Constant(expected, result.constValue());
        }
        if (expected.tsym == this.syms.classType.tsym) {
            Type result = this.attr.attribExpr(tree, env, expected);
            if (result.isErroneous()) {
                if (TreeInfo.name(tree) == this.names._class && ((JCTree.JCFieldAccess)tree).selected.type.isErroneous()) {
                    Name n = ((JCTree.JCFieldAccess)tree).selected.type.tsym.flatName();
                    return new Attribute.UnresolvedClass(expected, this.types.createErrorType(n, this.syms.unknownSymbol, this.syms.classType));
                }
                return new Attribute.Error(result.getOriginalType());
            }
            if (TreeInfo.name(tree) != this.names._class) {
                this.log.error(tree.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(this.syms.errType);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)tree).selected.type);
        }
        if (expected.hasTag(TypeTag.CLASS) && (expected.tsym.flags() & 0x4000L) != 0L) {
            Type result = this.attr.attribExpr(tree, env, expected);
            Symbol sym = TreeInfo.symbol(tree);
            if (sym == null || TreeInfo.nonstaticSelect(tree) || sym.kind != 4 || (sym.flags() & 0x4000L) == 0L) {
                this.log.error(tree.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(result.getOriginalType());
            }
            Symbol.VarSymbol enumerator = (Symbol.VarSymbol)sym;
            return new Attribute.Enum(expected, enumerator);
        }
        if (!expected.isErroneous()) {
            this.log.error(tree.pos(), "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(tree, env, expected));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> annotations, AnnotateRepeatedContext<T> ctx, Symbol on) {
        Attribute.Compound firstOccurrence = (Attribute.Compound)annotations.head;
        List<Attribute> repeated = List.nil();
        Type origAnnoType = null;
        Type.ArrayType arrayOfOrigAnnoType = null;
        Type targetContainerType = null;
        Symbol.MethodSymbol containerValueSymbol = null;
        Assert.check(!annotations.isEmpty() && !annotations.tail.isEmpty());
        int count = 0;
        List<Object> al = annotations;
        while (!al.isEmpty()) {
            Assert.check(++count > 1 || !al.tail.isEmpty());
            Attribute.Compound currentAnno = (Attribute.Compound)al.head;
            origAnnoType = currentAnno.type;
            if (arrayOfOrigAnnoType == null) {
                arrayOfOrigAnnoType = this.types.makeArrayType(origAnnoType);
            }
            boolean reportError = count > 1;
            Type currentContainerType = this.getContainingType(currentAnno, ctx.pos.get(currentAnno), reportError);
            if (currentContainerType != null) {
                Assert.check(targetContainerType == null || currentContainerType == targetContainerType);
                targetContainerType = currentContainerType;
                containerValueSymbol = this.validateContainer(targetContainerType, origAnnoType, ctx.pos.get(currentAnno));
                if (containerValueSymbol != null) {
                    repeated = repeated.prepend(currentAnno);
                }
            }
            al = al.tail;
        }
        if (!repeated.isEmpty()) {
            repeated = repeated.reverse();
            TreeMaker m = this.make.at(ctx.pos.get(firstOccurrence));
            Pair<Object, Attribute.Array> p = new Pair<Object, Attribute.Array>(containerValueSymbol, new Attribute.Array((Type)arrayOfOrigAnnoType, repeated));
            if (ctx.isTypeCompound) {
                Attribute.TypeCompound at = new Attribute.TypeCompound(targetContainerType, List.of(p), ((Attribute.TypeCompound)annotations.head).position);
                at.setSynthesized(true);
                Attribute.TypeCompound x = at;
                return (T)x;
            }
            Attribute.Compound c = new Attribute.Compound(targetContainerType, List.of(p));
            JCTree.JCAnnotation annoTree = m.Annotation(c);
            if (!this.chk.annotationApplicable(annoTree, on)) {
                this.log.error(annoTree.pos(), "invalid.repeatable.annotation.incompatible.target", targetContainerType, origAnnoType);
            }
            if (!this.chk.validateAnnotationDeferErrors(annoTree)) {
                this.log.error(annoTree.pos(), "duplicate.annotation.invalid.repeated", origAnnoType);
            }
            c = this.enterAnnotation(annoTree, targetContainerType, ctx.env);
            c.setSynthesized(true);
            Attribute.Compound x = c;
            return (T)x;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound currentAnno, JCDiagnostic.DiagnosticPosition pos, boolean reportError) {
        Type origAnnoType = currentAnno.type;
        Symbol.TypeSymbol origAnnoDecl = origAnnoType.tsym;
        Attribute.Compound ca = origAnnoDecl.attribute(this.syms.repeatableType.tsym);
        if (ca == null) {
            if (reportError) {
                this.log.error(pos, "duplicate.annotation.missing.container", origAnnoType, this.syms.repeatableType);
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(ca, pos, origAnnoDecl), origAnnoType);
    }

    private Type filterSame(Type t, Type s) {
        if (t == null || s == null) {
            return t;
        }
        return this.types.isSameType(t, s) ? null : t;
    }

    private Type extractContainingType(Attribute.Compound ca, JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol annoDecl) {
        if (ca.values.isEmpty()) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        Pair p = (Pair)ca.values.head;
        Name name = ((Symbol.MethodSymbol)p.fst).name;
        if (name != this.names.value) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        if (!(p.snd instanceof Attribute.Class)) {
            this.log.error(pos, "invalid.repeatable.annotation", annoDecl);
            return null;
        }
        return ((Attribute.Class)p.snd).getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type targetContainerType, Type originalAnnoType, JCDiagnostic.DiagnosticPosition pos) {
        Symbol.MethodSymbol containerValueSymbol = null;
        boolean fatalError = false;
        Scope scope = targetContainerType.tsym.members();
        int nr_value_elems = 0;
        boolean error = false;
        for (Symbol elm : scope.getElementsByName(this.names.value)) {
            if (++nr_value_elems == 1 && elm.kind == 16) {
                containerValueSymbol = (Symbol.MethodSymbol)elm;
                continue;
            }
            error = true;
        }
        if (error) {
            this.log.error(pos, "invalid.repeatable.annotation.multiple.values", targetContainerType, nr_value_elems);
            return null;
        }
        if (nr_value_elems == 0) {
            this.log.error(pos, "invalid.repeatable.annotation.no.value", targetContainerType);
            return null;
        }
        if (containerValueSymbol.kind != 16) {
            this.log.error(pos, "invalid.repeatable.annotation.invalid.value", targetContainerType);
            fatalError = true;
        }
        Type valueRetType = containerValueSymbol.type.getReturnType();
        Type.ArrayType expectedType = this.types.makeArrayType(originalAnnoType);
        if (!this.types.isArray(valueRetType) || !this.types.isSameType(expectedType, valueRetType)) {
            this.log.error(pos, "invalid.repeatable.annotation.value.return", targetContainerType, valueRetType, expectedType);
            fatalError = true;
        }
        if (error) {
            fatalError = true;
        }
        return fatalError ? null : containerValueSymbol;
    }

    public class AnnotateRepeatedContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final Log log;
        public final boolean isTypeCompound;

        public AnnotateRepeatedContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> annotated, Map<T, JCDiagnostic.DiagnosticPosition> pos, Log log, boolean isTypeCompound) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(annotated);
            Assert.checkNonNull(pos);
            Assert.checkNonNull(log);
            this.env = env;
            this.annotated = annotated;
            this.pos = pos;
            this.log = log;
            this.isTypeCompound = isTypeCompound;
        }

        public T processRepeatedAnnotations(List<T> repeatingAnnotations, Symbol sym) {
            return (T)Annotate.this.processRepeatedAnnotations(repeatingAnnotations, this, sym);
        }

        public void annotateRepeated(Worker a) {
            Annotate.this.repeated(a);
        }
    }

    public static interface Worker {
        public void run();

        public String toString();
    }
}

