/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavacTaskImpl
extends BasicJavacTask {
    private Main compilerMain;
    private JavaCompiler compiler;
    private Locale locale;
    private String[] args;
    private String[] classNames;
    private List<JavaFileObject> fileObjects;
    private Map<JavaFileObject, JCTree.JCCompilationUnit> notYetEntered;
    private ListBuffer<Env<AttrContext>> genList;
    private final AtomicBoolean used = new AtomicBoolean();
    private Iterable<? extends Processor> processors;
    private Main.Result result = null;
    private boolean parsed = false;

    JavacTaskImpl(Main compilerMain, String[] args, String[] classNames, Context context, List<JavaFileObject> fileObjects) {
        super(null, false);
        this.compilerMain = compilerMain;
        this.args = args;
        this.classNames = classNames;
        this.context = context;
        this.fileObjects = fileObjects;
        this.setLocale(Locale.getDefault());
        compilerMain.getClass();
        args.getClass();
        fileObjects.getClass();
    }

    JavacTaskImpl(Main compilerMain, Iterable<String> args, Context context, Iterable<String> classes, Iterable<? extends JavaFileObject> fileObjects) {
        this(compilerMain, JavacTaskImpl.toArray(args), JavacTaskImpl.toArray(classes), context, JavacTaskImpl.toList(fileObjects));
    }

    private static String[] toArray(Iterable<String> iter) {
        ListBuffer<String> result = new ListBuffer<String>();
        if (iter != null) {
            for (String s : iter) {
                result.append(s);
            }
        }
        return result.toArray(new String[result.length()]);
    }

    private static List<JavaFileObject> toList(Iterable<? extends JavaFileObject> fileObjects) {
        if (fileObjects == null) {
            return List.nil();
        }
        ListBuffer<JavaFileObject> result = new ListBuffer<JavaFileObject>();
        for (JavaFileObject javaFileObject : fileObjects) {
            result.append(javaFileObject);
        }
        return result.toList();
    }

    public Main.Result doCall() {
        if (!this.used.getAndSet(true)) {
            this.initContext();
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            this.compilerMain.setAPIMode(true);
            this.result = this.compilerMain.compile(this.args, this.classNames, this.context, this.fileObjects, this.processors);
            this.cleanup();
            return this.result;
        }
        throw new IllegalStateException("multiple calls to method 'call'");
    }

    @Override
    public Boolean call() {
        return this.doCall().isOK();
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        processors.getClass();
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.processors = processors;
    }

    @Override
    public void setLocale(Locale locale) {
        if (this.used.get()) {
            throw new IllegalStateException();
        }
        this.locale = locale;
    }

    private void prepareCompiler() throws IOException {
        if (this.used.getAndSet(true)) {
            if (this.compiler == null) {
                throw new IllegalStateException();
            }
        } else {
            this.initContext();
            this.compilerMain.log = Log.instance(this.context);
            this.compilerMain.setOptions(Options.instance(this.context));
            this.compilerMain.filenames = new LinkedHashSet<File>();
            Collection<File> filenames = this.compilerMain.processArgs(CommandLine.parse(this.args), this.classNames);
            if (filenames != null && !filenames.isEmpty()) {
                throw new IllegalArgumentException("Malformed arguments " + this.toString(filenames, " "));
            }
            this.compiler = JavaCompiler.instance(this.context);
            this.compiler.keepComments = true;
            this.compiler.genEndPos = true;
            this.compiler.initProcessAnnotations(this.processors);
            this.notYetEntered = new HashMap<JavaFileObject, JCTree.JCCompilationUnit>();
            for (JavaFileObject file : this.fileObjects) {
                this.notYetEntered.put(file, null);
            }
            this.genList = new ListBuffer();
            this.args = null;
            this.classNames = null;
        }
    }

    <T> String toString(Iterable<T> items, String sep) {
        String currSep = "";
        StringBuilder sb = new StringBuilder();
        for (T item : items) {
            sb.append(currSep);
            sb.append(item.toString());
            currSep = sep;
        }
        return sb.toString();
    }

    private void initContext() {
        this.context.put(JavacTask.class, this);
        this.context.put(Locale.class, this.locale);
    }

    void cleanup() {
        if (this.compiler != null) {
            this.compiler.close();
        }
        this.compiler = null;
        this.compilerMain = null;
        this.args = null;
        this.classNames = null;
        this.context = null;
        this.fileObjects = null;
        this.notYetEntered = null;
    }

    public JavaFileObject asJavaFileObject(File file) {
        JavacFileManager fm = (JavacFileManager)this.context.get(JavaFileManager.class);
        return fm.getRegularFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<? extends CompilationUnitTree> parse() throws IOException {
        try {
            this.prepareCompiler();
            List<JCTree.JCCompilationUnit> units = this.compiler.parseFiles(this.fileObjects);
            for (JCTree.JCCompilationUnit unit : units) {
                JavaFileObject file = unit.getSourceFile();
                if (!this.notYetEntered.containsKey(file)) continue;
                this.notYetEntered.put(file, unit);
            }
            List<JCTree.JCCompilationUnit> list = units;
            return list;
        }
        finally {
            this.parsed = true;
            if (this.compiler != null && this.compiler.log != null) {
                this.compiler.log.flush();
            }
        }
    }

    public Iterable<? extends TypeElement> enter() throws IOException {
        return this.enter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends TypeElement> enter(Iterable<? extends CompilationUnitTree> trees) throws IOException {
        if (trees == null && this.notYetEntered != null && this.notYetEntered.isEmpty()) {
            return List.nil();
        }
        this.prepareCompiler();
        ListBuffer<JCTree.JCCompilationUnit> roots = null;
        if (trees == null) {
            if (this.notYetEntered.size() > 0) {
                if (!this.parsed) {
                    this.parse();
                }
                for (JavaFileObject javaFileObject : this.fileObjects) {
                    JCTree.JCCompilationUnit unit = this.notYetEntered.remove(javaFileObject);
                    if (unit == null) continue;
                    if (roots == null) {
                        roots = new ListBuffer();
                    }
                    roots.append(unit);
                }
                this.notYetEntered.clear();
            }
        } else {
            for (CompilationUnitTree compilationUnitTree : trees) {
                if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
                    if (roots == null) {
                        roots = new ListBuffer<JCTree.JCCompilationUnit>();
                    }
                    roots.append((JCTree.JCCompilationUnit)compilationUnitTree);
                    this.notYetEntered.remove(compilationUnitTree.getSourceFile());
                    continue;
                }
                throw new IllegalArgumentException(compilationUnitTree.toString());
            }
        }
        if (roots == null) {
            return List.nil();
        }
        try {
            List<JCTree.JCCompilationUnit> units = this.compiler.enterTrees(roots.toList());
            if (this.notYetEntered.isEmpty()) {
                this.compiler = this.compiler.processAnnotations(units);
            }
            ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
            for (JCTree.JCCompilationUnit unit : units) {
                for (JCTree node : unit.defs) {
                    if (!node.hasTag(JCTree.Tag.CLASSDEF)) continue;
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)node;
                    if (cdef.sym == null) continue;
                    listBuffer.append(cdef.sym);
                }
            }
            List list = listBuffer.toList();
            return list;
        }
        finally {
            this.compiler.log.flush();
        }
    }

    @Override
    public Iterable<? extends Element> analyze() throws IOException {
        return this.analyze(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends Element> analyze(Iterable<? extends TypeElement> classes) throws IOException {
        this.enter(null);
        final ListBuffer<Element> results = new ListBuffer<Element>();
        try {
            if (classes == null) {
                this.handleFlowResults(this.compiler.flow(this.compiler.attribute(this.compiler.todo)), results);
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.handleFlowResults(JavacTaskImpl.this.compiler.flow(JavacTaskImpl.this.compiler.attribute(env)), results);
                    }
                };
                f.run(this.compiler.todo, classes);
            }
        }
        finally {
            this.compiler.log.flush();
        }
        return results;
    }

    private void handleFlowResults(Queue<Env<AttrContext>> queue, ListBuffer<Element> elems) {
        for (Env env : queue) {
            switch (env.tree.getTag()) {
                case CLASSDEF: {
                    JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)env.tree;
                    if (cdef.sym == null) break;
                    elems.append(cdef.sym);
                    break;
                }
                case TOPLEVEL: {
                    JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)env.tree;
                    if (unit.packge == null) break;
                    elems.append(unit.packge);
                }
            }
        }
        this.genList.addAll((Collection<Env<AttrContext>>)queue);
    }

    @Override
    public Iterable<? extends JavaFileObject> generate() throws IOException {
        return this.generate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<? extends JavaFileObject> generate(Iterable<? extends TypeElement> classes) throws IOException {
        final ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        try {
            this.analyze(null);
            if (classes == null) {
                this.compiler.generate(this.compiler.desugar(this.genList), results);
                this.genList.clear();
            } else {
                Filter f = new Filter(){

                    @Override
                    public void process(Env<AttrContext> env) {
                        JavacTaskImpl.this.compiler.generate(JavacTaskImpl.this.compiler.desugar(ListBuffer.of(env)), results);
                    }
                };
                f.run(this.genList, classes);
            }
            if (this.genList.isEmpty()) {
                this.compiler.reportDeferredDiagnostics();
                this.cleanup();
            }
        }
        finally {
            if (this.compiler != null) {
                this.compiler.log.flush();
            }
        }
        return results;
    }

    @Override
    public TypeMirror getTypeMirror(Iterable<? extends Tree> path) {
        Tree last = null;
        Iterator<? extends Tree> iterator = path.iterator();
        while (iterator.hasNext()) {
            Tree node;
            last = node = iterator.next();
        }
        return ((JCTree)last).type;
    }

    @Override
    public JavacElements getElements() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacElements.instance(this.context);
    }

    @Override
    public JavacTypes getTypes() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return JavacTypes.instance(this.context);
    }

    public Iterable<? extends Tree> pathFor(CompilationUnitTree unit, Tree node) {
        return TreeInfo.pathFor((JCTree)node, (JCTree.JCCompilationUnit)unit).reverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type parseType(String expr, TypeElement scope) {
        if (expr == null || expr.equals("")) {
            throw new IllegalArgumentException();
        }
        this.compiler = JavaCompiler.instance(this.context);
        JavaFileObject prev = this.compiler.log.useSource(null);
        ParserFactory parserFactory = ParserFactory.instance(this.context);
        Attr attr = Attr.instance(this.context);
        try {
            CharBuffer buf = CharBuffer.wrap((expr + "\u0000").toCharArray(), 0, expr.length());
            JavacParser parser = parserFactory.newParser(buf, false, false, false);
            JCTree.JCExpression tree = parser.parseType();
            Type type = attr.attribType((JCTree)tree, (Symbol.TypeSymbol)((Object)scope));
            return type;
        }
        finally {
            this.compiler.log.useSource(prev);
        }
    }

    abstract class Filter {
        Filter() {
        }

        void run(Queue<Env<AttrContext>> list, Iterable<? extends TypeElement> classes) {
            HashSet<TypeElement> set = new HashSet<TypeElement>();
            for (TypeElement typeElement : classes) {
                set.add(typeElement);
            }
            ListBuffer<Env<AttrContext>> defer = new ListBuffer<Env<AttrContext>>();
            while (list.peek() != null) {
                Env<AttrContext> env = list.remove();
                Symbol.ClassSymbol csym = env.enclClass.sym;
                if (csym != null && set.contains(csym.outermostClass())) {
                    this.process(env);
                    continue;
                }
                defer = defer.append(env);
            }
            list.addAll(defer);
        }

        abstract void process(Env<AttrContext> var1);
    }
}

