/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

public class JNIWriter {
    protected static final Context.Key<JNIWriter> jniWriterKey = new Context.Key();
    private final JavaFileManager fileManager;
    JavacElements elements;
    JavacTypes types;
    private final Log log;
    private boolean verbose;
    private boolean checkAll;
    private Mangle mangler;
    private Context context;
    private Symtab syms;
    private String lineSep;
    private final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    public static JNIWriter instance(Context context) {
        JNIWriter instance = context.get(jniWriterKey);
        if (instance == null) {
            instance = new JNIWriter(context);
        }
        return instance;
    }

    private JNIWriter(Context context) {
        context.put(jniWriterKey, this);
        this.fileManager = context.get(JavaFileManager.class);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.isSet(Option.VERBOSE);
        this.checkAll = options.isSet("javah:full");
        this.context = context;
        this.syms = Symtab.instance(context);
        this.lineSep = System.getProperty("line.separator");
    }

    private void lazyInit() {
        if (this.mangler == null) {
            this.elements = JavacElements.instance(this.context);
            this.types = JavacTypes.instance(this.context);
            this.mangler = new Mangle(this.elements, this.types);
        }
    }

    public boolean needsHeader(Symbol.ClassSymbol c) {
        if (c.isLocal() || (c.flags() & 0x1000L) != 0L) {
            return false;
        }
        if (this.checkAll) {
            return this.needsHeader(c.outermostClass(), true);
        }
        return this.needsHeader(c, false);
    }

    private boolean needsHeader(Symbol.ClassSymbol c, boolean checkNestedClasses) {
        if (c.isLocal() || (c.flags() & 0x1000L) != 0L) {
            return false;
        }
        Scope.Entry i = c.members_field.elems;
        while (i != null) {
            if (i.sym.kind == 16 && (i.sym.flags() & 0x100L) != 0L) {
                return true;
            }
            for (Attribute.Compound a : i.sym.getDeclarationAttributes()) {
                if (a.type.tsym != this.syms.nativeHeaderType.tsym) continue;
                return true;
            }
            i = i.sibling;
        }
        if (checkNestedClasses) {
            i = c.members_field.elems;
            while (i != null) {
                if (i.sym.kind == 2 && this.needsHeader((Symbol.ClassSymbol)i.sym, true)) {
                    return true;
                }
                i = i.sibling;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject write(Symbol.ClassSymbol c) throws IOException {
        String className = c.flatName().toString();
        FileObject outFile = this.fileManager.getFileForOutput(StandardLocation.NATIVE_HEADER_OUTPUT, "", className.replaceAll("[.$]", "_") + ".h", null);
        Writer out = outFile.openWriter();
        try {
            this.write(out, c);
            if (this.verbose) {
                this.log.printVerbose("wrote.file", outFile);
            }
            out.close();
            out = null;
        }
        finally {
            if (out != null) {
                out.close();
                outFile.delete();
                outFile = null;
            }
        }
        return outFile;
    }

    public void write(Writer out, Symbol.ClassSymbol sym) throws IOException {
        this.lazyInit();
        try {
            String cname = this.mangler.mangle(sym.fullname, 1);
            this.println(out, this.fileTop());
            this.println(out, this.includes());
            this.println(out, this.guardBegin(cname));
            this.println(out, this.cppGuardBegin());
            this.writeStatics(out, sym);
            this.writeMethods(out, sym, cname);
            this.println(out, this.cppGuardEnd());
            this.println(out, this.guardEnd(cname));
        }
        catch (TypeSignature.SignatureException e) {
            throw new IOException(e);
        }
    }

    protected void writeStatics(Writer out, Symbol.ClassSymbol sym) throws IOException {
        List<VariableElement> classfields = this.getAllFields(sym);
        for (VariableElement v : classfields) {
            if (!v.getModifiers().contains((Object)Modifier.STATIC)) continue;
            String s = null;
            s = this.defineForStatic(sym, v);
            if (s == null) continue;
            this.println(out, s);
        }
    }

    List<VariableElement> getAllFields(TypeElement subclazz) {
        ArrayList<VariableElement> fields = new ArrayList<VariableElement>();
        TypeElement cd = null;
        Stack<TypeElement> s = new Stack<TypeElement>();
        cd = subclazz;
        while (true) {
            s.push(cd);
            TypeElement c = (TypeElement)this.types.asElement(cd.getSuperclass());
            if (c == null) break;
            cd = c;
        }
        while (!s.empty()) {
            cd = (TypeElement)s.pop();
            fields.addAll(ElementFilter.fieldsIn(cd.getEnclosedElements()));
        }
        return fields;
    }

    protected String defineForStatic(TypeElement c, VariableElement f) {
        Name cnamedoc = c.getQualifiedName();
        Name fnamedoc = f.getSimpleName();
        String cname = this.mangler.mangle(cnamedoc, 1);
        String fname = this.mangler.mangle(fnamedoc, 2);
        Assert.check(f.getModifiers().contains((Object)Modifier.STATIC));
        if (f.getModifiers().contains((Object)Modifier.FINAL)) {
            Object value = null;
            value = f.getConstantValue();
            if (value != null) {
                String constString = null;
                if (value instanceof Integer || value instanceof Byte || value instanceof Short) {
                    constString = value.toString() + "L";
                } else if (value instanceof Boolean) {
                    constString = (Boolean)value != false ? "1L" : "0L";
                } else if (value instanceof Character) {
                    Character ch = (Character)value;
                    constString = String.valueOf(ch.charValue() & 0xFFFF) + "L";
                } else if (value instanceof Long) {
                    constString = this.isWindows ? value.toString() + "i64" : value.toString() + "LL";
                } else if (value instanceof Float) {
                    float fv = ((Float)value).floatValue();
                    constString = Float.isInfinite(fv) ? (fv < 0.0f ? "-" : "") + "Inff" : value.toString() + "f";
                } else if (value instanceof Double) {
                    double d = (Double)value;
                    constString = Double.isInfinite(d) ? (d < 0.0 ? "-" : "") + "InfD" : value.toString();
                }
                if (constString != null) {
                    StringBuilder s = new StringBuilder("#undef ");
                    s.append(cname);
                    s.append("_");
                    s.append(fname);
                    s.append(this.lineSep);
                    s.append("#define ");
                    s.append(cname);
                    s.append("_");
                    s.append(fname);
                    s.append(" ");
                    s.append(constString);
                    return s.toString();
                }
            }
        }
        return null;
    }

    protected void writeMethods(Writer out, Symbol.ClassSymbol sym, String cname) throws IOException, TypeSignature.SignatureException {
        List<ExecutableElement> classmethods = ElementFilter.methodsIn(sym.getEnclosedElements());
        for (ExecutableElement md : classmethods) {
            if (!md.getModifiers().contains((Object)Modifier.NATIVE)) continue;
            TypeMirror mtr = this.types.erasure(md.getReturnType());
            String sig = this.signature(md);
            TypeSignature newtypesig = new TypeSignature(this.elements);
            Name methodName = md.getSimpleName();
            boolean longName = false;
            for (ExecutableElement md2 : classmethods) {
                if (md2 == md || !((Object)methodName).equals(md2.getSimpleName()) || !md2.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                longName = true;
            }
            this.println(out, "/*");
            this.println(out, " * Class:     " + cname);
            this.println(out, " * Method:    " + this.mangler.mangle(methodName, 2));
            this.println(out, " * Signature: " + newtypesig.getTypeSignature(sig, mtr));
            this.println(out, " */");
            this.println(out, "JNIEXPORT " + this.jniType(mtr) + " JNICALL " + this.mangler.mangleMethod(md, sym, longName ? 8 : 7));
            this.print(out, "  (JNIEnv *, ");
            List<? extends VariableElement> paramargs = md.getParameters();
            ArrayList<TypeMirror> args = new ArrayList<TypeMirror>();
            for (VariableElement variableElement : paramargs) {
                args.add(this.types.erasure(variableElement.asType()));
            }
            if (md.getModifiers().contains((Object)Modifier.STATIC)) {
                this.print(out, "jclass");
            } else {
                this.print(out, "jobject");
            }
            for (TypeMirror typeMirror : args) {
                this.print(out, ", ");
                this.print(out, this.jniType(typeMirror));
            }
            this.println(out, ");" + this.lineSep);
        }
    }

    String signature(ExecutableElement e) {
        StringBuilder sb = new StringBuilder("(");
        String sep = "";
        for (VariableElement variableElement : e.getParameters()) {
            sb.append(sep);
            sb.append(this.types.erasure(variableElement.asType()).toString());
            sep = ",";
        }
        sb.append(")");
        return sb.toString();
    }

    protected final String jniType(TypeMirror t) {
        Symbol.ClassSymbol throwable = this.elements.getTypeElement("java.lang.Throwable");
        Symbol.ClassSymbol jClass = this.elements.getTypeElement("java.lang.Class");
        Symbol.ClassSymbol jString = this.elements.getTypeElement("java.lang.String");
        Element tclassDoc = this.types.asElement(t);
        switch (t.getKind()) {
            case ARRAY: {
                TypeMirror ct = ((ArrayType)t).getComponentType();
                switch (ct.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(ct.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (tclassDoc.equals(jString)) {
                    return "jstring";
                }
                if (this.types.isAssignable(t, throwable.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(t, jClass.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        Assert.check(false, "jni unknown type");
        return null;
    }

    protected String fileTop() {
        return "/* DO NOT EDIT THIS FILE - it is machine generated */";
    }

    protected String includes() {
        return "#include <jni.h>";
    }

    protected String cppGuardBegin() {
        return "#ifdef __cplusplus" + this.lineSep + "extern \"C\" {" + this.lineSep + "#endif";
    }

    protected String cppGuardEnd() {
        return "#ifdef __cplusplus" + this.lineSep + "}" + this.lineSep + "#endif";
    }

    protected String guardBegin(String cname) {
        return "/* Header for class " + cname + " */" + this.lineSep + this.lineSep + "#ifndef _Included_" + cname + this.lineSep + "#define _Included_" + cname;
    }

    protected String guardEnd(String cname) {
        return "#endif";
    }

    protected void print(Writer out, String text) throws IOException {
        out.write(text);
    }

    protected void println(Writer out, String text) throws IOException {
        out.write(text);
        out.write(this.lineSep);
    }

    private static class TypeSignature {
        Elements elems;
        private static final String SIG_VOID = "V";
        private static final String SIG_BOOLEAN = "Z";
        private static final String SIG_BYTE = "B";
        private static final String SIG_CHAR = "C";
        private static final String SIG_SHORT = "S";
        private static final String SIG_INT = "I";
        private static final String SIG_LONG = "J";
        private static final String SIG_FLOAT = "F";
        private static final String SIG_DOUBLE = "D";
        private static final String SIG_ARRAY = "[";
        private static final String SIG_CLASS = "L";

        public TypeSignature(Elements elems) {
            this.elems = elems;
        }

        public String getTypeSignature(String javasignature) throws SignatureException {
            return this.getParamJVMSignature(javasignature);
        }

        public String getTypeSignature(String javasignature, TypeMirror returnType) throws SignatureException {
            String signature = null;
            String typeSignature = null;
            ArrayList<String> params = new ArrayList<String>();
            String paramsig = null;
            String paramJVMSig = null;
            String returnSig = null;
            String returnJVMType = null;
            int dimensions = 0;
            int startIndex = -1;
            int endIndex = -1;
            StringTokenizer st = null;
            int i = 0;
            if (javasignature != null) {
                startIndex = javasignature.indexOf("(");
                endIndex = javasignature.indexOf(")");
            }
            if (startIndex != -1 && endIndex != -1 && startIndex + 1 < javasignature.length() && endIndex < javasignature.length()) {
                signature = javasignature.substring(startIndex + 1, endIndex);
            }
            if (signature != null) {
                if (signature.indexOf(",") != -1) {
                    st = new StringTokenizer(signature, ",");
                    if (st != null) {
                        while (st.hasMoreTokens()) {
                            params.add(st.nextToken());
                        }
                    }
                } else {
                    params.add(signature);
                }
            }
            typeSignature = "(";
            while (!params.isEmpty()) {
                paramsig = ((String)params.remove(i)).trim();
                paramJVMSig = this.getParamJVMSignature(paramsig);
                if (paramJVMSig == null) continue;
                typeSignature = typeSignature + paramJVMSig;
            }
            typeSignature = typeSignature + ")";
            returnJVMType = "";
            if (returnType != null) {
                dimensions = this.dimensions(returnType);
            }
            while (dimensions-- > 0) {
                returnJVMType = returnJVMType + SIG_ARRAY;
            }
            if (returnType != null) {
                returnSig = this.qualifiedTypeName(returnType);
                returnJVMType = returnJVMType + this.getComponentType(returnSig);
            } else {
                System.out.println("Invalid return type.");
            }
            typeSignature = typeSignature + returnJVMType;
            return typeSignature;
        }

        private String getParamJVMSignature(String paramsig) throws SignatureException {
            String paramJVMSig = "";
            String componentType = "";
            if (paramsig != null) {
                if (paramsig.indexOf("[]") != -1) {
                    int endindex = paramsig.indexOf("[]");
                    componentType = paramsig.substring(0, endindex);
                    String dimensionString = paramsig.substring(endindex);
                    if (dimensionString != null) {
                        while (dimensionString.indexOf("[]") != -1) {
                            paramJVMSig = paramJVMSig + SIG_ARRAY;
                            int beginindex = dimensionString.indexOf("]") + 1;
                            if (beginindex < dimensionString.length()) {
                                dimensionString = dimensionString.substring(beginindex);
                                continue;
                            }
                            dimensionString = "";
                        }
                    }
                } else {
                    componentType = paramsig;
                }
                paramJVMSig = paramJVMSig + this.getComponentType(componentType);
            }
            return paramJVMSig;
        }

        private String getComponentType(String componentType) throws SignatureException {
            String JVMSig = "";
            if (componentType != null) {
                if (componentType.equals("void")) {
                    JVMSig = JVMSig + SIG_VOID;
                } else if (componentType.equals("boolean")) {
                    JVMSig = JVMSig + SIG_BOOLEAN;
                } else if (componentType.equals("byte")) {
                    JVMSig = JVMSig + SIG_BYTE;
                } else if (componentType.equals("char")) {
                    JVMSig = JVMSig + SIG_CHAR;
                } else if (componentType.equals("short")) {
                    JVMSig = JVMSig + SIG_SHORT;
                } else if (componentType.equals("int")) {
                    JVMSig = JVMSig + SIG_INT;
                } else if (componentType.equals("long")) {
                    JVMSig = JVMSig + SIG_LONG;
                } else if (componentType.equals("float")) {
                    JVMSig = JVMSig + SIG_FLOAT;
                } else if (componentType.equals("double")) {
                    JVMSig = JVMSig + SIG_DOUBLE;
                } else if (!componentType.equals("")) {
                    TypeElement classNameDoc = this.elems.getTypeElement(componentType);
                    if (classNameDoc == null) {
                        throw new SignatureException(componentType);
                    }
                    String classname = classNameDoc.getQualifiedName().toString();
                    String newclassname = classname.replace('.', '/');
                    JVMSig = JVMSig + SIG_CLASS;
                    JVMSig = JVMSig + newclassname;
                    JVMSig = JVMSig + ";";
                }
            }
            return JVMSig;
        }

        int dimensions(TypeMirror t) {
            if (t.getKind() != TypeKind.ARRAY) {
                return 0;
            }
            return 1 + this.dimensions(((ArrayType)t).getComponentType());
        }

        String qualifiedTypeName(TypeMirror type) {
            SimpleTypeVisitor8<Name, Void> v = new SimpleTypeVisitor8<Name, Void>(){

                @Override
                public Name visitArray(ArrayType t, Void p) {
                    return t.getComponentType().accept(this, p);
                }

                @Override
                public Name visitDeclared(DeclaredType t, Void p) {
                    return ((TypeElement)t.asElement()).getQualifiedName();
                }

                @Override
                public Name visitPrimitive(PrimitiveType t, Void p) {
                    return TypeSignature.this.elems.getName(t.toString());
                }

                @Override
                public Name visitNoType(NoType t, Void p) {
                    if (t.getKind() == TypeKind.VOID) {
                        return TypeSignature.this.elems.getName("void");
                    }
                    return (Name)this.defaultAction(t, p);
                }

                @Override
                public Name visitTypeVariable(TypeVariable t, Void p) {
                    return t.getUpperBound().accept(this, p);
                }
            };
            return ((Name)v.visit(type)).toString();
        }

        static class SignatureException
        extends Exception {
            private static final long serialVersionUID = 1L;

            SignatureException(String reason) {
                super(reason);
            }
        }
    }

    private static class Mangle {
        private Elements elems;
        private Types types;

        Mangle(Elements elems, Types types) {
            this.elems = elems;
            this.types = types;
        }

        public final String mangle(CharSequence name, int mtype) {
            StringBuilder result = new StringBuilder(100);
            int length = name.length();
            for (int i = 0; i < length; ++i) {
                char ch = name.charAt(i);
                if (Mangle.isalnum(ch)) {
                    result.append(ch);
                    continue;
                }
                if (ch == '.' && mtype == 1) {
                    result.append('_');
                    continue;
                }
                if (ch == '$' && mtype == 1) {
                    result.append('_');
                    result.append('_');
                    continue;
                }
                if (ch == '_' && mtype == 2) {
                    result.append('_');
                    continue;
                }
                if (ch == '_' && mtype == 1) {
                    result.append('_');
                    continue;
                }
                if (mtype == 4) {
                    String esc = null;
                    if (ch == '_') {
                        esc = "_1";
                    } else if (ch == '.') {
                        esc = "_";
                    } else if (ch == ';') {
                        esc = "_2";
                    } else if (ch == '[') {
                        esc = "_3";
                    }
                    if (esc != null) {
                        result.append(esc);
                        continue;
                    }
                    result.append(this.mangleChar(ch));
                    continue;
                }
                if (mtype == 5) {
                    if (Mangle.isprint(ch)) {
                        result.append(ch);
                        continue;
                    }
                    result.append(this.mangleChar(ch));
                    continue;
                }
                result.append(this.mangleChar(ch));
            }
            return result.toString();
        }

        public String mangleMethod(ExecutableElement method, TypeElement clazz, int mtype) throws TypeSignature.SignatureException {
            StringBuilder result = new StringBuilder(100);
            result.append("Java_");
            if (mtype == 6) {
                result.append(this.mangle(clazz.getQualifiedName(), 1));
                result.append('_');
                result.append(this.mangle(method.getSimpleName(), 3));
                result.append("_stub");
                return result.toString();
            }
            result.append(this.mangle(this.getInnerQualifiedName(clazz), 4));
            result.append('_');
            result.append(this.mangle(method.getSimpleName(), 4));
            if (mtype == 8) {
                result.append("__");
                String typesig = this.signature(method);
                TypeSignature newTypeSig = new TypeSignature(this.elems);
                String sig = newTypeSig.getTypeSignature(typesig, method.getReturnType());
                sig = sig.substring(1);
                sig = sig.substring(0, sig.lastIndexOf(41));
                sig = sig.replace('/', '.');
                result.append(this.mangle(sig, 4));
            }
            return result.toString();
        }

        private String getInnerQualifiedName(TypeElement clazz) {
            return this.elems.getBinaryName(clazz).toString();
        }

        public final String mangleChar(char ch) {
            int i;
            String s = Integer.toHexString(ch);
            int nzeros = 5 - s.length();
            char[] result = new char[6];
            result[0] = 95;
            for (i = 1; i <= nzeros; ++i) {
                result[i] = 48;
            }
            i = nzeros + 1;
            int j = 0;
            while (i < 6) {
                result[i] = s.charAt(j);
                ++i;
                ++j;
            }
            return new String(result);
        }

        private String signature(ExecutableElement e) {
            StringBuilder sb = new StringBuilder();
            String sep = "(";
            for (VariableElement variableElement : e.getParameters()) {
                sb.append(sep);
                sb.append(this.types.erasure(variableElement.asType()).toString());
                sep = ",";
            }
            sb.append(")");
            return sb.toString();
        }

        private static boolean isalnum(char ch) {
            return ch <= '\u007f' && (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9');
        }

        private static boolean isprint(char ch) {
            return ch >= ' ' && ch <= '~';
        }

        public static class Type {
            public static final int CLASS = 1;
            public static final int FIELDSTUB = 2;
            public static final int FIELD = 3;
            public static final int JNI = 4;
            public static final int SIGNATURE = 5;
            public static final int METHOD_JDK_1 = 6;
            public static final int METHOD_JNI_SHORT = 7;
            public static final int METHOD_JNI_LONG = 8;
        }
    }
}

