/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.file.ZipArchive;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public class SymbolArchive
extends ZipArchive {
    final File origFile;
    final RelativePath.RelativeDirectory prefix;

    public SymbolArchive(JavacFileManager fileManager, File orig, ZipFile zdir, RelativePath.RelativeDirectory prefix) throws IOException {
        super(fileManager, zdir, false);
        this.origFile = orig;
        this.prefix = prefix;
        this.initMap();
    }

    @Override
    void addZipEntry(ZipEntry entry) {
        String name = entry.getName();
        if (!name.startsWith(this.prefix.path)) {
            return;
        }
        name = name.substring(this.prefix.path.length());
        int i = name.lastIndexOf(47);
        RelativePath.RelativeDirectory dirname = new RelativePath.RelativeDirectory(name.substring(0, i + 1));
        String basename = name.substring(i + 1);
        if (basename.length() == 0) {
            return;
        }
        List<String> list = (List<String>)this.map.get(dirname);
        if (list == null) {
            list = List.nil();
        }
        list = list.prepend(basename);
        this.map.put(dirname, list);
    }

    @Override
    public JavaFileObject getFileObject(RelativePath.RelativeDirectory subdirectory, String file) {
        RelativePath.RelativeDirectory prefix_subdir = new RelativePath.RelativeDirectory(this.prefix, subdirectory.path);
        ZipEntry ze = new RelativePath.RelativeFile(prefix_subdir, file).getZipEntry(this.zfile);
        return new SymbolFileObject(this, file, ze);
    }

    @Override
    public String toString() {
        return "SymbolArchive[" + this.zfile.getName() + "]";
    }

    public static class SymbolFileObject
    extends ZipArchive.ZipFileObject {
        protected SymbolFileObject(SymbolArchive zarch, String name, ZipEntry entry) {
            super(zarch, name, entry);
        }

        @Override
        protected String inferBinaryName(Iterable<? extends File> path) {
            String prefix;
            String entryName = this.entry.getName();
            if (entryName.startsWith(prefix = ((SymbolArchive)this.zarch).prefix.path)) {
                entryName = entryName.substring(prefix.length());
            }
            return SymbolFileObject.removeExtension(entryName).replace('/', '.');
        }
    }
}

