/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Iterator;

public class Flow {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private final JCDiagnostic.Factory diags;
    private Env<AttrContext> attrEnv;
    private Lint lint;
    private final boolean allowImprovedRethrowAnalysis;
    private final boolean allowImprovedCatchAnalysis;
    private final boolean allowEffectivelyFinalInInnerClasses;
    private final boolean enforceThisDotInit;

    public static Flow instance(Context context) {
        Flow instance = context.get(flowKey);
        if (instance == null) {
            instance = new Flow(context);
        }
        return instance;
    }

    public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
        new AliveAnalyzer().analyzeTree(env, make);
        new AssignAnalyzer().analyzeTree(env);
        new FlowAnalyzer().analyzeTree(env, make);
        new CaptureAnalyzer().analyzeTree(env, make);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeLambda(Env<AttrContext> env, JCTree.JCLambda that, TreeMaker make, boolean speculative) {
        Log.DiscardDiagnosticHandler diagHandler = null;
        if (!speculative) {
            diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        }
        try {
            new AliveAnalyzer().analyzeTree(env, that, make);
        }
        finally {
            if (!speculative) {
                this.log.popDiagnosticHandler(diagHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> analyzeLambdaThrownTypes(final Env<AttrContext> env, JCTree.JCLambda that, TreeMaker make) {
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            new AssignAnalyzer(){
                Scope enclosedSymbols;
                {
                    this.enclosedSymbols = new Scope(env.enclClass.sym);
                }

                @Override
                public void visitVarDef(JCTree.JCVariableDecl tree) {
                    this.enclosedSymbols.enter(tree.sym);
                    super.visitVarDef(tree);
                }

                @Override
                protected boolean trackable(Symbol.VarSymbol sym) {
                    return this.enclosedSymbols.includes(sym) && sym.owner.kind == 16;
                }
            }.analyzeTree(env, that);
            LambdaFlowAnalyzer flowAnalyzer = new LambdaFlowAnalyzer();
            flowAnalyzer.analyzeTree(env, that, make);
            List<Type> list = flowAnalyzer.inferredThrownTypes;
            return list;
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.lint = Lint.instance(context);
        this.rs = Resolve.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        this.allowImprovedRethrowAnalysis = source.allowImprovedRethrowAnalysis();
        this.allowImprovedCatchAnalysis = source.allowImprovedCatchAnalysis();
        this.allowEffectivelyFinalInInnerClasses = source.allowEffectivelyFinalInInnerClasses();
        this.enforceThisDotInit = source.enforceThisDotInit();
    }

    class CaptureAnalyzer
    extends BaseAnalyzer<BaseAnalyzer.PendingExit> {
        JCTree currentTree;

        CaptureAnalyzer() {
        }

        @Override
        void markDead(JCTree tree) {
        }

        void checkEffectivelyFinal(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            if (this.currentTree != null && sym.owner.kind == 16 && sym.pos < this.currentTree.getStartPosition()) {
                switch (this.currentTree.getTag()) {
                    case CLASSDEF: {
                        if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                            if ((sym.flags() & 0x10L) != 0L) break;
                            this.reportInnerClsNeedsFinalError(pos, sym);
                            break;
                        }
                    }
                    case LAMBDA: {
                        if ((sym.flags() & 0x20000000010L) != 0L) break;
                        this.reportEffectivelyFinalError(pos, sym);
                    }
                }
            }
        }

        void letInit(JCTree tree) {
            if ((tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.IDENT) || tree.hasTag(JCTree.Tag.SELECT)) {
                Symbol sym = TreeInfo.symbol(tree);
                if (this.currentTree != null && sym.kind == 4 && sym.owner.kind == 16 && ((Symbol.VarSymbol)sym).pos < this.currentTree.getStartPosition()) {
                    switch (this.currentTree.getTag()) {
                        case CLASSDEF: {
                            if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                                this.reportInnerClsNeedsFinalError(tree, sym);
                                break;
                            }
                        }
                        case LAMBDA: {
                            this.reportEffectivelyFinalError(tree, sym);
                        }
                    }
                }
            }
        }

        void reportEffectivelyFinalError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            String subKey = this.currentTree.hasTag(JCTree.Tag.LAMBDA) ? "lambda" : "inner.cls";
            Flow.this.log.error(pos, "cant.ref.non.effectively.final.var", sym, Flow.this.diags.fragment(subKey, new Object[0]));
        }

        void reportInnerClsNeedsFinalError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            Flow.this.log.error(pos, "local.var.accessed.from.icls.needs.final", sym);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            JCTree prevTree = this.currentTree;
            try {
                this.currentTree = tree.sym.isLocal() ? tree : null;
                super.visitClassDef(tree);
            }
            finally {
                this.currentTree = prevTree;
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            JCTree prevTree = this.currentTree;
            try {
                this.currentTree = tree;
                super.visitLambda(tree);
            }
            finally {
                this.currentTree = prevTree;
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (tree.sym.kind == 4) {
                this.checkEffectivelyFinal(tree, (Symbol.VarSymbol)tree.sym);
            }
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            JCTree.JCExpression lhs = TreeInfo.skipParens(tree.lhs);
            if (!(lhs instanceof JCTree.JCIdent)) {
                this.scan(lhs);
            }
            this.scan(tree.rhs);
            this.letInit(lhs);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            this.scan(tree.lhs);
            this.scan(tree.rhs);
            this.letInit(tree.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            switch (tree.getTag()) {
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scan(tree.arg);
                    this.letInit(tree.arg);
                    break;
                }
                default: {
                    this.scan(tree.arg);
                }
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    public class AssignAnalyzer
    extends AbstractAssignAnalyzer<AssignPendingExit> {
        @Override
        protected AssignPendingExit createNewPendingExit(JCTree tree, Bits inits, Bits uninits) {
            return new AssignPendingExit(tree, inits, uninits);
        }

        @Override
        void letInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            if (sym.adr >= this.firstadr && this.trackable(sym)) {
                if ((sym.flags() & 0x20000000000L) != 0L) {
                    if (!this.uninits.isMember(sym.adr)) {
                        sym.flags_field &= 0xFFFFFDFFFFFFFFFFL;
                    } else {
                        this.uninit(sym);
                    }
                } else if ((sym.flags() & 0x10L) != 0L) {
                    if ((sym.flags() & 0x200000000L) != 0L) {
                        if ((sym.flags() & 0x8000000000L) != 0L) {
                            Flow.this.log.error(pos, "multicatch.parameter.may.not.be.assigned", sym);
                        } else {
                            Flow.this.log.error(pos, "final.parameter.may.not.be.assigned", sym);
                        }
                    } else if (!this.uninits.isMember(sym.adr)) {
                        Flow.this.log.error(pos, this.flowKind.errKey, sym);
                    } else {
                        this.uninit(sym);
                    }
                }
                this.inits.incl(sym.adr);
            } else if ((sym.flags() & 0x10L) != 0L) {
                Flow.this.log.error(pos, "var.might.already.be.assigned", sym);
            }
        }

        @Override
        void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym, String errkey) {
            if ((sym.adr >= this.firstadr || sym.owner.kind != 2) && this.trackable(sym) && !this.inits.isMember(sym.adr)) {
                Flow.this.log.error(pos, errkey, sym);
                this.inits.incl(sym.adr);
            }
        }

        @Override
        void reportWarning(Lint.LintCategory lc, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
            Flow.this.log.warning(lc, pos, key, args);
        }

        @Override
        int getLogNumberOfErrors() {
            return ((Flow)Flow.this).log.nerrors;
        }

        @Override
        boolean isEnabled(Lint.LintCategory lc) {
            return Flow.this.lint.isEnabled(lc);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            Lint lintPrev = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            try {
                super.visitClassDef(tree);
            }
            finally {
                Flow.this.lint = lintPrev;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            if ((tree.sym.flags() & 0x1000L) != 0L) {
                return;
            }
            Lint lintPrev = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            try {
                super.visitMethodDef(tree);
            }
            finally {
                Flow.this.lint = lintPrev;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (tree.init == null) {
                super.visitVarDef(tree);
            } else {
                Lint lintPrev = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(tree.sym);
                try {
                    super.visitVarDef(tree);
                }
                finally {
                    Flow.this.lint = lintPrev;
                }
            }
        }

        public class AssignPendingExit
        extends AbstractAssignAnalyzer.AbstractAssignPendingExit {
            public AssignPendingExit(JCTree tree, Bits inits, Bits uninits) {
                super(tree, inits, uninits);
            }
        }
    }

    public abstract class AbstractAssignAnalyzer<P extends AbstractAssignPendingExit>
    extends BaseAnalyzer<P> {
        protected Bits inits;
        final Bits uninits;
        final Bits uninitsTry;
        final Bits initsWhenTrue;
        final Bits initsWhenFalse;
        final Bits uninitsWhenTrue;
        final Bits uninitsWhenFalse;
        protected JCTree.JCVariableDecl[] vardecls;
        JCTree.JCClassDecl classDef;
        int firstadr;
        protected int nextadr;
        protected int returnadr;
        Scope unrefdResources;
        FlowKind flowKind = FlowKind.NORMAL;
        int startPos;
        private boolean isInitialConstructor = false;

        public AbstractAssignAnalyzer() {
            this.inits = new Bits();
            this.uninits = new Bits();
            this.uninitsTry = new Bits();
            this.initsWhenTrue = new Bits(true);
            this.initsWhenFalse = new Bits(true);
            this.uninitsWhenTrue = new Bits(true);
            this.uninitsWhenFalse = new Bits(true);
        }

        @Override
        protected void markDead(JCTree tree) {
            if (!this.isInitialConstructor) {
                this.inits.inclRange(this.returnadr, this.nextadr);
            } else {
                for (int address = this.returnadr; address < this.nextadr; ++address) {
                    if (this.isFinalUninitializedStaticField(this.vardecls[address].sym)) continue;
                    this.inits.incl(address);
                }
            }
            this.uninits.inclRange(this.returnadr, this.nextadr);
        }

        protected boolean trackable(Symbol.VarSymbol sym) {
            return sym.pos >= this.startPos && (sym.owner.kind == 16 || this.isFinalUninitializedField(sym));
        }

        boolean isFinalUninitializedField(Symbol.VarSymbol sym) {
            return sym.owner.kind == 2 && (sym.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)sym.owner);
        }

        boolean isFinalUninitializedStaticField(Symbol.VarSymbol sym) {
            return this.isFinalUninitializedField(sym) && sym.isStatic();
        }

        void newVar(JCTree.JCVariableDecl varDecl) {
            Symbol.VarSymbol sym = varDecl.sym;
            this.vardecls = ArrayUtils.ensureCapacity(this.vardecls, this.nextadr);
            if ((sym.flags() & 0x10L) == 0L) {
                sym.flags_field |= 0x20000000000L;
            }
            sym.adr = this.nextadr;
            this.vardecls[this.nextadr] = varDecl;
            this.exclVarFromInits(varDecl, this.nextadr);
            this.uninits.incl(this.nextadr);
            ++this.nextadr;
        }

        protected void exclVarFromInits(JCTree tree, int adr) {
            this.inits.excl(adr);
        }

        protected void assignToInits(JCTree tree, Bits bits) {
            this.inits.assign(bits);
        }

        protected void andSetInits(JCTree tree, Bits bits) {
            this.inits.andSet(bits);
        }

        protected void orSetInits(JCTree tree, Bits bits) {
            this.inits.orSet(bits);
        }

        void letInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            if (sym.adr >= this.firstadr && this.trackable(sym)) {
                if (this.uninits.isMember(sym.adr)) {
                    this.uninit(sym);
                }
                this.inits.incl(sym.adr);
            }
        }

        void uninit(Symbol.VarSymbol sym) {
            if (!this.inits.isMember(sym.adr)) {
                this.uninits.excl(sym.adr);
                this.uninitsTry.excl(sym.adr);
            } else {
                this.uninits.excl(sym.adr);
            }
        }

        void letInit(JCTree tree) {
            if ((tree = TreeInfo.skipParens(tree)).hasTag(JCTree.Tag.IDENT) || tree.hasTag(JCTree.Tag.SELECT)) {
                Symbol sym = TreeInfo.symbol(tree);
                if (sym.kind == 4) {
                    this.letInit(tree.pos(), (Symbol.VarSymbol)sym);
                }
            }
        }

        void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym) {
            this.checkInit(pos, sym, "var.might.not.have.been.initialized");
        }

        void checkInit(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol sym, String errkey) {
        }

        private void resetBits(Bits ... bits) {
            for (Bits b : bits) {
                b.reset();
            }
        }

        void split(boolean setToNull) {
            this.initsWhenFalse.assign(this.inits);
            this.uninitsWhenFalse.assign(this.uninits);
            this.initsWhenTrue.assign(this.inits);
            this.uninitsWhenTrue.assign(this.uninits);
            if (setToNull) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        protected void merge(JCTree tree) {
            this.inits.assign(this.initsWhenFalse.andSet(this.initsWhenTrue));
            this.uninits.assign(this.uninitsWhenFalse.andSet(this.uninitsWhenTrue));
        }

        void scanExpr(JCTree tree) {
            if (tree != null) {
                this.scan(tree);
                if (this.inits.isReset()) {
                    this.merge(tree);
                }
            }
        }

        void scanExprs(List<? extends JCTree.JCExpression> trees) {
            if (trees != null) {
                List<JCTree.JCExpression> l = trees;
                while (l.nonEmpty()) {
                    this.scanExpr((JCTree)l.head);
                    l = l.tail;
                }
            }
        }

        void scanCond(JCTree tree) {
            if (tree.type.isFalse()) {
                if (this.inits.isReset()) {
                    this.merge(tree);
                }
                this.initsWhenTrue.assign(this.inits);
                this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenTrue.assign(this.uninits);
                this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.initsWhenFalse.assign(this.inits);
                this.uninitsWhenFalse.assign(this.uninits);
            } else if (tree.type.isTrue()) {
                if (this.inits.isReset()) {
                    this.merge(tree);
                }
                this.initsWhenFalse.assign(this.inits);
                this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenFalse.assign(this.uninits);
                this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.initsWhenTrue.assign(this.inits);
                this.uninitsWhenTrue.assign(this.uninits);
            } else {
                this.scan(tree);
                if (!this.inits.isReset()) {
                    this.split(tree.type != ((Flow)Flow.this).syms.unknownType);
                }
            }
            if (tree.type != ((Flow)Flow.this).syms.unknownType) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            JCTree.JCClassDecl classDefPrev = this.classDef;
            int firstadrPrev = this.firstadr;
            int nextadrPrev = this.nextadr;
            ListBuffer pendingExitsPrev = this.pendingExits;
            this.pendingExits = new ListBuffer();
            if (tree.name != ((Flow)Flow.this).names.empty) {
                this.firstadr = this.nextadr;
            }
            this.classDef = tree;
            try {
                Symbol.VarSymbol sym;
                JCTree.JCVariableDecl def;
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.VARDEF)) {
                        def = (JCTree.JCVariableDecl)l.head;
                        if ((def.mods.flags & 8L) != 0L && this.trackable(sym = def.sym)) {
                            this.newVar(def);
                        }
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) != 0L) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.VARDEF)) {
                        def = (JCTree.JCVariableDecl)l.head;
                        if ((def.mods.flags & 8L) == 0L && this.trackable(sym = def.sym)) {
                            this.newVar(def);
                        }
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) == 0L) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.nextadr = nextadrPrev;
                this.firstadr = firstadrPrev;
                this.classDef = classDefPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            if ((tree.sym.flags() & 0x2000000001000L) == 4096L) {
                return;
            }
            Bits initsPrev = new Bits(this.inits);
            Bits uninitsPrev = new Bits(this.uninits);
            int nextadrPrev = this.nextadr;
            int firstadrPrev = this.firstadr;
            int returnadrPrev = this.returnadr;
            Assert.check(this.pendingExits.isEmpty());
            boolean lastInitialConstructor = this.isInitialConstructor;
            try {
                this.isInitialConstructor = TreeInfo.isInitialConstructor(tree);
                if (!this.isInitialConstructor) {
                    this.firstadr = this.nextadr;
                }
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    Assert.check((def.sym.flags() & 0x200000000L) != 0L, "Method parameter without PARAMETER flag");
                    this.initParam(def);
                    l = l.tail;
                }
                this.scan(tree.body);
                if (this.isInitialConstructor) {
                    boolean isSynthesized = (tree.sym.flags() & 0x1000000000L) != 0L;
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        JCTree.JCVariableDecl vardecl = this.vardecls[i];
                        Symbol.VarSymbol var = vardecl.sym;
                        if (var.owner != this.classDef.sym) continue;
                        if (isSynthesized) {
                            this.checkInit(TreeInfo.diagnosticPositionFor(var, vardecl), var, "var.not.initialized.in.default.constructor");
                            continue;
                        }
                        this.checkInit(TreeInfo.diagEndPos(tree.body), var);
                    }
                }
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    AbstractAssignPendingExit exit = (AbstractAssignPendingExit)exits.head;
                    exits = exits.tail;
                    Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN), exit.tree);
                    if (!this.isInitialConstructor) continue;
                    this.assignToInits(exit.tree, exit.exit_inits);
                    for (int i = this.firstadr; i < this.nextadr; ++i) {
                        this.checkInit(exit.tree.pos(), this.vardecls[i].sym);
                    }
                }
            }
            finally {
                this.assignToInits(tree, initsPrev);
                this.uninits.assign(uninitsPrev);
                this.nextadr = nextadrPrev;
                this.firstadr = firstadrPrev;
                this.returnadr = returnadrPrev;
                this.isInitialConstructor = lastInitialConstructor;
            }
        }

        protected void initParam(JCTree.JCVariableDecl def) {
            this.inits.incl(def.sym.adr);
            this.uninits.excl(def.sym.adr);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            boolean track = this.trackable(tree.sym);
            if (track && tree.sym.owner.kind == 16) {
                this.newVar(tree);
            }
            if (tree.init != null) {
                this.scanExpr(tree.init);
                if (track) {
                    this.letInit(tree.pos(), tree.sym);
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            int nextadrPrev = this.nextadr;
            this.scan(tree.stats);
            this.nextadr = nextadrPrev;
        }

        int getLogNumberOfErrors() {
            return 0;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = this.getLogNumberOfErrors();
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                this.scan(tree.body);
                this.resolveContinues(tree);
                this.scanCond(tree.cond);
                if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.initsWhenFalse);
                    uninitsSkip.assign(this.uninitsWhenFalse);
                }
                if (this.getLogNumberOfErrors() != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
                this.assignToInits(tree.cond, this.initsWhenTrue);
                this.uninits.assign(uninitsEntry.andSet(this.uninitsWhenTrue));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.assignToInits(tree, initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = this.getLogNumberOfErrors();
            Bits uninitsEntry = new Bits(this.uninits);
            uninitsEntry.excludeFrom(this.nextadr);
            while (true) {
                this.scanCond(tree.cond);
                if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.initsWhenFalse);
                    uninitsSkip.assign(this.uninitsWhenFalse);
                }
                this.assignToInits(tree, this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
                this.scan(tree.body);
                this.resolveContinues(tree);
                if (this.getLogNumberOfErrors() != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.assignToInits(tree.body, initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int nextadrPrev = this.nextadr;
            this.scan(tree.init);
            Bits initsSkip = new Bits(true);
            Bits uninitsSkip = new Bits(true);
            this.pendingExits = new ListBuffer();
            int prevErrors = this.getLogNumberOfErrors();
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                if (tree.cond != null) {
                    this.scanCond(tree.cond);
                    if (!this.flowKind.isFinal()) {
                        initsSkip.assign(this.initsWhenFalse);
                        uninitsSkip.assign(this.uninitsWhenFalse);
                    }
                    this.assignToInits(tree.body, this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                } else if (!this.flowKind.isFinal()) {
                    initsSkip.assign(this.inits);
                    initsSkip.inclRange(this.firstadr, this.nextadr);
                    uninitsSkip.assign(this.uninits);
                    uninitsSkip.inclRange(this.firstadr, this.nextadr);
                }
                this.scan(tree.body);
                this.resolveContinues(tree);
                this.scan(tree.step);
                if (this.getLogNumberOfErrors() != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.assignToInits(tree.body, initsSkip);
            this.uninits.assign(uninitsSkip);
            this.resolveBreaks(tree, prevPendingExits);
            this.nextadr = nextadrPrev;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            FlowKind prevFlowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int nextadrPrev = this.nextadr;
            this.scan(tree.expr);
            Bits initsStart = new Bits(this.inits);
            Bits uninitsStart = new Bits(this.uninits);
            this.letInit(tree.pos(), tree.var.sym);
            this.pendingExits = new ListBuffer();
            int prevErrors = this.getLogNumberOfErrors();
            while (true) {
                Bits uninitsEntry = new Bits(this.uninits);
                uninitsEntry.excludeFrom(this.nextadr);
                this.scan(tree.body);
                this.resolveContinues(tree);
                if (this.getLogNumberOfErrors() != prevErrors || this.flowKind.isFinal() || new Bits(uninitsEntry).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(uninitsEntry.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = prevFlowKind;
            this.assignToInits(tree.body, initsStart);
            this.uninits.assign(uninitsStart.andSet(this.uninits));
            this.resolveBreaks(tree, prevPendingExits);
            this.nextadr = nextadrPrev;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            int nextadrPrev = this.nextadr;
            this.scanExpr(tree.selector);
            Bits initsSwitch = new Bits(this.inits);
            Bits uninitsSwitch = new Bits(this.uninits);
            boolean hasDefault = false;
            List<JCTree.JCCase> l = tree.cases;
            while (l.nonEmpty()) {
                this.assignToInits((JCTree)l.head, initsSwitch);
                this.uninits.assign(this.uninits.andSet(uninitsSwitch));
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                if (c.pat == null) {
                    hasDefault = true;
                } else {
                    this.scanExpr(c.pat);
                }
                if (hasDefault) {
                    this.assignToInits(null, initsSwitch);
                    this.uninits.assign(this.uninits.andSet(uninitsSwitch));
                }
                this.scan(c.stats);
                this.addVars(c.stats, initsSwitch, uninitsSwitch);
                if (!hasDefault) {
                    this.assignToInits(((JCTree.JCCase)l.head).stats.last(), initsSwitch);
                    this.uninits.assign(this.uninits.andSet(uninitsSwitch));
                }
                l = l.tail;
            }
            if (!hasDefault) {
                this.andSetInits(null, initsSwitch);
            }
            this.resolveBreaks(tree, prevPendingExits);
            this.nextadr = nextadrPrev;
        }

        private void addVars(List<JCTree.JCStatement> stats, Bits inits, Bits uninits) {
            while (stats.nonEmpty()) {
                JCTree stat = (JCTree)stats.head;
                if (stat.hasTag(JCTree.Tag.VARDEF)) {
                    int adr = ((JCTree.JCVariableDecl)stat).sym.adr;
                    inits.excl(adr);
                    uninits.incl(adr);
                }
                stats = stats.tail;
            }
        }

        boolean isEnabled(Lint.LintCategory lc) {
            return false;
        }

        void reportWarning(Lint.LintCategory lc, JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            ListBuffer exits;
            ListBuffer<JCTree.JCVariableDecl> resourceVarDecls = new ListBuffer<JCTree.JCVariableDecl>();
            Bits uninitsTryPrev = new Bits(this.uninitsTry);
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            Bits initsTry = new Bits(this.inits);
            this.uninitsTry.assign(this.uninits);
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl vdecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(vdecl);
                    this.unrefdResources.enter(vdecl.sym);
                    resourceVarDecls.append(vdecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    this.scanExpr((JCTree.JCExpression)resource);
                    continue;
                }
                throw new AssertionError(tree);
            }
            this.scan(tree.body);
            this.uninitsTry.andSet(this.uninits);
            Bits initsEnd = new Bits(this.inits);
            Bits uninitsEnd = new Bits(this.uninits);
            int nextadrCatch = this.nextadr;
            if (!resourceVarDecls.isEmpty() && this.isEnabled(Lint.LintCategory.TRY)) {
                for (JCTree.JCVariableDecl resVar : resourceVarDecls) {
                    if (!this.unrefdResources.includes(resVar.sym)) continue;
                    this.reportWarning(Lint.LintCategory.TRY, resVar.pos(), "try.resource.not.referenced", resVar.sym);
                    this.unrefdResources.remove(resVar.sym);
                }
            }
            Bits initsCatchPrev = new Bits(initsTry);
            Bits uninitsCatchPrev = new Bits(this.uninitsTry);
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l.head).param;
                this.assignToInits(tree.body, initsCatchPrev);
                this.uninits.assign(uninitsCatchPrev);
                this.scan(param);
                this.initParam(param);
                this.scan(((JCTree.JCCatch)l.head).body);
                initsEnd.andSet(this.inits);
                uninitsEnd.andSet(this.uninits);
                this.nextadr = nextadrCatch;
                l = l.tail;
            }
            if (tree.finalizer != null) {
                this.assignToInits(tree.finalizer, initsTry);
                this.uninits.assign(this.uninitsTry);
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.scan(tree.finalizer);
                if (tree.finallyCanCompleteNormally) {
                    this.uninits.andSet(uninitsEnd);
                    while (exits.nonEmpty()) {
                        AbstractAssignPendingExit exit = (AbstractAssignPendingExit)exits.next();
                        if (exit.exit_inits != null) {
                            exit.exit_inits.orSet(this.inits);
                            exit.exit_uninits.andSet(this.uninits);
                        }
                        this.pendingExits.append(exit);
                    }
                    this.orSetInits(tree, initsEnd);
                }
            } else {
                this.assignToInits(tree, initsEnd);
                this.uninits.assign(uninitsEnd);
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append(exits.next());
                }
            }
            this.uninitsTry.andSet(uninitsTryPrev).andSet(this.uninits);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            this.scanCond(tree.cond);
            Bits initsBeforeElse = new Bits(this.initsWhenFalse);
            Bits uninitsBeforeElse = new Bits(this.uninitsWhenFalse);
            this.assignToInits(tree.cond, this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            if (tree.truepart.type.hasTag(TypeTag.BOOLEAN) && tree.falsepart.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(tree.truepart);
                Bits initsAfterThenWhenTrue = new Bits(this.initsWhenTrue);
                Bits initsAfterThenWhenFalse = new Bits(this.initsWhenFalse);
                Bits uninitsAfterThenWhenTrue = new Bits(this.uninitsWhenTrue);
                Bits uninitsAfterThenWhenFalse = new Bits(this.uninitsWhenFalse);
                this.assignToInits(tree.truepart, initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scanCond(tree.falsepart);
                this.initsWhenTrue.andSet(initsAfterThenWhenTrue);
                this.initsWhenFalse.andSet(initsAfterThenWhenFalse);
                this.uninitsWhenTrue.andSet(uninitsAfterThenWhenTrue);
                this.uninitsWhenFalse.andSet(uninitsAfterThenWhenFalse);
            } else {
                this.scanExpr(tree.truepart);
                Bits initsAfterThen = new Bits(this.inits);
                Bits uninitsAfterThen = new Bits(this.uninits);
                this.assignToInits(tree.truepart, initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scanExpr(tree.falsepart);
                this.andSetInits(tree.falsepart, initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scanCond(tree.cond);
            Bits initsBeforeElse = new Bits(this.initsWhenFalse);
            Bits uninitsBeforeElse = new Bits(this.uninitsWhenFalse);
            this.assignToInits(tree.cond, this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            this.scan(tree.thenpart);
            if (tree.elsepart != null) {
                Bits initsAfterThen = new Bits(this.inits);
                Bits uninitsAfterThen = new Bits(this.uninits);
                this.assignToInits(tree.thenpart, initsBeforeElse);
                this.uninits.assign(uninitsBeforeElse);
                this.scan(tree.elsepart);
                this.andSetInits(tree.elsepart, initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
            } else {
                this.andSetInits(tree.thenpart, initsBeforeElse);
                this.uninits.andSet(uninitsBeforeElse);
            }
        }

        protected P createNewPendingExit(JCTree tree, Bits inits, Bits uninits) {
            return null;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(tree, this.createNewPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(tree, this.createNewPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scanExpr(tree.expr);
            this.recordExit(tree, this.createNewPendingExit(tree, this.inits, this.uninits));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scanExpr(tree.expr);
            this.markDead(tree.expr);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scanExpr(tree.meth);
            this.scanExprs(tree.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scanExpr(tree.encl);
            this.scanExprs(tree.args);
            this.scan(tree.def);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            Bits prevUninits = new Bits(this.uninits);
            Bits prevInits = new Bits(this.inits);
            int returnadrPrev = this.returnadr;
            ListBuffer prevPending = this.pendingExits;
            try {
                this.returnadr = this.nextadr;
                this.pendingExits = new ListBuffer();
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    this.inits.incl(def.sym.adr);
                    this.uninits.excl(def.sym.adr);
                    l = l.tail;
                }
                if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    this.scanExpr(tree.body);
                } else {
                    this.scan(tree.body);
                }
            }
            finally {
                this.returnadr = returnadrPrev;
                this.uninits.assign(prevUninits);
                this.assignToInits(tree, prevInits);
                this.pendingExits = prevPending;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.scanExprs(tree.dims);
            this.scanExprs(tree.elems);
        }

        @Override
        public void visitAssert(JCTree.JCAssert tree) {
            Bits initsExit = new Bits(this.inits);
            Bits uninitsExit = new Bits(this.uninits);
            this.scanCond(tree.cond);
            uninitsExit.andSet(this.uninitsWhenTrue);
            if (tree.detail != null) {
                this.assignToInits(tree, this.initsWhenFalse);
                this.uninits.assign(this.uninitsWhenFalse);
                this.scanExpr(tree.detail);
            }
            this.assignToInits(tree, initsExit);
            this.uninits.assign(uninitsExit);
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            JCTree.JCExpression lhs = TreeInfo.skipParens(tree.lhs);
            if (!this.isIdentOrThisDotIdent(lhs)) {
                this.scanExpr(lhs);
            }
            this.scanExpr(tree.rhs);
            this.letInit(lhs);
        }

        private boolean isIdentOrThisDotIdent(JCTree lhs) {
            if (lhs.hasTag(JCTree.Tag.IDENT)) {
                return true;
            }
            if (!lhs.hasTag(JCTree.Tag.SELECT)) {
                return false;
            }
            JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)lhs;
            return fa.selected.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)fa.selected).name == ((Flow)Flow.this).names._this;
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            if (Flow.this.enforceThisDotInit && tree.selected.hasTag(JCTree.Tag.IDENT) && ((JCTree.JCIdent)tree.selected).name == ((Flow)Flow.this).names._this && tree.sym.kind == 4) {
                this.checkInit(tree.pos(), (Symbol.VarSymbol)tree.sym);
            }
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            this.scanExpr(tree.lhs);
            this.scanExpr(tree.rhs);
            this.letInit(tree.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            switch (tree.getTag()) {
                case NOT: {
                    this.scanCond(tree.arg);
                    Bits t = new Bits(this.initsWhenFalse);
                    this.initsWhenFalse.assign(this.initsWhenTrue);
                    this.initsWhenTrue.assign(t);
                    t.assign(this.uninitsWhenFalse);
                    this.uninitsWhenFalse.assign(this.uninitsWhenTrue);
                    this.uninitsWhenTrue.assign(t);
                    break;
                }
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scanExpr(tree.arg);
                    this.letInit(tree.arg);
                    break;
                }
                default: {
                    this.scanExpr(tree.arg);
                }
            }
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            switch (tree.getTag()) {
                case AND: {
                    this.scanCond(tree.lhs);
                    Bits initsWhenFalseLeft = new Bits(this.initsWhenFalse);
                    Bits uninitsWhenFalseLeft = new Bits(this.uninitsWhenFalse);
                    this.assignToInits(tree.lhs, this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                    this.scanCond(tree.rhs);
                    this.initsWhenFalse.andSet(initsWhenFalseLeft);
                    this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                    break;
                }
                case OR: {
                    this.scanCond(tree.lhs);
                    Bits initsWhenTrueLeft = new Bits(this.initsWhenTrue);
                    Bits uninitsWhenTrueLeft = new Bits(this.uninitsWhenTrue);
                    this.assignToInits(tree.lhs, this.initsWhenFalse);
                    this.uninits.assign(this.uninitsWhenFalse);
                    this.scanCond(tree.rhs);
                    this.initsWhenTrue.andSet(initsWhenTrueLeft);
                    this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                    break;
                }
                default: {
                    this.scanExpr(tree.lhs);
                    this.scanExpr(tree.rhs);
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (tree.sym.kind == 4) {
                this.checkInit(tree.pos(), (Symbol.VarSymbol)tree.sym);
                this.referenced(tree.sym);
            }
        }

        void referenced(Symbol sym) {
            this.unrefdResources.remove(sym);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            tree.underlyingType.accept(this);
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        }

        public void analyzeTree(Env<?> env) {
            this.analyzeTree(env, env.tree);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<?> env, JCTree tree) {
            int i;
            try {
                this.startPos = tree.pos().getStartPosition();
                if (this.vardecls == null) {
                    this.vardecls = new JCTree.JCVariableDecl[32];
                } else {
                    for (i = 0; i < this.vardecls.length; ++i) {
                        this.vardecls[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = new ListBuffer();
                this.classDef = null;
                this.unrefdResources = new Scope(env.enclClass.sym);
                this.scan(tree);
                this.startPos = -1;
            }
            catch (Throwable throwable) {
                this.startPos = -1;
                this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
                if (this.vardecls != null) {
                    for (int i2 = 0; i2 < this.vardecls.length; ++i2) {
                        this.vardecls[i2] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                this.pendingExits = null;
                this.classDef = null;
                this.unrefdResources = null;
                throw throwable;
            }
            this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
            if (this.vardecls != null) {
                for (i = 0; i < this.vardecls.length; ++i) {
                    this.vardecls[i] = null;
                }
            }
            this.firstadr = 0;
            this.nextadr = 0;
            this.pendingExits = null;
            this.classDef = null;
            this.unrefdResources = null;
        }

        public class AbstractAssignPendingExit
        extends BaseAnalyzer.PendingExit {
            final Bits inits;
            final Bits uninits;
            final Bits exit_inits;
            final Bits exit_uninits;

            public AbstractAssignPendingExit(JCTree tree, Bits inits, Bits uninits) {
                super(tree);
                this.exit_inits = new Bits(true);
                this.exit_uninits = new Bits(true);
                this.inits = inits;
                this.uninits = uninits;
                this.exit_inits.assign(inits);
                this.exit_uninits.assign(uninits);
            }

            @Override
            public void resolveJump(JCTree tree) {
                this.inits.andSet(this.exit_inits);
                this.uninits.andSet(this.exit_uninits);
            }
        }
    }

    class LambdaFlowAnalyzer
    extends FlowAnalyzer {
        List<Type> inferredThrownTypes;
        boolean inLambda;

        LambdaFlowAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous() || this.inLambda) {
                return;
            }
            List prevCaught = this.caught;
            List prevThrown = this.thrown;
            ListBuffer prevPending = this.pendingExits;
            this.inLambda = true;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = List.of(((Flow)Flow.this).syms.throwableType);
                this.thrown = List.nil();
                this.scan(tree.body);
                this.inferredThrownTypes = this.thrown;
            }
            finally {
                this.pendingExits = prevPending;
                this.caught = prevCaught;
                this.thrown = prevThrown;
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
        }
    }

    class FlowAnalyzer
    extends BaseAnalyzer<FlowPendingExit> {
        HashMap<Symbol, List<Type>> preciseRethrowTypes;
        JCTree.JCClassDecl classDef;
        List<Type> thrown;
        List<Type> caught;

        FlowAnalyzer() {
        }

        @Override
        void markDead(JCTree tree) {
        }

        void errorUncaught() {
            FlowPendingExit exit = (FlowPendingExit)this.pendingExits.next();
            while (exit != null) {
                if (this.classDef != null && this.classDef.pos == exit.tree.pos) {
                    Flow.this.log.error(exit.tree.pos(), "unreported.exception.default.constructor", exit.thrown);
                } else if (exit.tree.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)exit.tree).sym.isResourceVariable()) {
                    Flow.this.log.error(exit.tree.pos(), "unreported.exception.implicit.close", exit.thrown, ((JCTree.JCVariableDecl)exit.tree).sym.name);
                } else {
                    Flow.this.log.error(exit.tree.pos(), "unreported.exception.need.to.catch.or.throw", exit.thrown);
                }
                exit = (FlowPendingExit)this.pendingExits.next();
            }
        }

        void markThrown(JCTree tree, Type exc) {
            if (!Flow.this.chk.isUnchecked(tree.pos(), exc)) {
                if (!Flow.this.chk.isHandled(exc, this.caught)) {
                    this.pendingExits.append(new FlowPendingExit(tree, exc));
                }
                this.thrown = Flow.this.chk.incl(exc, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            JCTree.JCClassDecl classDefPrev = this.classDef;
            List<Type> thrownPrev = this.thrown;
            List<Type> caughtPrev = this.caught;
            ListBuffer pendingExitsPrev = this.pendingExits;
            Lint lintPrev = Flow.this.lint;
            this.pendingExits = new ListBuffer();
            if (tree.name != ((Flow)Flow.this).names.empty) {
                this.caught = List.nil();
            }
            this.classDef = tree;
            this.thrown = List.nil();
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            try {
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) != 0L) {
                        this.scan((JCTree)l.head);
                        this.errorUncaught();
                    }
                    l = l.tail;
                }
                if (tree.name != ((Flow)Flow.this).names.empty) {
                    boolean firstConstructor = true;
                    List<JCTree> l2 = tree.defs;
                    while (l2.nonEmpty()) {
                        if (TreeInfo.isInitialConstructor((JCTree)l2.head)) {
                            List<Type> mthrown = ((JCTree.JCMethodDecl)l2.head).sym.type.getThrownTypes();
                            if (firstConstructor) {
                                this.caught = mthrown;
                                firstConstructor = false;
                            } else {
                                this.caught = Flow.this.chk.intersect(mthrown, this.caught);
                            }
                        }
                        l2 = l2.tail;
                    }
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) == 0L) {
                        this.scan((JCTree)l.head);
                        this.errorUncaught();
                    }
                    l = l.tail;
                }
                if (tree.name == ((Flow)Flow.this).names.empty) {
                    l = tree.defs;
                    while (l.nonEmpty()) {
                        if (TreeInfo.isInitialConstructor((JCTree)l.head)) {
                            JCTree.JCMethodDecl mdef = (JCTree.JCMethodDecl)l.head;
                            mdef.thrown = Flow.this.make.Types(this.thrown);
                            mdef.sym.type = Flow.this.types.createMethodTypeWithThrown(mdef.sym.type, this.thrown);
                        }
                        l = l.tail;
                    }
                    thrownPrev = Flow.this.chk.union(this.thrown, thrownPrev);
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)l.head);
                        this.errorUncaught();
                    }
                    l = l.tail;
                }
                this.thrown = thrownPrev;
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.caught = caughtPrev;
                this.classDef = classDefPrev;
                Flow.this.lint = lintPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            List<Type> caughtPrev = this.caught;
            List<Type> mthrown = tree.sym.type.getThrownTypes();
            Lint lintPrev = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                List<JCTree.JCVariableDecl> l = tree.params;
                while (l.nonEmpty()) {
                    JCTree.JCVariableDecl def = (JCTree.JCVariableDecl)l.head;
                    this.scan(def);
                    l = l.tail;
                }
                if (TreeInfo.isInitialConstructor(tree)) {
                    this.caught = Flow.this.chk.union(this.caught, mthrown);
                } else if ((tree.sym.flags() & 0x100008L) != 0x100000L) {
                    this.caught = mthrown;
                }
                this.scan(tree.body);
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    FlowPendingExit exit = (FlowPendingExit)exits.head;
                    exits = exits.tail;
                    if (exit.thrown == null) {
                        Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN));
                        continue;
                    }
                    this.pendingExits.append(exit);
                }
            }
            finally {
                this.caught = caughtPrev;
                Flow.this.lint = lintPrev;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (tree.init != null) {
                Lint lintPrev = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(tree.sym);
                try {
                    this.scan(tree.init);
                }
                finally {
                    Flow.this.lint = lintPrev;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            this.scan(tree.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.scan(tree.cond);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.cond);
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.init);
            this.pendingExits = new ListBuffer();
            if (tree.cond != null) {
                this.scan(tree.cond);
            }
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.scan(tree.step);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.expr);
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveContinues(tree);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.body);
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.selector);
            List<JCTree.JCCase> l = tree.cases;
            while (l.nonEmpty()) {
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                if (c.pat != null) {
                    this.scan(c.pat);
                }
                this.scan(c.stats);
                l = l.tail;
            }
            this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            List<Type> caughtPrev = this.caught;
            List<Type> thrownPrev = this.thrown;
            this.thrown = List.nil();
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                Iterator<JCTree> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)l.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)l.head).param.vartype);
                Iterator iterator = ((List)((Object)subClauses)).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression ct = (JCTree.JCExpression)iterator.next();
                    this.caught = Flow.this.chk.incl(ct.type, this.caught);
                }
                l = l.tail;
            }
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl vdecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(vdecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    this.scan((JCTree.JCExpression)resource);
                    continue;
                }
                throw new AssertionError(tree);
            }
            for (JCTree resource : tree.resources) {
                List<Type> closeableSupertypes = resource.type.isCompound() ? Flow.this.types.interfaces(resource.type).prepend(Flow.this.types.supertype(resource.type)) : List.of(resource.type);
                for (Type sup : closeableSupertypes) {
                    if (Flow.this.types.asSuper(sup, ((Flow)Flow.this).syms.autoCloseableType.tsym) == null) continue;
                    Symbol closeMethod = Flow.this.rs.resolveQualifiedMethod(tree, Flow.this.attrEnv, sup, ((Flow)Flow.this).names.close, List.nil(), List.nil());
                    Type mt = Flow.this.types.memberType(resource.type, closeMethod);
                    if (closeMethod.kind != 16) continue;
                    for (Type t : mt.getThrownTypes()) {
                        this.markThrown(resource, t);
                    }
                }
            }
            this.scan(tree.body);
            List<Type> thrownInTry = Flow.this.allowImprovedCatchAnalysis ? Flow.this.chk.union(this.thrown, List.of(((Flow)Flow.this).syms.runtimeExceptionType, ((Flow)Flow.this).syms.errorType)) : this.thrown;
            this.thrown = thrownPrev;
            this.caught = caughtPrev;
            List<Type> caughtInTry = List.nil();
            List<JCTree.JCCatch> l2 = tree.catchers;
            while (l2.nonEmpty()) {
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l2.head).param;
                List<JCTree.JCExpression> subClauses = TreeInfo.isMultiCatch((JCTree.JCCatch)l2.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)l2.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)l2.head).param.vartype);
                List<Type> ctypes = List.nil();
                List<Type> rethrownTypes = Flow.this.chk.diff(thrownInTry, caughtInTry);
                for (JCTree.JCExpression ct : subClauses) {
                    Type exc = ct.type;
                    if (exc == ((Flow)Flow.this).syms.unknownType) continue;
                    ctypes = ctypes.append(exc);
                    if (Flow.this.types.isSameType(exc, ((Flow)Flow.this).syms.objectType)) continue;
                    this.checkCaughtType(((JCTree.JCCatch)l2.head).pos(), exc, thrownInTry, caughtInTry);
                    caughtInTry = Flow.this.chk.incl(exc, caughtInTry);
                }
                this.scan(param);
                this.preciseRethrowTypes.put(param.sym, Flow.this.chk.intersect(ctypes, rethrownTypes));
                this.scan(((JCTree.JCCatch)l2.head).body);
                this.preciseRethrowTypes.remove(param.sym);
                l2 = l2.tail;
            }
            if (tree.finalizer != null) {
                List<Type> savedThrown = this.thrown;
                this.thrown = List.nil();
                ListBuffer exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.scan(tree.finalizer);
                if (!tree.finallyCanCompleteNormally) {
                    this.thrown = Flow.this.chk.union(this.thrown, thrownPrev);
                } else {
                    this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff(thrownInTry, caughtInTry));
                    this.thrown = Flow.this.chk.union(this.thrown, savedThrown);
                    while (exits.nonEmpty()) {
                        this.pendingExits.append(exits.next());
                    }
                }
            } else {
                this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff(thrownInTry, caughtInTry));
                ListBuffer exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append(exits.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.cond);
            this.scan(tree.thenpart);
            if (tree.elsepart != null) {
                this.scan(tree.elsepart);
            }
        }

        void checkCaughtType(JCDiagnostic.DiagnosticPosition pos, Type exc, List<Type> thrownInTry, List<Type> caughtInTry) {
            if (Flow.this.chk.subset(exc, caughtInTry)) {
                Flow.this.log.error(pos, "except.already.caught", exc);
            } else if (!(Flow.this.chk.isUnchecked(pos, exc) || this.isExceptionOrThrowable(exc) || Flow.this.chk.intersects(exc, thrownInTry))) {
                Flow.this.log.error(pos, "except.never.thrown.in.try", exc);
            } else if (Flow.this.allowImprovedCatchAnalysis) {
                List<Type> catchableThrownTypes = Flow.this.chk.intersect(List.of(exc), thrownInTry);
                if (Flow.this.chk.diff(catchableThrownTypes, caughtInTry).isEmpty() && !this.isExceptionOrThrowable(exc)) {
                    String key = catchableThrownTypes.length() == 1 ? "unreachable.catch" : "unreachable.catch.1";
                    Flow.this.log.warning(pos, key, catchableThrownTypes);
                }
            }
        }

        private boolean isExceptionOrThrowable(Type exc) {
            return exc.tsym == ((Flow)Flow.this).syms.throwableType.tsym || exc.tsym == ((Flow)Flow.this).syms.exceptionType.tsym;
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(tree, new FlowPendingExit(tree, null));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(tree, new FlowPendingExit(tree, null));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scan(tree.expr);
            this.recordExit(tree, new FlowPendingExit(tree, null));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scan(tree.expr);
            Symbol sym = TreeInfo.symbol(tree.expr);
            if (sym != null && sym.kind == 4 && (sym.flags() & 0x20000000010L) != 0L && this.preciseRethrowTypes.get(sym) != null && Flow.this.allowImprovedRethrowAnalysis) {
                for (Type t : this.preciseRethrowTypes.get(sym)) {
                    this.markThrown(tree, t);
                }
            } else {
                this.markThrown(tree, tree.expr.type);
            }
            this.markDead(tree);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.args);
            List<Type> l = tree.meth.type.getThrownTypes();
            while (l.nonEmpty()) {
                this.markThrown(tree, (Type)l.head);
                l = l.tail;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scan(tree.encl);
            this.scan(tree.args);
            List<Type> l = tree.constructorType.getThrownTypes();
            while (l.nonEmpty()) {
                this.markThrown(tree, (Type)l.head);
                l = l.tail;
            }
            List<Type> caughtPrev = this.caught;
            try {
                if (tree.def != null) {
                    List<Type> l2 = tree.constructor.type.getThrownTypes();
                    while (l2.nonEmpty()) {
                        this.caught = Flow.this.chk.incl((Type)l2.head, this.caught);
                        l2 = l2.tail;
                    }
                }
                this.scan(tree.def);
            }
            finally {
                this.caught = caughtPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous()) {
                return;
            }
            List<Type> prevCaught = this.caught;
            List<Type> prevThrown = this.thrown;
            ListBuffer prevPending = this.pendingExits;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = tree.getDescriptorType(Flow.this.types).getThrownTypes();
                this.thrown = List.nil();
                this.scan(tree.body);
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    FlowPendingExit exit = (FlowPendingExit)exits.head;
                    exits = exits.tail;
                    if (exit.thrown == null) {
                        Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN));
                        continue;
                    }
                    this.pendingExits.append(exit);
                }
                this.errorUncaught();
            }
            finally {
                this.pendingExits = prevPending;
                this.caught = prevCaught;
                this.thrown = prevThrown;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.preciseRethrowTypes = new HashMap();
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
            }
        }

        class FlowPendingExit
        extends BaseAnalyzer.PendingExit {
            Type thrown;

            FlowPendingExit(JCTree tree, Type thrown) {
                super(tree);
                this.thrown = thrown;
            }
        }
    }

    class AliveAnalyzer
    extends BaseAnalyzer<BaseAnalyzer.PendingExit> {
        private boolean alive;

        AliveAnalyzer() {
        }

        @Override
        void markDead(JCTree tree) {
            this.alive = false;
        }

        void scanDef(JCTree tree) {
            this.scanStat(tree);
            if (tree != null && tree.hasTag(JCTree.Tag.BLOCK) && !this.alive) {
                Flow.this.log.error(tree.pos(), "initializer.must.be.able.to.complete.normally", new Object[0]);
            }
        }

        void scanStat(JCTree tree) {
            if (!this.alive && tree != null) {
                Flow.this.log.error(tree.pos(), "unreachable.stmt", new Object[0]);
                if (!tree.hasTag(JCTree.Tag.SKIP)) {
                    this.alive = true;
                }
            }
            this.scan(tree);
        }

        void scanStats(List<? extends JCTree.JCStatement> trees) {
            if (trees != null) {
                List<JCTree.JCStatement> l = trees;
                while (l.nonEmpty()) {
                    this.scanStat((JCTree)l.head);
                    l = l.tail;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            if (tree.sym == null) {
                return;
            }
            boolean alivePrev = this.alive;
            ListBuffer pendingExitsPrev = this.pendingExits;
            Lint lintPrev = Flow.this.lint;
            this.pendingExits = new ListBuffer();
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            try {
                List<JCTree> l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) != 0L) {
                        this.scanDef((JCTree)l.head);
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (!((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)l.head) & 8L) == 0L) {
                        this.scanDef((JCTree)l.head);
                    }
                    l = l.tail;
                }
                l = tree.defs;
                while (l.nonEmpty()) {
                    if (((JCTree)l.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)l.head);
                    }
                    l = l.tail;
                }
            }
            finally {
                this.pendingExits = pendingExitsPrev;
                this.alive = alivePrev;
                Flow.this.lint = lintPrev;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            if (tree.body == null) {
                return;
            }
            Lint lintPrev = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(tree.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                this.alive = true;
                this.scanStat(tree.body);
                if (this.alive && !tree.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    Flow.this.log.error(TreeInfo.diagEndPos(tree.body), "missing.ret.stmt", new Object[0]);
                }
                List exits = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (exits.nonEmpty()) {
                    BaseAnalyzer.PendingExit exit = (BaseAnalyzer.PendingExit)exits.head;
                    exits = exits.tail;
                    Assert.check(exit.tree.hasTag(JCTree.Tag.RETURN));
                }
            }
            finally {
                Flow.this.lint = lintPrev;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            if (tree.init != null) {
                Lint lintPrev = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(tree.sym);
                try {
                    this.scan(tree.init);
                }
                finally {
                    Flow.this.lint = lintPrev;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            this.scanStats(tree.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scan(tree.cond);
            this.alive = this.alive && !tree.cond.type.isTrue();
            this.alive |= this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.cond);
            this.alive = !tree.cond.type.isFalse();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.alive = this.resolveBreaks(tree, prevPendingExits) || !tree.cond.type.isTrue();
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.scanStats(tree.init);
            this.pendingExits = new ListBuffer();
            if (tree.cond != null) {
                this.scan(tree.cond);
                this.alive = !tree.cond.type.isFalse();
            } else {
                this.alive = true;
            }
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.scan(tree.step);
            this.alive = this.resolveBreaks(tree, prevPendingExits) || tree.cond != null && !tree.cond.type.isTrue();
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.visitVarDef(tree.var);
            ListBuffer prevPendingExits = this.pendingExits;
            this.scan(tree.expr);
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive |= this.resolveContinues(tree);
            this.resolveBreaks(tree, prevPendingExits);
            this.alive = true;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(tree.body);
            this.alive |= this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(tree.selector);
            boolean hasDefault = false;
            List<JCTree.JCCase> l = tree.cases;
            while (l.nonEmpty()) {
                this.alive = true;
                JCTree.JCCase c = (JCTree.JCCase)l.head;
                if (c.pat == null) {
                    hasDefault = true;
                } else {
                    this.scan(c.pat);
                }
                this.scanStats(c.stats);
                if (this.alive && Flow.this.lint.isEnabled(Lint.LintCategory.FALLTHROUGH) && c.stats.nonEmpty() && l.tail.nonEmpty()) {
                    Flow.this.log.warning(Lint.LintCategory.FALLTHROUGH, ((JCTree.JCCase)l.tail.head).pos(), "possible.fall-through.into.case", new Object[0]);
                }
                l = l.tail;
            }
            if (!hasDefault) {
                this.alive = true;
            }
            this.alive |= this.resolveBreaks(tree, prevPendingExits);
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            ListBuffer exits;
            ListBuffer prevPendingExits = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree resource : tree.resources) {
                if (resource instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl vdecl = (JCTree.JCVariableDecl)resource;
                    this.visitVarDef(vdecl);
                    continue;
                }
                if (resource instanceof JCTree.JCExpression) {
                    this.scan((JCTree.JCExpression)resource);
                    continue;
                }
                throw new AssertionError(tree);
            }
            this.scanStat(tree.body);
            boolean aliveEnd = this.alive;
            List<JCTree.JCCatch> l = tree.catchers;
            while (l.nonEmpty()) {
                this.alive = true;
                JCTree.JCVariableDecl param = ((JCTree.JCCatch)l.head).param;
                this.scan(param);
                this.scanStat(((JCTree.JCCatch)l.head).body);
                aliveEnd |= this.alive;
                l = l.tail;
            }
            if (tree.finalizer != null) {
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                this.alive = true;
                this.scanStat(tree.finalizer);
                tree.finallyCanCompleteNormally = this.alive;
                if (!this.alive) {
                    if (Flow.this.lint.isEnabled(Lint.LintCategory.FINALLY)) {
                        Flow.this.log.warning(Lint.LintCategory.FINALLY, TreeInfo.diagEndPos(tree.finalizer), "finally.cannot.complete", new Object[0]);
                    }
                } else {
                    while (exits.nonEmpty()) {
                        this.pendingExits.append(exits.next());
                    }
                    this.alive = aliveEnd;
                }
            } else {
                this.alive = aliveEnd;
                exits = this.pendingExits;
                this.pendingExits = prevPendingExits;
                while (exits.nonEmpty()) {
                    this.pendingExits.append(exits.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.scan(tree.cond);
            this.scanStat(tree.thenpart);
            if (tree.elsepart != null) {
                boolean aliveAfterThen = this.alive;
                this.alive = true;
                this.scanStat(tree.elsepart);
                this.alive |= aliveAfterThen;
            } else {
                this.alive = true;
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.recordExit(tree, new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.recordExit(tree, new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.scan(tree.expr);
            this.recordExit(tree, new BaseAnalyzer.PendingExit(tree));
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.scan(tree.expr);
            this.markDead(tree);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.scan(tree.meth);
            this.scan(tree.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.scan(tree.encl);
            this.scan(tree.args);
            if (tree.def != null) {
                this.scan(tree.def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (tree.type != null && tree.type.isErroneous()) {
                return;
            }
            ListBuffer prevPending = this.pendingExits;
            boolean prevAlive = this.alive;
            try {
                this.pendingExits = new ListBuffer();
                this.alive = true;
                this.scanStat(tree.body);
                tree.canCompleteNormally = this.alive;
            }
            finally {
                this.pendingExits = prevPending;
                this.alive = prevAlive;
            }
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker make) {
            this.analyzeTree(env, env.tree, make);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree tree, TreeMaker make) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = make;
                this.pendingExits = new ListBuffer();
                this.alive = true;
                this.scan(tree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    static abstract class BaseAnalyzer<P extends PendingExit>
    extends TreeScanner {
        ListBuffer<P> pendingExits;

        BaseAnalyzer() {
        }

        abstract void markDead(JCTree var1);

        void recordExit(JCTree tree, P pe) {
            this.pendingExits.append(pe);
            this.markDead(tree);
        }

        private boolean resolveJump(JCTree tree, ListBuffer<P> oldPendingExits, JumpKind jk) {
            boolean resolved = false;
            List<Object> exits = this.pendingExits.toList();
            this.pendingExits = oldPendingExits;
            while (exits.nonEmpty()) {
                PendingExit exit = (PendingExit)exits.head;
                if (exit.tree.hasTag(jk.treeTag) && jk.getTarget(exit.tree) == tree) {
                    exit.resolveJump(tree);
                    resolved = true;
                } else {
                    this.pendingExits.append(exit);
                }
                exits = exits.tail;
            }
            return resolved;
        }

        boolean resolveContinues(JCTree tree) {
            return this.resolveJump(tree, new ListBuffer(), JumpKind.CONTINUE);
        }

        boolean resolveBreaks(JCTree tree, ListBuffer<P> oldPendingExits) {
            return this.resolveJump(tree, oldPendingExits, JumpKind.BREAK);
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null && (tree.type == null || tree.type != Type.stuckType)) {
                super.scan(tree);
            }
        }

        static class PendingExit {
            JCTree tree;

            PendingExit(JCTree tree) {
                this.tree = tree;
            }

            void resolveJump(JCTree tree) {
            }
        }

        static enum JumpKind {
            BREAK(JCTree.Tag.BREAK){

                @Override
                JCTree getTarget(JCTree tree) {
                    return ((JCTree.JCBreak)tree).target;
                }
            }
            ,
            CONTINUE(JCTree.Tag.CONTINUE){

                @Override
                JCTree getTarget(JCTree tree) {
                    return ((JCTree.JCContinue)tree).target;
                }
            };

            final JCTree.Tag treeTag;

            private JumpKind(JCTree.Tag treeTag) {
                this.treeTag = treeTag;
            }

            abstract JCTree getTarget(JCTree var1);
        }
    }

    static enum FlowKind {
        NORMAL("var.might.already.be.assigned", false),
        SPECULATIVE_LOOP("var.might.be.assigned.in.loop", true);

        final String errKey;
        final boolean isFinal;

        private FlowKind(String errKey, boolean isFinal) {
            this.errKey = errKey;
            this.isFinal = isFinal;
        }

        boolean isFinal() {
            return this.isFinal;
        }
    }
}

