/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ElementValueGen;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class ElementValuePairGen {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int nameIdx;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen value;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool;

    public ElementValuePairGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValuePair nvp, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool, @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean copyPoolEntries) {
        this.cpool = cpool;
        this.nameIdx = copyPoolEntries ? cpool.addUtf8(nvp.getNameString()) : nvp.getNameIndex();
        this.value = ElementValueGen.copy(nvp.getValue(), cpool, copyPoolEntries);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValuePair getElementNameValuePair() {
        ElementValue immutableValue = this.value.getElementValue();
        return new ElementValuePair(this.nameIdx, immutableValue, this.cpool.getConstantPool());
    }

    protected ElementValuePairGen(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int idx, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        this.nameIdx = idx;
        this.value = value;
        this.cpool = cpool;
    }

    public ElementValuePairGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen value, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPoolGen cpool) {
        this.nameIdx = cpool.addUtf8(name);
        this.value = value;
        this.cpool = cpool;
    }

    protected void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        dos.writeShort(this.nameIdx);
        this.value.dump(dos);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.nameIdx;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String getNameString() {
        return ((ConstantUtf8)this.cpool.getConstant(this.nameIdx)).getBytes();
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ElementValueGen getValue() {
        return this.value;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown String toString() {
        return "ElementValuePair:[" + this.getNameString() + "=" + this.value.stringifyValue() + "]";
    }
}

