/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.signature.qual.SignatureUnknown;

public class MethodParameter
implements Cloneable {
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags;

    public MethodParameter() {
    }

    MethodParameter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataInput input) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        this.name_index = input.readUnsignedShort();
        this.access_flags = input.readUnsignedShort();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getNameIndex() {
        return this.name_index;
    }

    public void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int name_index) {
        this.name_index = name_index;
    }

    public @Nullable @UnknownInterned @UnknownKeyFor @Initialized @SignatureUnknown String getParameterName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown ConstantPool constant_pool) {
        if (this.name_index == 0) {
            return null;
        }
        return ((ConstantUtf8)constant_pool.getConstant(this.name_index, (byte)1)).getBytes();
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown int access_flags) {
        this.access_flags = access_flags;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isFinal() {
        return (this.access_flags & 0x10) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isSynthetic() {
        return (this.access_flags & 0x1000) != 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown boolean isMandated() {
        return (this.access_flags & Short.MIN_VALUE) != 0;
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown IOException {
        file.writeShort(this.name_index);
        file.writeShort(this.access_flags);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @SignatureUnknown MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

