/*
 * Copyright (c) 1999, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package javax.accessibility;

import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "interning" })
public class AccessibleRelation extends AccessibleBundle {

    @Interned
    public static final String LABEL_FOR;

    @Interned
    public static final String LABELED_BY;

    @Interned
    public static final String MEMBER_OF;

    @Interned
    public static final String CONTROLLER_FOR;

    @Interned
    public static final String CONTROLLED_BY;

    @Interned
    public static final String FLOWS_TO;

    @Interned
    public static final String FLOWS_FROM;

    @Interned
    public static final String SUBWINDOW_OF;

    @Interned
    public static final String PARENT_WINDOW_OF;

    @Interned
    public static final String EMBEDS;

    @Interned
    public static final String EMBEDDED_BY;

    @Interned
    public static final String CHILD_NODE_OF;

    @Interned
    public static final String LABEL_FOR_PROPERTY;

    @Interned
    public static final String LABELED_BY_PROPERTY;

    @Interned
    public static final String MEMBER_OF_PROPERTY;

    @Interned
    public static final String CONTROLLER_FOR_PROPERTY;

    @Interned
    public static final String CONTROLLED_BY_PROPERTY;

    @Interned
    public static final String FLOWS_TO_PROPERTY;

    @Interned
    public static final String FLOWS_FROM_PROPERTY;

    @Interned
    public static final String SUBWINDOW_OF_PROPERTY;

    @Interned
    public static final String PARENT_WINDOW_OF_PROPERTY;

    @Interned
    public static final String EMBEDS_PROPERTY;

    @Interned
    public static final String EMBEDDED_BY_PROPERTY;

    @Interned
    public static final String CHILD_NODE_OF_PROPERTY;

    public AccessibleRelation(String key) {
    }

    public AccessibleRelation(String key, Object target) {
    }

    public AccessibleRelation(String key, Object[] target) {
    }

    public String getKey();

    public Object[] getTarget();

    public void setTarget(Object target);

    public void setTarget(Object[] target);
}
