/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.CamundaFormRef;

public class TaskDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private String owner;
    public static final String SERIALIZED_NAME_CREATED = "created";
    @SerializedName(value="created")
    private Date created;
    public static final String SERIALIZED_NAME_DUE = "due";
    @SerializedName(value="due")
    private Date due;
    public static final String SERIALIZED_NAME_FOLLOW_UP = "followUp";
    @SerializedName(value="followUp")
    private Date followUp;
    public static final String SERIALIZED_NAME_DELEGATION_STATE = "delegationState";
    @SerializedName(value="delegationState")
    private DelegationStateEnum delegationState;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_PARENT_TASK_ID = "parentTaskId";
    @SerializedName(value="parentTaskId")
    private String parentTaskId;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
    @SerializedName(value="taskDefinitionKey")
    private String taskDefinitionKey;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_FORM_KEY = "formKey";
    @SerializedName(value="formKey")
    private String formKey;
    public static final String SERIALIZED_NAME_CAMUNDA_FORM_REF = "camundaFormRef";
    @SerializedName(value="camundaFormRef")
    private Map<String, CamundaFormRef> camundaFormRef = null;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;

    public TaskDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TaskDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TaskDto assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The assignee's id.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public TaskDto owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The owner's id.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public TaskDto created(Date created) {
        this.created = created;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date the task was created on. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public TaskDto due(Date due) {
        this.due = due;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's due date. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public TaskDto followUp(Date followUp) {
        this.followUp = followUp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The follow-up date for the task. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getFollowUp() {
        return this.followUp;
    }

    public void setFollowUp(Date followUp) {
        this.followUp = followUp;
    }

    public TaskDto delegationState(DelegationStateEnum delegationState) {
        this.delegationState = delegationState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's delegation state. Possible values are `PENDING` and `RESOLVED`.")
    public DelegationStateEnum getDelegationState() {
        return this.delegationState;
    }

    public void setDelegationState(DelegationStateEnum delegationState) {
        this.delegationState = delegationState;
    }

    public TaskDto description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TaskDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution the task belongs to.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public TaskDto parentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id the parent task, if this task is a subtask.")
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public TaskDto priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's priority.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public TaskDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition the task belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public TaskDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance the task belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public TaskDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case execution the task belongs to.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public TaskDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case definition the task belongs to.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public TaskDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance the task belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public TaskDto taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's key.")
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public TaskDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the task belongs to a process instance that is suspended.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public TaskDto formKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If not `null`, the form key for the task.")
    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public TaskDto camundaFormRef(Map<String, CamundaFormRef> camundaFormRef) {
        this.camundaFormRef = camundaFormRef;
        return this;
    }

    public TaskDto putCamundaFormRefItem(String key, CamundaFormRef camundaFormRefItem) {
        if (this.camundaFormRef == null) {
            this.camundaFormRef = new HashMap<String, CamundaFormRef>();
        }
        this.camundaFormRef.put(key, camundaFormRefItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A reference to a specific version of a Camunda Form.")
    public Map<String, CamundaFormRef> getCamundaFormRef() {
        return this.camundaFormRef;
    }

    public void setCamundaFormRef(Map<String, CamundaFormRef> camundaFormRef) {
        this.camundaFormRef = camundaFormRef;
    }

    public TaskDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If not `null`, the tenant id of the task.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskDto taskDto = (TaskDto)o;
        return Objects.equals(this.id, taskDto.id) && Objects.equals(this.name, taskDto.name) && Objects.equals(this.assignee, taskDto.assignee) && Objects.equals(this.owner, taskDto.owner) && Objects.equals(this.created, taskDto.created) && Objects.equals(this.due, taskDto.due) && Objects.equals(this.followUp, taskDto.followUp) && Objects.equals((Object)this.delegationState, (Object)taskDto.delegationState) && Objects.equals(this.description, taskDto.description) && Objects.equals(this.executionId, taskDto.executionId) && Objects.equals(this.parentTaskId, taskDto.parentTaskId) && Objects.equals(this.priority, taskDto.priority) && Objects.equals(this.processDefinitionId, taskDto.processDefinitionId) && Objects.equals(this.processInstanceId, taskDto.processInstanceId) && Objects.equals(this.caseExecutionId, taskDto.caseExecutionId) && Objects.equals(this.caseDefinitionId, taskDto.caseDefinitionId) && Objects.equals(this.caseInstanceId, taskDto.caseInstanceId) && Objects.equals(this.taskDefinitionKey, taskDto.taskDefinitionKey) && Objects.equals(this.suspended, taskDto.suspended) && Objects.equals(this.formKey, taskDto.formKey) && Objects.equals(this.camundaFormRef, taskDto.camundaFormRef) && Objects.equals(this.tenantId, taskDto.tenantId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.assignee, this.owner, this.created, this.due, this.followUp, this.delegationState, this.description, this.executionId, this.parentTaskId, this.priority, this.processDefinitionId, this.processInstanceId, this.caseExecutionId, this.caseDefinitionId, this.caseInstanceId, this.taskDefinitionKey, this.suspended, this.formKey, this.camundaFormRef, this.tenantId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    due: ").append(this.toIndentedString(this.due)).append("\n");
        sb.append("    followUp: ").append(this.toIndentedString(this.followUp)).append("\n");
        sb.append("    delegationState: ").append(this.toIndentedString((Object)this.delegationState)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    parentTaskId: ").append(this.toIndentedString(this.parentTaskId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    taskDefinitionKey: ").append(this.toIndentedString(this.taskDefinitionKey)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    formKey: ").append(this.toIndentedString(this.formKey)).append("\n");
        sb.append("    camundaFormRef: ").append(this.toIndentedString(this.camundaFormRef)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DelegationStateEnum {
        PENDING("PENDING"),
        RESOLVED("RESOLVED");

        private String value;

        private DelegationStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DelegationStateEnum fromValue(String value) {
            for (DelegationStateEnum b : DelegationStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DelegationStateEnum> {
            public void write(JsonWriter jsonWriter, DelegationStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DelegationStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DelegationStateEnum.fromValue(value);
            }
        }
    }
}

