/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MigrationInstructionValidationReportDto;
import org.camunda.community.rest.client.dto.MigrationVariableValidationReportDto;

public class MigrationPlanReportDto {
    public static final String SERIALIZED_NAME_INSTRUCTION_REPORTS = "instructionReports";
    @SerializedName(value="instructionReports")
    private List<MigrationInstructionValidationReportDto> instructionReports = null;
    public static final String SERIALIZED_NAME_VARIABLE_REPORTS = "variableReports";
    @SerializedName(value="variableReports")
    private Map<String, MigrationVariableValidationReportDto> variableReports = null;

    public MigrationPlanReportDto instructionReports(List<MigrationInstructionValidationReportDto> instructionReports) {
        this.instructionReports = instructionReports;
        return this;
    }

    public MigrationPlanReportDto addInstructionReportsItem(MigrationInstructionValidationReportDto instructionReportsItem) {
        if (this.instructionReports == null) {
            this.instructionReports = new ArrayList<MigrationInstructionValidationReportDto>();
        }
        this.instructionReports.add(instructionReportsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of instruction validation reports. If no validation errors are detected it is an empty list.")
    public List<MigrationInstructionValidationReportDto> getInstructionReports() {
        return this.instructionReports;
    }

    public void setInstructionReports(List<MigrationInstructionValidationReportDto> instructionReports) {
        this.instructionReports = instructionReports;
    }

    public MigrationPlanReportDto variableReports(Map<String, MigrationVariableValidationReportDto> variableReports) {
        this.variableReports = variableReports;
        return this;
    }

    public MigrationPlanReportDto putVariableReportsItem(String key, MigrationVariableValidationReportDto variableReportsItem) {
        if (this.variableReports == null) {
            this.variableReports = new HashMap<String, MigrationVariableValidationReportDto>();
        }
        this.variableReports.put(key, variableReportsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of variable reports. Each key is a variable name and each value a JSON object consisting of the variable's type, value, value info object and a list of failures.")
    public Map<String, MigrationVariableValidationReportDto> getVariableReports() {
        return this.variableReports;
    }

    public void setVariableReports(Map<String, MigrationVariableValidationReportDto> variableReports) {
        this.variableReports = variableReports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationPlanReportDto migrationPlanReportDto = (MigrationPlanReportDto)o;
        return Objects.equals(this.instructionReports, migrationPlanReportDto.instructionReports) && Objects.equals(this.variableReports, migrationPlanReportDto.variableReports);
    }

    public int hashCode() {
        return Objects.hash(this.instructionReports, this.variableReports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationPlanReportDto {\n");
        sb.append("    instructionReports: ").append(this.toIndentedString(this.instructionReports)).append("\n");
        sb.append("    variableReports: ").append(this.toIndentedString(this.variableReports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

