/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class LockExternalTaskDto {
    public static final String SERIALIZED_NAME_LOCK_DURATION = "lockDuration";
    @SerializedName(value="lockDuration")
    private Long lockDuration;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;

    public LockExternalTaskDto lockDuration(Long lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The duration to lock the external task for in milliseconds. **Note:** Attempting to lock an already locked external task with the same `workerId` will succeed and a new lock duration will be set, starting from the current moment.")
    public Long getLockDuration() {
        return this.lockDuration;
    }

    public void setLockDuration(Long lockDuration) {
        this.lockDuration = lockDuration;
    }

    public LockExternalTaskDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="**Mandatory.** The ID of the worker who is performing the operation on the external task. If the task is already locked, must match the id of the worker who has most recently locked the task.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockExternalTaskDto lockExternalTaskDto = (LockExternalTaskDto)o;
        return Objects.equals(this.lockDuration, lockExternalTaskDto.lockDuration) && Objects.equals(this.workerId, lockExternalTaskDto.workerId);
    }

    public int hashCode() {
        return Objects.hash(this.lockDuration, this.workerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockExternalTaskDto {\n");
        sb.append("    lockDuration: ").append(this.toIndentedString(this.lockDuration)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

