/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A historic decision instance query which defines a list of historic decision instances")
public class HistoricDecisionInstanceQueryDto {
    public static final String SERIALIZED_NAME_DECISION_INSTANCE_ID = "decisionInstanceId";
    @SerializedName(value="decisionInstanceId")
    private String decisionInstanceId;
    public static final String SERIALIZED_NAME_DECISION_INSTANCE_ID_IN = "decisionInstanceIdIn";
    @SerializedName(value="decisionInstanceIdIn")
    private List<String> decisionInstanceIdIn = null;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_ID = "decisionDefinitionId";
    @SerializedName(value="decisionDefinitionId")
    private String decisionDefinitionId;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_ID_IN = "decisionDefinitionIdIn";
    @SerializedName(value="decisionDefinitionIdIn")
    private List<String> decisionDefinitionIdIn = null;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
    @SerializedName(value="decisionDefinitionKey")
    private String decisionDefinitionKey;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_KEY_IN = "decisionDefinitionKeyIn";
    @SerializedName(value="decisionDefinitionKeyIn")
    private List<String> decisionDefinitionKeyIn = null;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_NAME = "decisionDefinitionName";
    @SerializedName(value="decisionDefinitionName")
    private String decisionDefinitionName;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_NAME_LIKE = "decisionDefinitionNameLike";
    @SerializedName(value="decisionDefinitionNameLike")
    private String decisionDefinitionNameLike;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID_IN = "activityIdIn";
    @SerializedName(value="activityIdIn")
    private List<String> activityIdIn = null;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID_IN = "activityInstanceIdIn";
    @SerializedName(value="activityInstanceIdIn")
    private List<String> activityInstanceIdIn = null;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_EVALUATED_BEFORE = "evaluatedBefore";
    @SerializedName(value="evaluatedBefore")
    private Date evaluatedBefore;
    public static final String SERIALIZED_NAME_EVALUATED_AFTER = "evaluatedAfter";
    @SerializedName(value="evaluatedAfter")
    private Date evaluatedAfter;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_ROOT_DECISION_INSTANCE_ID = "rootDecisionInstanceId";
    @SerializedName(value="rootDecisionInstanceId")
    private String rootDecisionInstanceId;
    public static final String SERIALIZED_NAME_ROOT_DECISION_INSTANCES_ONLY = "rootDecisionInstancesOnly";
    @SerializedName(value="rootDecisionInstancesOnly")
    private Boolean rootDecisionInstancesOnly;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
    @SerializedName(value="decisionRequirementsDefinitionId")
    private String decisionRequirementsDefinitionId;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
    @SerializedName(value="decisionRequirementsDefinitionKey")
    private String decisionRequirementsDefinitionKey;
    public static final String SERIALIZED_NAME_INCLUDE_INPUTS = "includeInputs";
    @SerializedName(value="includeInputs")
    private Boolean includeInputs;
    public static final String SERIALIZED_NAME_INCLUDE_OUTPUTS = "includeOutputs";
    @SerializedName(value="includeOutputs")
    private Boolean includeOutputs;
    public static final String SERIALIZED_NAME_DISABLE_BINARY_FETCHING = "disableBinaryFetching";
    @SerializedName(value="disableBinaryFetching")
    private Boolean disableBinaryFetching;
    public static final String SERIALIZED_NAME_DISABLE_CUSTOM_OBJECT_DESERIALIZATION = "disableCustomObjectDeserialization";
    @SerializedName(value="disableCustomObjectDeserialization")
    private Boolean disableCustomObjectDeserialization;

    public HistoricDecisionInstanceQueryDto decisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by decision instance id.")
    public String getDecisionInstanceId() {
        return this.decisionInstanceId;
    }

    public void setDecisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
    }

    public HistoricDecisionInstanceQueryDto decisionInstanceIdIn(List<String> decisionInstanceIdIn) {
        this.decisionInstanceIdIn = decisionInstanceIdIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addDecisionInstanceIdInItem(String decisionInstanceIdInItem) {
        if (this.decisionInstanceIdIn == null) {
            this.decisionInstanceIdIn = new ArrayList<String>();
        }
        this.decisionInstanceIdIn.add(decisionInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by decision instance ids. Must be a comma-separated list of decision instance ids.")
    public List<String> getDecisionInstanceIdIn() {
        return this.decisionInstanceIdIn;
    }

    public void setDecisionInstanceIdIn(List<String> decisionInstanceIdIn) {
        this.decisionInstanceIdIn = decisionInstanceIdIn;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the decision definition the instances belongs to.")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionIdIn(List<String> decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addDecisionDefinitionIdInItem(String decisionDefinitionIdInItem) {
        if (this.decisionDefinitionIdIn == null) {
            this.decisionDefinitionIdIn = new ArrayList<String>();
        }
        this.decisionDefinitionIdIn.add(decisionDefinitionIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.")
    public List<String> getDecisionDefinitionIdIn() {
        return this.decisionDefinitionIdIn;
    }

    public void setDecisionDefinitionIdIn(List<String> decisionDefinitionIdIn) {
        this.decisionDefinitionIdIn = decisionDefinitionIdIn;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the decision definition the instances belongs to.")
    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionKeyIn(List<String> decisionDefinitionKeyIn) {
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addDecisionDefinitionKeyInItem(String decisionDefinitionKeyInItem) {
        if (this.decisionDefinitionKeyIn == null) {
            this.decisionDefinitionKeyIn = new ArrayList<String>();
        }
        this.decisionDefinitionKeyIn.add(decisionDefinitionKeyInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.")
    public List<String> getDecisionDefinitionKeyIn() {
        return this.decisionDefinitionKeyIn;
    }

    public void setDecisionDefinitionKeyIn(List<String> decisionDefinitionKeyIn) {
        this.decisionDefinitionKeyIn = decisionDefinitionKeyIn;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the name of the decision definition the instances belongs to.")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public HistoricDecisionInstanceQueryDto decisionDefinitionNameLike(String decisionDefinitionNameLike) {
        this.decisionDefinitionNameLike = decisionDefinitionNameLike;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.")
    public String getDecisionDefinitionNameLike() {
        return this.decisionDefinitionNameLike;
    }

    public void setDecisionDefinitionNameLike(String decisionDefinitionNameLike) {
        this.decisionDefinitionNameLike = decisionDefinitionNameLike;
    }

    public HistoricDecisionInstanceQueryDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process definition the instances belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricDecisionInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the process definition the instances belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricDecisionInstanceQueryDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the process instance the instances belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricDecisionInstanceQueryDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the case definition the instances belongs to.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public HistoricDecisionInstanceQueryDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the case definition the instances belongs to.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public HistoricDecisionInstanceQueryDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the case instance the instances belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricDecisionInstanceQueryDto activityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addActivityIdInItem(String activityIdInItem) {
        if (this.activityIdIn == null) {
            this.activityIdIn = new ArrayList<String>();
        }
        this.activityIdIn.add(activityIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.")
    public List<String> getActivityIdIn() {
        return this.activityIdIn;
    }

    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    public HistoricDecisionInstanceQueryDto activityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addActivityInstanceIdInItem(String activityInstanceIdInItem) {
        if (this.activityInstanceIdIn == null) {
            this.activityInstanceIdIn = new ArrayList<String>();
        }
        this.activityInstanceIdIn.add(activityInstanceIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.")
    public List<String> getActivityInstanceIdIn() {
        return this.activityInstanceIdIn;
    }

    public void setActivityInstanceIdIn(List<String> activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    public HistoricDecisionInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricDecisionInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricDecisionInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricDecisionInstanceQueryDto evaluatedBefore(Date evaluatedBefore) {
        this.evaluatedBefore = evaluatedBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getEvaluatedBefore() {
        return this.evaluatedBefore;
    }

    public void setEvaluatedBefore(Date evaluatedBefore) {
        this.evaluatedBefore = evaluatedBefore;
    }

    public HistoricDecisionInstanceQueryDto evaluatedAfter(Date evaluatedAfter) {
        this.evaluatedAfter = evaluatedAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")
    public Date getEvaluatedAfter() {
        return this.evaluatedAfter;
    }

    public void setEvaluatedAfter(Date evaluatedAfter) {
        this.evaluatedAfter = evaluatedAfter;
    }

    public HistoricDecisionInstanceQueryDto userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that were evaluated by the given user.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public HistoricDecisionInstanceQueryDto rootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.")
    public String getRootDecisionInstanceId() {
        return this.rootDecisionInstanceId;
    }

    public void setRootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
    }

    public HistoricDecisionInstanceQueryDto rootDecisionInstancesOnly(Boolean rootDecisionInstancesOnly) {
        this.rootDecisionInstancesOnly = rootDecisionInstancesOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getRootDecisionInstancesOnly() {
        return this.rootDecisionInstancesOnly;
    }

    public void setRootDecisionInstancesOnly(Boolean rootDecisionInstancesOnly) {
        this.rootDecisionInstancesOnly = rootDecisionInstancesOnly;
    }

    public HistoricDecisionInstanceQueryDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the decision requirements definition the instances belongs to.")
    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    public HistoricDecisionInstanceQueryDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by the key of the decision requirements definition the instances belongs to.")
    public String getDecisionRequirementsDefinitionKey() {
        return this.decisionRequirementsDefinitionKey;
    }

    public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    }

    public HistoricDecisionInstanceQueryDto includeInputs(Boolean includeInputs) {
        this.includeInputs = includeInputs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include input values in the result. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getIncludeInputs() {
        return this.includeInputs;
    }

    public void setIncludeInputs(Boolean includeInputs) {
        this.includeInputs = includeInputs;
    }

    public HistoricDecisionInstanceQueryDto includeOutputs(Boolean includeOutputs) {
        this.includeOutputs = includeOutputs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Include output values in the result. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getIncludeOutputs() {
        return this.includeOutputs;
    }

    public void setIncludeOutputs(Boolean includeOutputs) {
        this.includeOutputs = includeOutputs;
    }

    public HistoricDecisionInstanceQueryDto disableBinaryFetching(Boolean disableBinaryFetching) {
        this.disableBinaryFetching = disableBinaryFetching;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getDisableBinaryFetching() {
        return this.disableBinaryFetching;
    }

    public void setDisableBinaryFetching(Boolean disableBinaryFetching) {
        this.disableBinaryFetching = disableBinaryFetching;
    }

    public HistoricDecisionInstanceQueryDto disableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
        this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.")
    public Boolean getDisableCustomObjectDeserialization() {
        return this.disableCustomObjectDeserialization;
    }

    public void setDisableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
        this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricDecisionInstanceQueryDto historicDecisionInstanceQueryDto = (HistoricDecisionInstanceQueryDto)o;
        return Objects.equals(this.decisionInstanceId, historicDecisionInstanceQueryDto.decisionInstanceId) && Objects.equals(this.decisionInstanceIdIn, historicDecisionInstanceQueryDto.decisionInstanceIdIn) && Objects.equals(this.decisionDefinitionId, historicDecisionInstanceQueryDto.decisionDefinitionId) && Objects.equals(this.decisionDefinitionIdIn, historicDecisionInstanceQueryDto.decisionDefinitionIdIn) && Objects.equals(this.decisionDefinitionKey, historicDecisionInstanceQueryDto.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionKeyIn, historicDecisionInstanceQueryDto.decisionDefinitionKeyIn) && Objects.equals(this.decisionDefinitionName, historicDecisionInstanceQueryDto.decisionDefinitionName) && Objects.equals(this.decisionDefinitionNameLike, historicDecisionInstanceQueryDto.decisionDefinitionNameLike) && Objects.equals(this.processDefinitionId, historicDecisionInstanceQueryDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicDecisionInstanceQueryDto.processDefinitionKey) && Objects.equals(this.processInstanceId, historicDecisionInstanceQueryDto.processInstanceId) && Objects.equals(this.caseDefinitionId, historicDecisionInstanceQueryDto.caseDefinitionId) && Objects.equals(this.caseDefinitionKey, historicDecisionInstanceQueryDto.caseDefinitionKey) && Objects.equals(this.caseInstanceId, historicDecisionInstanceQueryDto.caseInstanceId) && Objects.equals(this.activityIdIn, historicDecisionInstanceQueryDto.activityIdIn) && Objects.equals(this.activityInstanceIdIn, historicDecisionInstanceQueryDto.activityInstanceIdIn) && Objects.equals(this.tenantIdIn, historicDecisionInstanceQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicDecisionInstanceQueryDto.withoutTenantId) && Objects.equals(this.evaluatedBefore, historicDecisionInstanceQueryDto.evaluatedBefore) && Objects.equals(this.evaluatedAfter, historicDecisionInstanceQueryDto.evaluatedAfter) && Objects.equals(this.userId, historicDecisionInstanceQueryDto.userId) && Objects.equals(this.rootDecisionInstanceId, historicDecisionInstanceQueryDto.rootDecisionInstanceId) && Objects.equals(this.rootDecisionInstancesOnly, historicDecisionInstanceQueryDto.rootDecisionInstancesOnly) && Objects.equals(this.decisionRequirementsDefinitionId, historicDecisionInstanceQueryDto.decisionRequirementsDefinitionId) && Objects.equals(this.decisionRequirementsDefinitionKey, historicDecisionInstanceQueryDto.decisionRequirementsDefinitionKey) && Objects.equals(this.includeInputs, historicDecisionInstanceQueryDto.includeInputs) && Objects.equals(this.includeOutputs, historicDecisionInstanceQueryDto.includeOutputs) && Objects.equals(this.disableBinaryFetching, historicDecisionInstanceQueryDto.disableBinaryFetching) && Objects.equals(this.disableCustomObjectDeserialization, historicDecisionInstanceQueryDto.disableCustomObjectDeserialization);
    }

    public int hashCode() {
        return Objects.hash(this.decisionInstanceId, this.decisionInstanceIdIn, this.decisionDefinitionId, this.decisionDefinitionIdIn, this.decisionDefinitionKey, this.decisionDefinitionKeyIn, this.decisionDefinitionName, this.decisionDefinitionNameLike, this.processDefinitionId, this.processDefinitionKey, this.processInstanceId, this.caseDefinitionId, this.caseDefinitionKey, this.caseInstanceId, this.activityIdIn, this.activityInstanceIdIn, this.tenantIdIn, this.withoutTenantId, this.evaluatedBefore, this.evaluatedAfter, this.userId, this.rootDecisionInstanceId, this.rootDecisionInstancesOnly, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey, this.includeInputs, this.includeOutputs, this.disableBinaryFetching, this.disableCustomObjectDeserialization);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricDecisionInstanceQueryDto {\n");
        sb.append("    decisionInstanceId: ").append(this.toIndentedString(this.decisionInstanceId)).append("\n");
        sb.append("    decisionInstanceIdIn: ").append(this.toIndentedString(this.decisionInstanceIdIn)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionIdIn: ").append(this.toIndentedString(this.decisionDefinitionIdIn)).append("\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionKeyIn: ").append(this.toIndentedString(this.decisionDefinitionKeyIn)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    decisionDefinitionNameLike: ").append(this.toIndentedString(this.decisionDefinitionNameLike)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    activityIdIn: ").append(this.toIndentedString(this.activityIdIn)).append("\n");
        sb.append("    activityInstanceIdIn: ").append(this.toIndentedString(this.activityInstanceIdIn)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    evaluatedBefore: ").append(this.toIndentedString(this.evaluatedBefore)).append("\n");
        sb.append("    evaluatedAfter: ").append(this.toIndentedString(this.evaluatedAfter)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    rootDecisionInstanceId: ").append(this.toIndentedString(this.rootDecisionInstanceId)).append("\n");
        sb.append("    rootDecisionInstancesOnly: ").append(this.toIndentedString(this.rootDecisionInstancesOnly)).append("\n");
        sb.append("    decisionRequirementsDefinitionId: ").append(this.toIndentedString(this.decisionRequirementsDefinitionId)).append("\n");
        sb.append("    decisionRequirementsDefinitionKey: ").append(this.toIndentedString(this.decisionRequirementsDefinitionKey)).append("\n");
        sb.append("    includeInputs: ").append(this.toIndentedString(this.includeInputs)).append("\n");
        sb.append("    includeOutputs: ").append(this.toIndentedString(this.includeOutputs)).append("\n");
        sb.append("    disableBinaryFetching: ").append(this.toIndentedString(this.disableBinaryFetching)).append("\n");
        sb.append("    disableCustomObjectDeserialization: ").append(this.toIndentedString(this.disableCustomObjectDeserialization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

