/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.AttachmentDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskAttachmentApi {
    private ApiClient localVarApiClient;

    public TaskAttachmentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskAttachmentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addAttachmentCall(String id, String attachmentName, String attachmentDescription, String attachmentType, String url, File content, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/attachment/create".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (attachmentName != null) {
            localVarFormParams.put("attachment-name", attachmentName);
        }
        if (attachmentDescription != null) {
            localVarFormParams.put("attachment-description", attachmentDescription);
        }
        if (attachmentType != null) {
            localVarFormParams.put("attachment-type", attachmentType);
        }
        if (url != null) {
            localVarFormParams.put("url", url);
        }
        if (content != null) {
            localVarFormParams.put("content", content);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addAttachmentValidateBeforeCall(String id, String attachmentName, String attachmentDescription, String attachmentType, String url, File content, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling addAttachment(Async)");
        }
        Call localVarCall = this.addAttachmentCall(id, attachmentName, attachmentDescription, attachmentType, url, content, _callback);
        return localVarCall;
    }

    public AttachmentDto addAttachment(String id, String attachmentName, String attachmentDescription, String attachmentType, String url, File content) throws ApiException {
        ApiResponse<AttachmentDto> localVarResp = this.addAttachmentWithHttpInfo(id, attachmentName, attachmentDescription, attachmentType, url, content);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentDto> addAttachmentWithHttpInfo(String id, String attachmentName, String attachmentDescription, String attachmentType, String url, File content) throws ApiException {
        Call localVarCall = this.addAttachmentValidateBeforeCall(id, attachmentName, attachmentDescription, attachmentType, url, content, null);
        Type localVarReturnType = new TypeToken<AttachmentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addAttachmentAsync(String id, String attachmentName, String attachmentDescription, String attachmentType, String url, File content, ApiCallback<AttachmentDto> _callback) throws ApiException {
        Call localVarCall = this.addAttachmentValidateBeforeCall(id, attachmentName, attachmentDescription, attachmentType, url, content, _callback);
        Type localVarReturnType = new TypeToken<AttachmentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAttachmentCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/attachment/{attachmentId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAttachmentValidateBeforeCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteAttachment(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling deleteAttachment(Async)");
        }
        Call localVarCall = this.deleteAttachmentCall(id, attachmentId, _callback);
        return localVarCall;
    }

    public void deleteAttachment(String id, String attachmentId) throws ApiException {
        this.deleteAttachmentWithHttpInfo(id, attachmentId);
    }

    public ApiResponse<Void> deleteAttachmentWithHttpInfo(String id, String attachmentId) throws ApiException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(id, attachmentId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAttachmentAsync(String id, String attachmentId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAttachmentValidateBeforeCall(id, attachmentId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAttachmentCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/attachment/{attachmentId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentValidateBeforeCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAttachment(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachment(Async)");
        }
        Call localVarCall = this.getAttachmentCall(id, attachmentId, _callback);
        return localVarCall;
    }

    public AttachmentDto getAttachment(String id, String attachmentId) throws ApiException {
        ApiResponse<AttachmentDto> localVarResp = this.getAttachmentWithHttpInfo(id, attachmentId);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentDto> getAttachmentWithHttpInfo(String id, String attachmentId) throws ApiException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(id, attachmentId, null);
        Type localVarReturnType = new TypeToken<AttachmentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentAsync(String id, String attachmentId, ApiCallback<AttachmentDto> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentValidateBeforeCall(id, attachmentId, _callback);
        Type localVarReturnType = new TypeToken<AttachmentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentDataCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/attachment/{attachmentId}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentDataValidateBeforeCall(String id, String attachmentId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAttachmentData(Async)");
        }
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachmentData(Async)");
        }
        Call localVarCall = this.getAttachmentDataCall(id, attachmentId, _callback);
        return localVarCall;
    }

    public File getAttachmentData(String id, String attachmentId) throws ApiException {
        ApiResponse<File> localVarResp = this.getAttachmentDataWithHttpInfo(id, attachmentId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getAttachmentDataWithHttpInfo(String id, String attachmentId) throws ApiException {
        Call localVarCall = this.getAttachmentDataValidateBeforeCall(id, attachmentId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentDataAsync(String id, String attachmentId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentDataValidateBeforeCall(id, attachmentId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/attachment".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getAttachments(Async)");
        }
        Call localVarCall = this.getAttachmentsCall(id, _callback);
        return localVarCall;
    }

    public List<AttachmentDto> getAttachments(String id) throws ApiException {
        ApiResponse<List<AttachmentDto>> localVarResp = this.getAttachmentsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<List<AttachmentDto>> getAttachmentsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<AttachmentDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentsAsync(String id, ApiCallback<List<AttachmentDto>> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<AttachmentDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

