/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeploymentDto;
import org.camunda.community.rest.client.dto.DeploymentResourceDto;
import org.camunda.community.rest.client.dto.DeploymentWithDefinitionsDto;
import org.camunda.community.rest.client.dto.RedeploymentDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class DeploymentApi {
    private ApiClient localVarApiClient;

    public DeploymentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeploymentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createDeploymentCall(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, Date deploymentActivationTime, File data, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deployment/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (tenantId != null) {
            localVarFormParams.put("tenant-id", tenantId);
        }
        if (deploymentSource != null) {
            localVarFormParams.put("deployment-source", deploymentSource);
        }
        if (deployChangedOnly != null) {
            localVarFormParams.put("deploy-changed-only", deployChangedOnly);
        }
        if (enableDuplicateFiltering != null) {
            localVarFormParams.put("enable-duplicate-filtering", enableDuplicateFiltering);
        }
        if (deploymentName != null) {
            localVarFormParams.put("deployment-name", deploymentName);
        }
        if (deploymentActivationTime != null) {
            localVarFormParams.put("deployment-activation-time", deploymentActivationTime);
        }
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDeploymentValidateBeforeCall(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, Date deploymentActivationTime, File data, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createDeploymentCall(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data, _callback);
        return localVarCall;
    }

    public DeploymentWithDefinitionsDto createDeployment(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, Date deploymentActivationTime, File data) throws ApiException {
        ApiResponse<DeploymentWithDefinitionsDto> localVarResp = this.createDeploymentWithHttpInfo(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentWithDefinitionsDto> createDeploymentWithHttpInfo(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, Date deploymentActivationTime, File data) throws ApiException {
        Call localVarCall = this.createDeploymentValidateBeforeCall(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data, null);
        Type localVarReturnType = new TypeToken<DeploymentWithDefinitionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDeploymentAsync(String tenantId, String deploymentSource, Boolean deployChangedOnly, Boolean enableDuplicateFiltering, String deploymentName, Date deploymentActivationTime, File data, ApiCallback<DeploymentWithDefinitionsDto> _callback) throws ApiException {
        Call localVarCall = this.createDeploymentValidateBeforeCall(tenantId, deploymentSource, deployChangedOnly, enableDuplicateFiltering, deploymentName, deploymentActivationTime, data, _callback);
        Type localVarReturnType = new TypeToken<DeploymentWithDefinitionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteDeploymentCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deployment/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cascade != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cascade", cascade));
        }
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }
        if (skipIoMappings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteDeploymentValidateBeforeCall(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteDeployment(Async)");
        }
        Call localVarCall = this.deleteDeploymentCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        return localVarCall;
    }

    public void deleteDeployment(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        this.deleteDeploymentWithHttpInfo(id, cascade, skipCustomListeners, skipIoMappings);
    }

    public ApiResponse<Void> deleteDeploymentWithHttpInfo(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings) throws ApiException {
        Call localVarCall = this.deleteDeploymentValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteDeploymentAsync(String id, Boolean cascade, Boolean skipCustomListeners, Boolean skipIoMappings, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteDeploymentValidateBeforeCall(id, cascade, skipCustomListeners, skipIoMappings, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getDeploymentCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeployment(Async)");
        }
        Call localVarCall = this.getDeploymentCall(id, _callback);
        return localVarCall;
    }

    public DeploymentDto getDeployment(String id) throws ApiException {
        ApiResponse<DeploymentDto> localVarResp = this.getDeploymentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentDto> getDeploymentWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDeploymentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<DeploymentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentAsync(String id, ApiCallback<DeploymentDto> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<DeploymentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentResourceCall(String id, String resourceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/{id}/resources/{resourceId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{resourceId\\}", this.localVarApiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentResourceValidateBeforeCall(String id, String resourceId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeploymentResource(Async)");
        }
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getDeploymentResource(Async)");
        }
        Call localVarCall = this.getDeploymentResourceCall(id, resourceId, _callback);
        return localVarCall;
    }

    public DeploymentResourceDto getDeploymentResource(String id, String resourceId) throws ApiException {
        ApiResponse<DeploymentResourceDto> localVarResp = this.getDeploymentResourceWithHttpInfo(id, resourceId);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentResourceDto> getDeploymentResourceWithHttpInfo(String id, String resourceId) throws ApiException {
        Call localVarCall = this.getDeploymentResourceValidateBeforeCall(id, resourceId, null);
        Type localVarReturnType = new TypeToken<DeploymentResourceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentResourceAsync(String id, String resourceId, ApiCallback<DeploymentResourceDto> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentResourceValidateBeforeCall(id, resourceId, _callback);
        Type localVarReturnType = new TypeToken<DeploymentResourceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentResourceDataCall(String id, String resourceId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/{id}/resources/{resourceId}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{resourceId\\}", this.localVarApiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "*/*", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentResourceDataValidateBeforeCall(String id, String resourceId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeploymentResourceData(Async)");
        }
        if (resourceId == null) {
            throw new ApiException("Missing the required parameter 'resourceId' when calling getDeploymentResourceData(Async)");
        }
        Call localVarCall = this.getDeploymentResourceDataCall(id, resourceId, _callback);
        return localVarCall;
    }

    public File getDeploymentResourceData(String id, String resourceId) throws ApiException {
        ApiResponse<File> localVarResp = this.getDeploymentResourceDataWithHttpInfo(id, resourceId);
        return localVarResp.getData();
    }

    public ApiResponse<File> getDeploymentResourceDataWithHttpInfo(String id, String resourceId) throws ApiException {
        Call localVarCall = this.getDeploymentResourceDataValidateBeforeCall(id, resourceId, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentResourceDataAsync(String id, String resourceId, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentResourceDataValidateBeforeCall(id, resourceId, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentResourcesCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/{id}/resources".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentResourcesValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getDeploymentResources(Async)");
        }
        Call localVarCall = this.getDeploymentResourcesCall(id, _callback);
        return localVarCall;
    }

    public List<DeploymentResourceDto> getDeploymentResources(String id) throws ApiException {
        ApiResponse<List<DeploymentResourceDto>> localVarResp = this.getDeploymentResourcesWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<List<DeploymentResourceDto>> getDeploymentResourcesWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getDeploymentResourcesValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<DeploymentResourceDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentResourcesAsync(String id, ApiCallback<List<DeploymentResourceDto>> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentResourcesValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<DeploymentResourceDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentsCall(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deployment";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (source != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source", source));
        }
        if (withoutSource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutSource", withoutSource));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeDeploymentsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeDeploymentsWithoutTenantId", includeDeploymentsWithoutTenantId));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("before", before));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentsValidateBeforeCall(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDeploymentsCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<DeploymentDto> getDeployments(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<DeploymentDto>> localVarResp = this.getDeploymentsWithHttpInfo(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<DeploymentDto>> getDeploymentsWithHttpInfo(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getDeploymentsValidateBeforeCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<DeploymentDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentsAsync(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<DeploymentDto>> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentsValidateBeforeCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<DeploymentDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getDeploymentsCountCall(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/deployment/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (id != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("id", id));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (source != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("source", source));
        }
        if (withoutSource != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutSource", withoutSource));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (includeDeploymentsWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeDeploymentsWithoutTenantId", includeDeploymentsWithoutTenantId));
        }
        if (after != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("after", after));
        }
        if (before != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("before", before));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDeploymentsCountValidateBeforeCall(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getDeploymentsCountCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, _callback);
        return localVarCall;
    }

    public CountResultDto getDeploymentsCount(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getDeploymentsCountWithHttpInfo(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getDeploymentsCountWithHttpInfo(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before) throws ApiException {
        Call localVarCall = this.getDeploymentsCountValidateBeforeCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDeploymentsCountAsync(String id, String name, String nameLike, String source, Boolean withoutSource, String tenantIdIn, Boolean withoutTenantId, Boolean includeDeploymentsWithoutTenantId, Date after, Date before, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getDeploymentsCountValidateBeforeCall(id, name, nameLike, source, withoutSource, tenantIdIn, withoutTenantId, includeDeploymentsWithoutTenantId, after, before, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRegisteredDeploymentsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/deployment/registered";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRegisteredDeploymentsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getRegisteredDeploymentsCall(_callback);
        return localVarCall;
    }

    public List<String> getRegisteredDeployments() throws ApiException {
        ApiResponse<List<String>> localVarResp = this.getRegisteredDeploymentsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<String>> getRegisteredDeploymentsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getRegisteredDeploymentsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRegisteredDeploymentsAsync(ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.getRegisteredDeploymentsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call redeployCall(String id, RedeploymentDto redeploymentDto, ApiCallback _callback) throws ApiException {
        RedeploymentDto localVarPostBody = redeploymentDto;
        String localVarPath = "/deployment/{id}/redeploy".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call redeployValidateBeforeCall(String id, RedeploymentDto redeploymentDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling redeploy(Async)");
        }
        Call localVarCall = this.redeployCall(id, redeploymentDto, _callback);
        return localVarCall;
    }

    public DeploymentWithDefinitionsDto redeploy(String id, RedeploymentDto redeploymentDto) throws ApiException {
        ApiResponse<DeploymentWithDefinitionsDto> localVarResp = this.redeployWithHttpInfo(id, redeploymentDto);
        return localVarResp.getData();
    }

    public ApiResponse<DeploymentWithDefinitionsDto> redeployWithHttpInfo(String id, RedeploymentDto redeploymentDto) throws ApiException {
        Call localVarCall = this.redeployValidateBeforeCall(id, redeploymentDto, null);
        Type localVarReturnType = new TypeToken<DeploymentWithDefinitionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call redeployAsync(String id, RedeploymentDto redeploymentDto, ApiCallback<DeploymentWithDefinitionsDto> _callback) throws ApiException {
        Call localVarCall = this.redeployValidateBeforeCall(id, redeploymentDto, _callback);
        Type localVarReturnType = new TypeToken<DeploymentWithDefinitionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

