/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;

/**
 * HistoricBatchDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class HistoricBatchDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_TOTAL_JOBS = "totalJobs";
  @SerializedName(SERIALIZED_NAME_TOTAL_JOBS)
  private Integer totalJobs;

  public static final String SERIALIZED_NAME_BATCH_JOBS_PER_SEED = "batchJobsPerSeed";
  @SerializedName(SERIALIZED_NAME_BATCH_JOBS_PER_SEED)
  private Integer batchJobsPerSeed;

  public static final String SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB = "invocationsPerBatchJob";
  @SerializedName(SERIALIZED_NAME_INVOCATIONS_PER_BATCH_JOB)
  private Integer invocationsPerBatchJob;

  public static final String SERIALIZED_NAME_SEED_JOB_DEFINITION_ID = "seedJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_SEED_JOB_DEFINITION_ID)
  private String seedJobDefinitionId;

  public static final String SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID = "monitorJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_MONITOR_JOB_DEFINITION_ID)
  private String monitorJobDefinitionId;

  public static final String SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID = "batchJobDefinitionId";
  @SerializedName(SERIALIZED_NAME_BATCH_JOB_DEFINITION_ID)
  private String batchJobDefinitionId;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_CREATE_USER_ID = "createUserId";
  @SerializedName(SERIALIZED_NAME_CREATE_USER_ID)
  private String createUserId;

  public static final String SERIALIZED_NAME_START_TIME = "startTime";
  @SerializedName(SERIALIZED_NAME_START_TIME)
  private Date startTime;

  public static final String SERIALIZED_NAME_END_TIME = "endTime";
  @SerializedName(SERIALIZED_NAME_END_TIME)
  private Date endTime;

  public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
  @SerializedName(SERIALIZED_NAME_REMOVAL_TIME)
  private Date removalTime;


  public HistoricBatchDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the batch.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the batch.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public HistoricBatchDto type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the batch. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public HistoricBatchDto totalJobs(Integer totalJobs) {
    
    this.totalJobs = totalJobs;
    return this;
  }

   /**
   *  The total jobs of a batch is the number of batch execution jobs required to complete the batch. 
   * @return totalJobs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = " The total jobs of a batch is the number of batch execution jobs required to complete the batch. ")

  public Integer getTotalJobs() {
    return totalJobs;
  }


  public void setTotalJobs(Integer totalJobs) {
    this.totalJobs = totalJobs;
  }


  public HistoricBatchDto batchJobsPerSeed(Integer batchJobsPerSeed) {
    
    this.batchJobsPerSeed = batchJobsPerSeed;
    return this;
  }

   /**
   *  The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see &#x60;totalJobs&#x60; property). 
   * @return batchJobsPerSeed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = " The number of batch execution jobs created per seed job invocation. The batch seed job is invoked until it has created all batch execution jobs required by the batch (see `totalJobs` property). ")

  public Integer getBatchJobsPerSeed() {
    return batchJobsPerSeed;
  }


  public void setBatchJobsPerSeed(Integer batchJobsPerSeed) {
    this.batchJobsPerSeed = batchJobsPerSeed;
  }


  public HistoricBatchDto invocationsPerBatchJob(Integer invocationsPerBatchJob) {
    
    this.invocationsPerBatchJob = invocationsPerBatchJob;
    return this;
  }

   /**
   *  Every batch execution job invokes the command executed by the batch &#x60;invocationsPerBatchJob&#x60; times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job. 
   * @return invocationsPerBatchJob
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = " Every batch execution job invokes the command executed by the batch `invocationsPerBatchJob` times. E.g., for a process instance migration batch this specifies the number of process instances which are migrated per batch execution job. ")

  public Integer getInvocationsPerBatchJob() {
    return invocationsPerBatchJob;
  }


  public void setInvocationsPerBatchJob(Integer invocationsPerBatchJob) {
    this.invocationsPerBatchJob = invocationsPerBatchJob;
  }


  public HistoricBatchDto seedJobDefinitionId(String seedJobDefinitionId) {
    
    this.seedJobDefinitionId = seedJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the seed jobs of this batch.
   * @return seedJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the seed jobs of this batch.")

  public String getSeedJobDefinitionId() {
    return seedJobDefinitionId;
  }


  public void setSeedJobDefinitionId(String seedJobDefinitionId) {
    this.seedJobDefinitionId = seedJobDefinitionId;
  }


  public HistoricBatchDto monitorJobDefinitionId(String monitorJobDefinitionId) {
    
    this.monitorJobDefinitionId = monitorJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the monitor jobs of this batch.
   * @return monitorJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the monitor jobs of this batch.")

  public String getMonitorJobDefinitionId() {
    return monitorJobDefinitionId;
  }


  public void setMonitorJobDefinitionId(String monitorJobDefinitionId) {
    this.monitorJobDefinitionId = monitorJobDefinitionId;
  }


  public HistoricBatchDto batchJobDefinitionId(String batchJobDefinitionId) {
    
    this.batchJobDefinitionId = batchJobDefinitionId;
    return this;
  }

   /**
   * The job definition id for the batch execution jobs of this batch.
   * @return batchJobDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The job definition id for the batch execution jobs of this batch.")

  public String getBatchJobDefinitionId() {
    return batchJobDefinitionId;
  }


  public void setBatchJobDefinitionId(String batchJobDefinitionId) {
    this.batchJobDefinitionId = batchJobDefinitionId;
  }


  public HistoricBatchDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The tenant id of the batch.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The tenant id of the batch.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public HistoricBatchDto createUserId(String createUserId) {
    
    this.createUserId = createUserId;
    return this;
  }

   /**
   * The batch creator&#39;s user id.
   * @return createUserId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The batch creator's user id.")

  public String getCreateUserId() {
    return createUserId;
  }


  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }


  public HistoricBatchDto startTime(Date startTime) {
    
    this.startTime = startTime;
    return this;
  }

   /**
   * The time the batch was started. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)
   * @return startTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time the batch was started. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)")

  public Date getStartTime() {
    return startTime;
  }


  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }


  public HistoricBatchDto endTime(Date endTime) {
    
    this.endTime = endTime;
    return this;
  }

   /**
   * The time the batch ended. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)
   * @return endTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time the batch ended. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)")

  public Date getEndTime() {
    return endTime;
  }


  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }


  public HistoricBatchDto removalTime(Date removalTime) {
    
    this.removalTime = removalTime;
    return this;
  }

   /**
   * The time after which the historic batch should be removed by the History Cleanup job. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time after which the historic batch should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`. For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)")

  public Date getRemovalTime() {
    return removalTime;
  }


  public void setRemovalTime(Date removalTime) {
    this.removalTime = removalTime;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricBatchDto historicBatchDto = (HistoricBatchDto) o;
    return Objects.equals(this.id, historicBatchDto.id) &&
        Objects.equals(this.type, historicBatchDto.type) &&
        Objects.equals(this.totalJobs, historicBatchDto.totalJobs) &&
        Objects.equals(this.batchJobsPerSeed, historicBatchDto.batchJobsPerSeed) &&
        Objects.equals(this.invocationsPerBatchJob, historicBatchDto.invocationsPerBatchJob) &&
        Objects.equals(this.seedJobDefinitionId, historicBatchDto.seedJobDefinitionId) &&
        Objects.equals(this.monitorJobDefinitionId, historicBatchDto.monitorJobDefinitionId) &&
        Objects.equals(this.batchJobDefinitionId, historicBatchDto.batchJobDefinitionId) &&
        Objects.equals(this.tenantId, historicBatchDto.tenantId) &&
        Objects.equals(this.createUserId, historicBatchDto.createUserId) &&
        Objects.equals(this.startTime, historicBatchDto.startTime) &&
        Objects.equals(this.endTime, historicBatchDto.endTime) &&
        Objects.equals(this.removalTime, historicBatchDto.removalTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, totalJobs, batchJobsPerSeed, invocationsPerBatchJob, seedJobDefinitionId, monitorJobDefinitionId, batchJobDefinitionId, tenantId, createUserId, startTime, endTime, removalTime);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricBatchDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    totalJobs: ").append(toIndentedString(totalJobs)).append("\n");
    sb.append("    batchJobsPerSeed: ").append(toIndentedString(batchJobsPerSeed)).append("\n");
    sb.append("    invocationsPerBatchJob: ").append(toIndentedString(invocationsPerBatchJob)).append("\n");
    sb.append("    seedJobDefinitionId: ").append(toIndentedString(seedJobDefinitionId)).append("\n");
    sb.append("    monitorJobDefinitionId: ").append(toIndentedString(monitorJobDefinitionId)).append("\n");
    sb.append("    batchJobDefinitionId: ").append(toIndentedString(batchJobDefinitionId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    startTime: ").append(toIndentedString(startTime)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

