/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * AuthorizationCreateDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class AuthorizationCreateDto {
  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private Integer type;

  public static final String SERIALIZED_NAME_PERMISSIONS = "permissions";
  @SerializedName(SERIALIZED_NAME_PERMISSIONS)
  private List<String> permissions = null;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private String userId;

  public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
  @SerializedName(SERIALIZED_NAME_GROUP_ID)
  private String groupId;

  public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
  @SerializedName(SERIALIZED_NAME_RESOURCE_TYPE)
  private Integer resourceType;

  public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
  @SerializedName(SERIALIZED_NAME_RESOURCE_ID)
  private String resourceId;


  public AuthorizationCreateDto type(Integer type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type of the authorization (0&#x3D;global, 1&#x3D;grant, 2&#x3D;revoke). See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the authorization (0=global, 1=grant, 2=revoke). See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service.md#authorization-type) for more information about authorization types.")

  public Integer getType() {
    return type;
  }


  public void setType(Integer type) {
    this.type = type;
  }


  public AuthorizationCreateDto permissions(List<String> permissions) {
    
    this.permissions = permissions;
    return this;
  }

  public AuthorizationCreateDto addPermissionsItem(String permissionsItem) {
    if (this.permissions == null) {
      this.permissions = new ArrayList<String>();
    }
    this.permissions.add(permissionsItem);
    return this;
  }

   /**
   * An array of Strings holding the permissions provided by this authorization.
   * @return permissions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of Strings holding the permissions provided by this authorization.")

  public List<String> getPermissions() {
    return permissions;
  }


  public void setPermissions(List<String> permissions) {
    this.permissions = permissions;
  }


  public AuthorizationCreateDto userId(String userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * The id of the user this authorization has been created for. The value &#x60;*&#x60; represents a global authorization ranging over all users.
   * @return userId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the user this authorization has been created for. The value `*` represents a global authorization ranging over all users.")

  public String getUserId() {
    return userId;
  }


  public void setUserId(String userId) {
    this.userId = userId;
  }


  public AuthorizationCreateDto groupId(String groupId) {
    
    this.groupId = groupId;
    return this;
  }

   /**
   * The id of the group this authorization has been created for.
   * @return groupId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the group this authorization has been created for.")

  public String getGroupId() {
    return groupId;
  }


  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  public AuthorizationCreateDto resourceType(Integer resourceType) {
    
    this.resourceType = resourceType;
    return this;
  }

   /**
   * An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.
   * @return resourceType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An integer representing the resource type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/authorization-service/#resources) for a list of integer representations of resource types.")

  public Integer getResourceType() {
    return resourceType;
  }


  public void setResourceType(Integer resourceType) {
    this.resourceType = resourceType;
  }


  public AuthorizationCreateDto resourceId(String resourceId) {
    
    this.resourceId = resourceId;
    return this;
  }

   /**
   * The resource Id. The value &#x60;*&#x60; represents an authorization ranging over all instances of a resource.
   * @return resourceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The resource Id. The value `*` represents an authorization ranging over all instances of a resource.")

  public String getResourceId() {
    return resourceId;
  }


  public void setResourceId(String resourceId) {
    this.resourceId = resourceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationCreateDto authorizationCreateDto = (AuthorizationCreateDto) o;
    return Objects.equals(this.type, authorizationCreateDto.type) &&
        Objects.equals(this.permissions, authorizationCreateDto.permissions) &&
        Objects.equals(this.userId, authorizationCreateDto.userId) &&
        Objects.equals(this.groupId, authorizationCreateDto.groupId) &&
        Objects.equals(this.resourceType, authorizationCreateDto.resourceType) &&
        Objects.equals(this.resourceId, authorizationCreateDto.resourceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, permissions, userId, groupId, resourceType, resourceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationCreateDto {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    resourceType: ").append(toIndentedString(resourceType)).append("\n");
    sb.append("    resourceId: ").append(toIndentedString(resourceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

