/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import java.util.Date;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceDto;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricActivityInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricActivityInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricActivityInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricActivityInstance
     * @param id The id of the historic activity instance to be retrieved. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic activity instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstanceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/activity-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricActivityInstanceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricActivityInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricActivityInstanceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get
     * Retrieves a historic activity instance by id, according to the &#x60;HistoricActivityInstance&#x60; interface in the engine.
     * @param id The id of the historic activity instance to be retrieved. (required)
     * @return HistoricActivityInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic activity instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricActivityInstanceDto getHistoricActivityInstance(String id) throws ApiException {
        ApiResponse<HistoricActivityInstanceDto> localVarResp = getHistoricActivityInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get
     * Retrieves a historic activity instance by id, according to the &#x60;HistoricActivityInstance&#x60; interface in the engine.
     * @param id The id of the historic activity instance to be retrieved. (required)
     * @return ApiResponse&lt;HistoricActivityInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic activity instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricActivityInstanceDto> getHistoricActivityInstanceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricActivityInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricActivityInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get (asynchronously)
     * Retrieves a historic activity instance by id, according to the &#x60;HistoricActivityInstance&#x60; interface in the engine.
     * @param id The id of the historic activity instance to be retrieved. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found Historic activity instance with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstanceAsync(String id, final ApiCallback<HistoricActivityInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricActivityInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricActivityInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricActivityInstances
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstancesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/activity-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (activityInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceId", activityInstanceId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (activityName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityName", activityName));
        }

        if (activityType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityType", activityType));
        }

        if (taskAssignee != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssignee", taskAssignee));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (canceled != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("canceled", canceled));
        }

        if (completeScope != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completeScope", completeScope));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricActivityInstancesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricActivityInstancesCall(sortBy, sortOrder, firstResult, maxResults, activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get List
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return List&lt;HistoricActivityInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        ApiResponse<List<HistoricActivityInstanceDto>> localVarResp = getHistoricActivityInstancesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get List
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;List&lt;HistoricActivityInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricActivityInstanceDto>> getHistoricActivityInstancesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getHistoricActivityInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, null);
        Type localVarReturnType = new TypeToken<List<HistoricActivityInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (asynchronously)
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstancesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback<List<HistoricActivityInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricActivityInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricActivityInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricActivityInstancesCount
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstancesCountCall(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/activity-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (activityInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceId", activityInstanceId));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (executionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionId", executionId));
        }

        if (activityId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityId", activityId));
        }

        if (activityName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityName", activityName));
        }

        if (activityType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityType", activityType));
        }

        if (taskAssignee != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskAssignee", taskAssignee));
        }

        if (finished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finished", finished));
        }

        if (unfinished != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unfinished", unfinished));
        }

        if (canceled != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("canceled", canceled));
        }

        if (completeScope != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("completeScope", completeScope));
        }

        if (startedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedBefore", startedBefore));
        }

        if (startedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("startedAfter", startedAfter));
        }

        if (finishedBefore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedBefore", finishedBefore));
        }

        if (finishedAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("finishedAfter", finishedAfter));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricActivityInstancesCountValidateBeforeCall(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricActivityInstancesCountCall(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, _callback);
        return localVarCall;

    }

    /**
     * Get List Count
     * Queries for the number of historic activity instances that fulfill the given parameters. Takes the same parameters as the [Get Historic Activity Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query/)  method.
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricActivityInstancesCount(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricActivityInstancesCountWithHttpInfo(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId);
        return localVarResp.getData();
    }

    /**
     * Get List Count
     * Queries for the number of historic activity instances that fulfill the given parameters. Takes the same parameters as the [Get Historic Activity Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query/)  method.
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricActivityInstancesCountWithHttpInfo(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        okhttp3.Call localVarCall = getHistoricActivityInstancesCountValidateBeforeCall(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (asynchronously)
     * Queries for the number of historic activity instances that fulfill the given parameters. Takes the same parameters as the [Get Historic Activity Instance](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query/)  method.
     * @param activityInstanceId Filter by activity instance id. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param executionId Filter by the id of the execution that executed the activity instance. (optional)
     * @param activityId Filter by the activity id (according to BPMN 2.0 XML). (optional)
     * @param activityName Filter by the activity name (according to BPMN 2.0 XML). (optional)
     * @param activityType Filter by activity type. (optional)
     * @param taskAssignee Only include activity instances that are user tasks and assigned to a given user. (optional)
     * @param finished Only include finished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param unfinished Only include unfinished activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param canceled Only include canceled activity instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param completeScope Only include activity instances which completed a scope. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; behaves the same as when the property is not set. (optional)
     * @param startedBefore Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param startedAfter Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedBefore Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param finishedAfter Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;. (optional)
     * @param tenantIdIn Filter by a comma-separated list of ids. An activity instance must have one of the given tenant ids. (optional)
     * @param withoutTenantId Only include historic activity instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricActivityInstancesCountAsync(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, Date startedBefore, Date startedAfter, Date finishedBefore, Date finishedAfter, String tenantIdIn, Boolean withoutTenantId, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricActivityInstancesCountValidateBeforeCall(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricActivityInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicActivityInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricActivityInstancesCall(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicActivityInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/activity-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricActivityInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricActivityInstancesCall(firstResult, maxResults, historicActivityInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List (POST)
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicActivityInstanceQueryDto  (optional)
     * @return List&lt;HistoricActivityInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        ApiResponse<List<HistoricActivityInstanceDto>> localVarResp = queryHistoricActivityInstancesWithHttpInfo(firstResult, maxResults, historicActivityInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List (POST)
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicActivityInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricActivityInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricActivityInstanceDto>> queryHistoricActivityInstancesWithHttpInfo(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricActivityInstancesValidateBeforeCall(firstResult, maxResults, historicActivityInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricActivityInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List (POST) (asynchronously)
     * Queries for historic activity instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Activity Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/activity-instance/get-activity-instance-query-count/) method.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicActivityInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid, for example if a sortOrder parameter is supplied, but no sortBy. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricActivityInstancesAsync(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback<List<HistoricActivityInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricActivityInstancesValidateBeforeCall(firstResult, maxResults, historicActivityInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricActivityInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricActivityInstancesCount
     * @param historicActivityInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricActivityInstancesCountCall(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicActivityInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/activity-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricActivityInstancesCountValidateBeforeCall(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricActivityInstancesCountCall(historicActivityInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get List Count (POST)
     * Queries for the number of historic activity instances that fulfill the given parameters.
     * @param historicActivityInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricActivityInstancesCountWithHttpInfo(historicActivityInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get List Count (POST)
     * Queries for the number of historic activity instances that fulfill the given parameters.
     * @param historicActivityInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricActivityInstancesCountWithHttpInfo(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricActivityInstancesCountValidateBeforeCall(historicActivityInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get List Count (POST) (asynchronously)
     * Queries for the number of historic activity instances that fulfill the given parameters.
     * @param historicActivityInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad Request Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricActivityInstancesCountAsync(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricActivityInstancesCountValidateBeforeCall(historicActivityInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
