/*
 * Decompiled with CFR 0.152.
 */
package org.cadixdev.bombe.type.reference;

import java.util.Objects;
import java.util.StringJoiner;
import org.cadixdev.bombe.type.reference.ClassReference;
import org.cadixdev.bombe.type.reference.QualifiedReference;
import org.cadixdev.bombe.type.signature.MemberSignature;

public abstract class MemberReference<S extends MemberSignature>
extends QualifiedReference {
    protected final ClassReference owningClass;
    protected final S signature;

    public MemberReference(QualifiedReference.Type type, ClassReference owningClass, S signature) {
        super(type);
        this.owningClass = owningClass;
        this.signature = signature;
    }

    public ClassReference getOwningClass() {
        return this.owningClass;
    }

    public S getSignature() {
        return this.signature;
    }

    @Override
    public String toJvmsIdentifier() {
        return this.owningClass.toJvmsIdentifier() + '.' + ((MemberSignature)this.signature).toJvmsIdentifier();
    }

    @Override
    protected StringJoiner buildToString() {
        return super.buildToString().add(";owningClass=" + this.owningClass.getClassType().getClassName()).add(";signature=" + ((MemberSignature)this.signature).toJvmsIdentifier());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MemberReference)) {
            return false;
        }
        MemberReference that = (MemberReference)obj;
        return super.equals(obj) && Objects.equals(this.owningClass, that.owningClass) && Objects.equals(this.signature, that.signature);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.owningClass, this.signature);
    }
}

