///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            console.log("ButterFaces.Overlay.constructor - creating overlay with delay is "
                + this.delay
                + ", isTransparentBlockingOverlayActive is "
                + this.isTransparentBlockingOverlayActive
                + ", selector is "
                + this.selector);
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.ObjectStatics.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        console.log("ButterFaces.Overlay.show - overlay already existing. Skip showing overlay");
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                console.log("ButterFaces.Overlay.show - appending not displayed overlay to body");
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='" + _this.calcOverlaySpinnerClass($elementToDisable) + "'></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    console.log("ButterFaces.Overlay.show - isTransparentBlockingOverlayActive is true, showing transparent overlay direcly");
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        console.log("ButterFaces.Overlay.show - deferred: isTransparentBlockingOverlayActive is false, showing transparent overlay after delay");
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        console.log("ButterFaces.Overlay.show - deferred: starting animation to make overlay intransparent");
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            console.log("ButterFaces.Overlay.show - deferred: animation ended to make overlay intransparent");
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            console.log("ButterFaces.Overlay.hide - starting animation to make overlay transparent");
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.ObjectStatics.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.prototype.calcOverlaySpinnerClass = function (element) {
            if (element.outerHeight() < 55) {
                return "butter-component-spinner tiny";
            }
            if (element.outerHeight() < 105) {
                return "butter-component-spinner small";
            }
            return "butter-component-spinner";
        };
        Overlay.hideAll = function () {
            console.log("ButterFaces.Overlay.hideAll - starting animation to make all overlays transparent");
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                console.log("ButterFaces.Overlay.hide - animation ended to make overlay transparent, OVERLAY REMOVED");
            });
        };
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
