/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.html.table;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import org.butterfaces.component.html.table.HtmlColumn;
import org.butterfaces.component.renderkit.html_basic.table.cache.TableColumnCache;
import org.butterfaces.event.TableSingleSelectionListener;
import org.butterfaces.model.table.TableColumnOrderingModel;
import org.butterfaces.model.table.TableColumnVisibilityModel;
import org.butterfaces.model.table.TableModel;
import org.butterfaces.model.table.TableRowSortingModel;
import org.butterfaces.util.StringUtils;

@ResourceDependencies(value={@ResourceDependency(library="butterfaces-dist-css", name="butterfaces-table.css", target="head"), @ResourceDependency(library="butterfaces-dist-css", name="butterfaces-overlay.css", target="head"), @ResourceDependency(library="butterfaces-dist-css", name="dist-butterfaces-bootstrap.css", target="head"), @ResourceDependency(library="butterfaces-dist-bundle-dev-js", name="butterfaces-third-party-jquery.js", target="head"), @ResourceDependency(library="butterfaces-dist-bundle-dev-js", name="butterfaces-third-party-bootstrap.js", target="head"), @ResourceDependency(library="butterfaces-dist-js", name="butterfaces-overlay.js", target="head"), @ResourceDependency(library="butterfaces-dist-js", name="butterfaces-ajax.js", target="head"), @ResourceDependency(library="butterfaces-dist-js", name="butterfaces-table.jquery.js", target="head")})
@FacesComponent(value="org.butterfaces.component.table.new")
public class HtmlTable
extends UIData
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.butterfaces.component.table.new";
    public static final String COMPONENT_FAMILY = "org.butterfaces.component.family";
    public static final String RENDERER_TYPE = "org.butterfaces.renderkit.html_basic.TableRenderer.new";
    protected static final String PROPERTY_UNIQUE_IDENTIFIER = "uniqueIdentifier";
    protected static final String PROPERTY_TABLE_CONDENSED = "tableCondensed";
    protected static final String PROPERTY_TABLE_BORDERED = "tableBordered";
    protected static final String PROPERTY_TABLE_STRIPED = "tableStriped";
    protected static final String PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST = "ajaxDisableRenderRegionsOnRequest";
    protected static final String PROPERTY_MODEL = "model";
    protected static final String PROPERTY_TABLE_ROW_CLASS = "rowClass";
    protected static final String PROPERTY_STYLE_CLASS = "styleClass";
    protected static final String PROPERTY_STYLE = "style";
    protected static final String PROPERTY_SINGLE_SELECTION_LISTENER = "singleSelectionListener";

    public HtmlTable() {
        this.setRendererType(RENDERER_TYPE);
    }

    public Collection<String> getEventNames() {
        return Arrays.asList("click");
    }

    public String getDefaultEventName() {
        return "click";
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public TableColumnCache getTableColumnCache(FacesContext context) {
        String key = this.createKey((UIComponent)this);
        Map attributes = context.getAttributes();
        TableColumnCache info = (TableColumnCache)attributes.get(key);
        if (info == null) {
            info = new TableColumnCache(this);
            attributes.put(key, info);
        }
        return info;
    }

    public void clearMetaInfo(FacesContext context, UIComponent table) {
        context.getAttributes().remove(this.createKey(table));
    }

    private String createKey(UIComponent table) {
        return TableColumnCache.KEY + '_' + table.hashCode();
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        int savedRowIndex = this.getRowIndex();
        try {
            return super.invokeOnComponent(context, clientId, callback);
        }
        catch (Exception e) {
            this.setRowIndex(savedRowIndex);
            return this.invokeOnComponentFromUIComponent(context, clientId, callback);
        }
    }

    private boolean invokeOnComponentFromUIComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        boolean found = false;
        if (clientId.equals(this.getClientId(context))) {
            try {
                this.pushComponentToEL(context, (UIComponent)this);
                callback.invokeContextCallback(context, (UIComponent)this);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                this.popComponentFromEL(context);
            }
        }
        Iterator itr = this.getFacetsAndChildren();
        while (itr.hasNext() && !found) {
            found = ((UIComponent)itr.next()).invokeOnComponent(context, clientId, callback);
        }
        return found;
    }

    public boolean isHideColumn(HtmlColumn column) {
        if (this.getTableColumnVisibilityModel() != null) {
            String tableUniqueIdentifier = this.getModelUniqueIdentifier();
            String columnUniqueIdentifier = column.getModelUniqueIdentifier();
            Boolean hideColumn = this.getTableColumnVisibilityModel().isColumnHidden(tableUniqueIdentifier, columnUniqueIdentifier);
            if (hideColumn != null) {
                return hideColumn;
            }
        }
        return column.isHideColumn();
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_STYLE_CLASS));
    }

    public void setStyleClass(String styleClass) {
        this.updateStateHelper(PROPERTY_STYLE_CLASS, styleClass);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_STYLE));
    }

    public void setStyle(String style) {
        this.updateStateHelper(PROPERTY_STYLE, style);
    }

    public String getModelUniqueIdentifier() {
        return StringUtils.getNotNullValue(this.getUniqueIdentifier(), this.getId());
    }

    public TableSingleSelectionListener getSingleSelectionListener() {
        return (TableSingleSelectionListener)this.getStateHelper().eval((Serializable)((Object)PROPERTY_SINGLE_SELECTION_LISTENER));
    }

    public void setSingleSelectionListener(TableSingleSelectionListener singleSelectionListener) {
        this.updateStateHelper(PROPERTY_SINGLE_SELECTION_LISTENER, singleSelectionListener);
    }

    public TableModel getModel() {
        return (TableModel)this.getStateHelper().eval((Serializable)((Object)PROPERTY_MODEL));
    }

    public TableRowSortingModel getTableSortModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableRowSortingModel() : null;
    }

    public TableColumnOrderingModel getTableOrderingModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableColumnOrderingModel() : null;
    }

    public TableColumnVisibilityModel getTableColumnVisibilityModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableColumnVisibilityModel() : null;
    }

    public void setModel(TableModel tableModel) {
        this.updateStateHelper(PROPERTY_MODEL, tableModel);
    }

    public String getUniqueIdentifier() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_UNIQUE_IDENTIFIER));
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.updateStateHelper(PROPERTY_UNIQUE_IDENTIFIER, uniqueIdentifier);
    }

    public boolean isTableCondensed() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_CONDENSED));
        return eval == null ? false : (Boolean)eval;
    }

    public void setTableCondensed(boolean tableCondensed) {
        this.updateStateHelper(PROPERTY_TABLE_CONDENSED, tableCondensed);
    }

    public boolean isTableBordered() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_BORDERED));
        return eval == null ? false : (Boolean)eval;
    }

    public void setTableBordered(boolean tableBordered) {
        this.updateStateHelper(PROPERTY_TABLE_BORDERED, tableBordered);
    }

    public boolean isTableStriped() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_STRIPED));
        return eval == null ? true : (Boolean)eval;
    }

    public void setTableStriped(boolean tableStriped) {
        this.updateStateHelper(PROPERTY_TABLE_STRIPED, tableStriped);
    }

    public String getRowClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_ROW_CLASS));
    }

    public void setRowClass(String rowClass) {
        this.updateStateHelper(PROPERTY_TABLE_ROW_CLASS, rowClass);
    }

    public boolean isAjaxDisableRenderRegionsOnRequest() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST));
        return eval == null ? true : (Boolean)eval;
    }

    public void setAjaxDisableRenderRegionsOnRequest(boolean ajaxDisableRenderRegionsOnRequest) {
        this.updateStateHelper(PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST, ajaxDisableRenderRegionsOnRequest);
    }

    private void updateStateHelper(String propertyName, Object value) {
        this.getStateHelper().put((Serializable)((Object)propertyName), value);
        ValueExpression ve = this.getValueExpression(propertyName);
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), value);
        }
    }
}

