/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CustomerAttributeWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAttribute;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="customer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomerWrapper
extends BaseWrapper
implements APIWrapper<Customer>,
APIUnwrapper<Customer> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String firstName;
    @XmlElement
    protected String lastName;
    @XmlElement
    protected String emailAddress;
    @XmlElement(name="customerAttribute")
    @XmlElementWrapper(name="customerAttributes")
    protected List<CustomerAttributeWrapper> customerAttributes;

    @Override
    public void wrapDetails(Customer model, HttpServletRequest request) {
        this.id = model.getId();
        this.firstName = model.getFirstName();
        this.lastName = model.getLastName();
        this.emailAddress = model.getEmailAddress();
        if (model.getCustomerAttributes() != null && !model.getCustomerAttributes().isEmpty()) {
            Map itemAttributes = model.getCustomerAttributes();
            this.customerAttributes = new ArrayList<CustomerAttributeWrapper>();
            Set keys = itemAttributes.keySet();
            for (String key : keys) {
                CustomerAttributeWrapper customerAttributeWrapper = (CustomerAttributeWrapper)this.context.getBean(CustomerAttributeWrapper.class.getName());
                customerAttributeWrapper.wrapDetails((CustomerAttribute)itemAttributes.get(key), request);
                this.customerAttributes.add(customerAttributeWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(Customer model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }

    @Override
    public Customer unwrap(HttpServletRequest request, ApplicationContext context) {
        CustomerService customerService = (CustomerService)context.getBean("blCustomerService");
        Customer customer = customerService.readCustomerById(this.id);
        customer.setId(this.id);
        customer.setFirstName(this.firstName);
        customer.setLastName(this.lastName);
        customer.setEmailAddress(this.emailAddress);
        if (this.customerAttributes != null) {
            for (CustomerAttributeWrapper customerAttributeWrapper : this.customerAttributes) {
                CustomerAttribute attribute = customerAttributeWrapper.unwrap(request, context);
                attribute.setCustomer(customer);
                customer.getCustomerAttributes().put(attribute.getName(), attribute);
            }
        }
        return customer;
    }
}

