/*
 * Decompiled with CFR 0.152.
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.File;
import java.io.FileWriter;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMSerializer;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.DOMUtils;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.FileFilterImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SystemPathUpdater {
    public static void updateProject(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        Document pom = null;
        try {
            DocumentBuilderFactoryImpl dbf = new DocumentBuilderFactoryImpl();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            pom = builder.parse(project.getFile());
        }
        catch (Exception pe) {
            throw new MojoExecutionException("Error parsing pom.", pe);
        }
        boolean modified = false;
        Element projectElement = pom.getDocumentElement();
        Element dependenciesElement = DOMUtils.getChildElement(projectElement, new QName("http://maven.apache.org/POM/4.0.0", "dependencies"));
        if (dependenciesElement != null) {
            List<Element> kids = DOMUtils.getChildElements(dependenciesElement, new QName("http://maven.apache.org/POM/4.0.0", "dependency"));
            for (Element dependencyElement : kids) {
                Element systemPathElement = DOMUtils.getChildElement(dependencyElement, new QName("http://maven.apache.org/POM/4.0.0", "systemPath"));
                if (systemPathElement == null) continue;
                Text textNode = (Text)systemPathElement.getFirstChild();
                String current = textNode.getData();
                int begin = current.indexOf("/specification-eoa-api-") + 23;
                int end = current.indexOf(".jar");
                if (begin <= -1 || end <= -1) continue;
                systemPathElement.removeChild(textNode);
                String target = current.substring(begin, end);
                if (!target.equals(fromVersion)) continue;
                String replacement = current.replace(target, toVersion);
                systemPathElement.appendChild(pom.createTextNode(replacement));
                modified = true;
            }
        }
        if (modified) {
            try {
                FileWriter fileWriter = new FileWriter(project.getFile());
                fileWriter.write(DOMSerializer.serializeNode(pom));
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception ie) {
                throw new MojoExecutionException("Error updating pom.", ie);
            }
        }
        if (!project.getArtifactId().equals("empty-project")) {
            SystemPathUpdater.updateTestPOMs(project, fromVersion, toVersion);
        }
        if (project.getArtifactId().endsWith("archetype")) {
            SystemPathUpdater.updateArchetypePOMs(project, fromVersion, toVersion);
        }
        if (project.getArtifactId().equals("alakai-standalone-assembly")) {
            SystemPathUpdater.updateSystemPOMs(project, fromVersion, toVersion);
        }
    }

    private static void updateTestPOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File[] suiteDirs;
        File baseDir = project.getFile().getParentFile();
        File testDir = new File(baseDir, "src/it/");
        if (!testDir.exists()) {
            return;
        }
        for (File suiteDir : suiteDirs = testDir.listFiles(new FileFilterImpl())) {
            if (!suiteDir.isDirectory()) continue;
            File pomFile = new File(suiteDir, "system/resources/alakai/etc/pom.xml");
            if (!pomFile.exists()) {
                throw new MojoExecutionException("Project " + project.getArtifactId() + " missing test POM " + pomFile.getAbsolutePath());
            }
            MavenProject temp = new MavenProject();
            temp.setFile(pomFile);
            SystemPathUpdater.updateProject(temp, fromVersion, toVersion);
        }
    }

    private static void updateSystemPOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File[] systemInstanceDirs;
        File baseDir = project.getFile().getParentFile();
        File systemDir = new File(baseDir, "src/main/assembly/system/");
        if (!systemDir.exists()) {
            throw new MojoExecutionException("Project alakai-standalone-assembly missing subdirectory " + systemDir.getAbsolutePath());
        }
        for (File systemInstanceDir : systemInstanceDirs = systemDir.listFiles(new FileFilterImpl())) {
            if (!systemInstanceDir.isDirectory()) continue;
            SystemPathUpdater.recurseDirectory(systemInstanceDir, fromVersion, toVersion);
        }
    }

    private static void updateArchetypePOMs(MavenProject project, String fromVersion, String toVersion) throws MojoExecutionException {
        File baseDir = project.getFile().getParentFile();
        File pomFile = new File(baseDir, "src/main/resources/pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Archetype project missing file " + pomFile.getAbsolutePath());
        }
        MavenProject temp = new MavenProject();
        temp.setFile(pomFile);
        SystemPathUpdater.updateProject(temp, fromVersion, toVersion);
        pomFile = new File(baseDir, "src/main/resources/src/it/suite1/system/resources/alakai/etc/pom.xml");
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Archetype project missing file " + pomFile.getAbsolutePath());
        }
        temp = new MavenProject();
        temp.setFile(pomFile);
        SystemPathUpdater.updateProject(temp, fromVersion, toVersion);
    }

    private static void recurseDirectory(File systemInstanceDir, String fromVersion, String toVersion) throws MojoExecutionException {
        for (String name : systemInstanceDir.list()) {
            File f = new File(systemInstanceDir, name);
            if (!f.isDirectory()) continue;
            if (name.equals("etc")) {
                File pomFile = new File(systemInstanceDir, "etc/pom.xml");
                if (!pomFile.exists()) {
                    throw new MojoExecutionException("Project alakai-standalone-assembly missing system POM " + pomFile.getAbsolutePath());
                }
                MavenProject temp = new MavenProject();
                temp.setFile(pomFile);
                SystemPathUpdater.updateProject(temp, fromVersion, toVersion);
                continue;
            }
            SystemPathUpdater.recurseDirectory(f, fromVersion, toVersion);
        }
    }
}

