/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.FileWriter;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/**
 * Updates the scm url from/to trunk from/to a specific tagged version.
 */
public class SCMUrlUpdater {

    public static void updateProject(MavenProject project, String toVersion) throws MojoExecutionException {

        // we force the xerces impl. the default impl returned by new instance
        // method performed a four space indent rather than a two space indent

        Document pom = null;
        try {
            DocumentBuilderFactory dbf = new DocumentBuilderFactoryImpl();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            pom = builder.parse(project.getFile());
        } catch (Exception pe) {
            throw new MojoExecutionException("Error parsing pom.", pe);
        }

        boolean modified = false;

        Element projectElement = pom.getDocumentElement();

        Element scmElement = DOMUtils.getChildElement(projectElement, new QName(Constants.POM_TNS, "scm"));

        if (scmElement != null) {

            Element ce = DOMUtils.getChildElement(scmElement, new QName(Constants.POM_TNS, "connection"));
            if (ce != null) {
                Text textNode = (Text)ce.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    int index = data.indexOf("tags");
                    if (index > -1) {
                        String url = data.substring(0, index) + "trunk";
                        ce.removeChild(textNode);
                        ce.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    int index = data.indexOf("trunk");
                    if (index > -1) {
                        String url = data.substring(0, index) + "tags/" + toVersion;
                        ce.removeChild(textNode);
                        ce.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }

            Element de = DOMUtils.getChildElement(scmElement, new QName(Constants.POM_TNS, "developerConnection"));
            if (de != null) {
                Text textNode = (Text)de.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    int index = data.indexOf("tags");
                    if (index > -1) {
                        String url = data.substring(0, index) + "trunk";
                        de.removeChild(textNode);
                        de.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    int index = data.indexOf("trunk");
                    if (index > -1) {
                        String url = data.substring(0, index) + "tags/" + toVersion;
                        de.removeChild(textNode);
                        de.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }

            Element ue = DOMUtils.getChildElement(scmElement, new QName(Constants.POM_TNS, "url"));
            if (ue != null) {
                Text textNode = (Text)ue.getFirstChild();
                String data = textNode.getData();
                if (toVersion.equals("SNAPSHOT")) {
                    int index = data.indexOf("tags");
                    if (index > -1) {
                        String url = data.substring(0, index) + "trunk";
                        ue.removeChild(textNode);
                        ue.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                } else {
                    int index = data.indexOf("trunk");
                    if (index > -1) {
                        String url = data.substring(0, index) + "tags/" + toVersion;
                        ue.removeChild(textNode);
                        ue.appendChild(pom.createTextNode(url));
                        modified = true;
                    }
                }
            }

            if (modified) {
                try {
                    FileWriter fileWriter = new FileWriter(project.getFile());
                    fileWriter.write(DOMSerializer.serializeNode(pom));
                    fileWriter.flush();
                    fileWriter.close();
                } catch (Exception ie) {
                    throw new MojoExecutionException("Error updating pom.", ie);
                }
            }

        }

    }

}
