/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.maven.plugin.MojoExecutionException;

public class FileUtils {
  
    public static File copyDir(File source, File target) throws MojoExecutionException {

        target.mkdir();

        File[] entries = source.listFiles(new FileFilterImpl());

        for (int i = 0; i < entries.length; i++) {
            File entry = entries[i];
            File file = new File(target, File.separator + entry.getName());
            if (entry.isDirectory()) {
                copyDir(entry, file);
            } else {
                InputStream in = null;
                OutputStream out = null;
                try {
                    in = new FileInputStream(entry);
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    byte[] buffer = new byte[4096];
                    for (int length = 0; length >= 0; length = in.read(buffer)) {
                        out.write(buffer, 0, length);
                    }
                } catch (Exception ex) {
                    throw new MojoExecutionException("Error copying directory. " + ex);
                } finally {
                    if (in != null) {
                        try {
                            in.close();
                        } catch (IOException ignore) {
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        } catch (IOException ignore) {
                        }
                    }
                }
            }
        }

        return target;

    }

    public static void removeDir(File target) throws Exception {
        File[] entries = target.listFiles();
        if (entries == null) {
            return;
        }
        for (int i = 0; i < entries.length; i++) {
            File entry = entries[i];
            if (entry.isDirectory()) {
                removeDir(entry);
            } else {
                entry.delete();
            }
        }
        target.delete();
    }

    public static void copyFile(File source, File target) throws MojoExecutionException {
        InputStream in = null;
        OutputStream out = null;
        try {
            if (target.getParentFile() != null) {
                target.getParentFile().mkdirs();
            }
            in = new FileInputStream(source);
            out = new BufferedOutputStream(new FileOutputStream(target));
            byte[] buffer = new byte[4096];
            for (int length = 0; length >= 0; length = in.read(buffer)) {
                out.write(buffer, 0, length);
            }
        } catch (Exception ex) {
            throw new MojoExecutionException("Error copying file. " + ex);
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException ignore) {
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException ignore) {
                }
            }
        }
    }

}
