/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.importer.listener;

import java.io.Serializable;
import org.beangle.commons.bean.Properties$;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.dao.EntityDao;
import org.beangle.data.dao.OqlBuilder;
import org.beangle.data.dao.OqlBuilder$;
import org.beangle.data.dao.QueryBuilder;
import org.beangle.data.model.Entity;
import org.beangle.data.model.meta.EntityType;
import org.beangle.data.transfer.importer.ImportListener;
import org.beangle.data.transfer.importer.ImportResult;
import org.beangle.data.transfer.importer.Importer;
import org.beangle.data.transfer.importer.MultiEntityImporter;
import org.beangle.data.transfer.importer.listener.ForeignerListener$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ForeignerListener
implements ImportListener {
    private Importer transfer;
    private final EntityDao entityDao;
    private final HashMap foreignersMap;
    private final ListBuffer<String> foreignerKeys;
    private boolean multiEntity;
    private scala.collection.immutable.Set<String> aliases;
    private final Set<String> ignores;
    private scala.collection.immutable.Set<String> keyAttrs;

    public static int CACHE_SIZE() {
        return ForeignerListener$.MODULE$.CACHE_SIZE();
    }

    public ForeignerListener(EntityDao entityDao) {
        this.entityDao = entityDao;
        ImportListener.$init$(this);
        this.foreignersMap = new HashMap();
        this.foreignerKeys = new ListBuffer();
        this.foreignerKeys.$plus$eq((Object)"code");
        this.multiEntity = false;
        this.aliases = Predef$.MODULE$.Set().empty();
        this.ignores = Collections$.MODULE$.newSet();
    }

    @Override
    public Importer transfer() {
        return this.transfer;
    }

    @Override
    public void transfer_$eq(Importer x$1) {
        this.transfer = x$1;
    }

    public HashMap<String, HashMap<String, Object>> foreignersMap() {
        return this.foreignersMap;
    }

    @Override
    public void onStart(ImportResult tr) {
        Importer importer = this.transfer();
        if (importer instanceof MultiEntityImporter) {
            MultiEntityImporter mei = (MultiEntityImporter)importer;
            this.multiEntity = true;
            this.aliases = mei.aliases().toSet();
        } else {
            this.multiEntity = false;
        }
        Set keyNames = Collections$.MODULE$.newSet();
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.transfer().attrs());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)attr -> {
            boolean isForeigner;
            String attrName = attr.name();
            if (!this.ignores.contains((Object)attrName) && (isForeigner = this.foreignerKeys.exists((Function1 & Serializable)fk -> {
                boolean endWithKey = attrName.endsWith("." + fk) && Strings$.MODULE$.count(attrName, '.') >= 2;
                return endWithKey ? this.aliases.contains((Object)Strings$.MODULE$.substringBefore(attrName, ".")) : false;
            }))) {
                keyNames.$plus$eq((Object)attrName);
            }
        });
        this.keyAttrs = keyNames.toSet();
    }

    @Override
    public void onItemFinish(ImportResult tr) {
        for (String attri : this.keyAttrs) {
            Object object;
            String codeStr = (String)this.transfer().curData().apply((Object)attri);
            Object foreigner = null;
            if (!Strings$.MODULE$.isNotEmpty((CharSequence)codeStr)) continue;
            String codeValue = codeStr.contains(" ") ? Strings$.MODULE$.substringBefore(codeStr, " ") : codeStr;
            Object entity = null;
            if (this.multiEntity) {
                String shortName = Strings$.MODULE$.substringBefore(attri, ".");
                entity = ((MultiEntityImporter)this.transfer()).getCurrent(shortName);
            } else {
                entity = this.transfer().current();
            }
            String attr = Strings$.MODULE$.substringAfter(attri, ".");
            Object nestedForeigner = Properties$.MODULE$.get(entity, Strings$.MODULE$.substring(attr, 0, attr.lastIndexOf(".")));
            if (nestedForeigner instanceof Option) {
                nestedForeigner = ((Option)nestedForeigner).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if ((object = nestedForeigner) instanceof Entity) {
                String className = nestedForeigner.getClass().getName();
                HashMap foreignerMap = (HashMap)this.foreignersMap().getOrElseUpdate((Object)className, ForeignerListener::$anonfun$2);
                if (foreignerMap.size() > ForeignerListener$.MODULE$.CACHE_SIZE()) {
                    foreignerMap.clear();
                }
                if ((foreigner = foreignerMap.get((Object)codeValue).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())) == null) {
                    Class<?> clazz = nestedForeigner.getClass();
                    OqlBuilder query = OqlBuilder$.MODULE$.from(clazz, "f");
                    query.where(((IterableOnceOps)this.foreignerKeys.map((Function1 & Serializable)k -> "f." + k + " = :fk_value")).mkString(" or "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{codeValue}));
                    Seq foreigners = this.entityDao.search((QueryBuilder)query);
                    if (foreigners.nonEmpty()) {
                        foreigner = foreigners.head();
                        foreignerMap.put((Object)codeValue, foreigner);
                    } else {
                        tr.addFailure(this.transfer().description(attri) + "\u4ee3\u7801\u4e0d\u5b58\u5728", codeValue);
                    }
                }
            }
            String parentAttr = Strings$.MODULE$.substring(attr, 0, attr.lastIndexOf("."));
            MultiEntityImporter entityImporter = (MultiEntityImporter)this.transfer();
            entityImporter.populator().populate((Entity)entity, (EntityType)entityImporter.domain().getEntity(entity.getClass()).get(), parentAttr, foreigner);
        }
    }

    public void addForeigerKey(String key) {
        this.foreignerKeys.$plus$eq((Object)key);
    }

    public void ignore(Seq<String> names) {
        this.ignores.$plus$plus$eq(names);
    }

    private static final HashMap $anonfun$2() {
        return new HashMap();
    }
}

