/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.io.OutputStream;
import java.io.Serializable;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.beangle.commons.collection.Collections$;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.transfer.excel.Constraints$;
import org.beangle.data.transfer.excel.ExcelColumn;
import org.beangle.data.transfer.excel.ExcelSchema;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.runtime.BooleanRef;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class ExcelSchemaWriter$
implements Serializable {
    public static final ExcelSchemaWriter$ MODULE$ = new ExcelSchemaWriter$();

    private ExcelSchemaWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExcelSchemaWriter$.class);
    }

    public void generate(ExcelSchema schema, OutputStream os) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        schema.sheets().foreach((Function1)(JProcedure1 & Serializable)esheet -> {
            XSSFSheet sheet = workbook.createSheet(esheet.name());
            sheet.setDefaultColumnWidth(15);
            IntRef rowIdx = IntRef.create((int)0);
            esheet.title().foreach((Function1)(JProcedure1 & Serializable)title -> {
                int n;
                Cell cell = this.writeRow((Sheet)sheet, (String)title, rowIdx$1.elem, esheet.columns().size());
                cell.getRow().setHeightInPoints(15.0f);
                cell.setCellStyle(this.getTitleStyle((Workbook)workbook));
                rowIdx$1.elem = n = rowIdx$1.elem + 1;
            });
            esheet.remark().foreach((Function1)(JProcedure1 & Serializable)remark -> {
                int n;
                Cell cell = this.writeRow((Sheet)sheet, (String)remark, rowIdx$2.elem, esheet.columns().size());
                cell.setCellStyle(this.getRemarkStyle((Workbook)workbook));
                rowIdx$2.elem = n = rowIdx$2.elem + 1;
            });
            boolean existsColumnRemark = esheet.columns().exists((Function1 & Serializable)_$1 -> _$1.remark().nonEmpty());
            if (existsColumnRemark) {
                int n;
                XSSFRow remarkRow = sheet.createRow(rowIdx.elem);
                CellStyle remarkStyle = this.getColumnRemarkStyle((Workbook)workbook);
                rowIdx.elem = n = rowIdx.elem + 1;
                esheet.columns().indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    ExcelColumn col = (ExcelColumn)esheet.columns().apply(i);
                    Cell cell = this.writeColumnRemark((Sheet)sheet, (String)col.remark().getOrElse(this::$anonfun$3), (Row)remarkRow, i);
                    cell.setCellStyle(remarkStyle);
                });
            }
            Map defaultStyles = Collections$.MODULE$.newMap();
            XSSFRow columnRow = sheet.createRow(rowIdx.elem);
            CellStyle optionalStyle = this.getColumnTitleStyle((Workbook)workbook, false);
            CellStyle requiredStyle = this.getColumnTitleStyle((Workbook)workbook, true);
            XSSFDrawing drawing = sheet.createDrawingPatriarch();
            XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
            esheet.columns().indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)curColumnIdx -> {
                ExcelColumn col = (ExcelColumn)esheet.columns().apply(curColumnIdx);
                Cell cell = this.writeColumn((Sheet)sheet, col.name(), (Row)columnRow, curColumnIdx, col.required());
                col.comment().foreach((Function1)(JProcedure1 & Serializable)c -> {
                    XSSFComment comment = drawing.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, curColumnIdx, rowIdx$4.elem, curColumnIdx, rowIdx$4.elem));
                    comment.setString((RichTextString)new XSSFRichTextString(c + ":" + col.dataType()));
                    cell.setCellComment((Comment)comment);
                    comment.setVisible(false);
                });
                if (col.required()) {
                    cell.setCellStyle(requiredStyle);
                } else {
                    cell.setCellStyle(optionalStyle);
                }
                if (col.datas() == null) {
                    if (col.isInt()) {
                        sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 1, rowIdx$3.elem + 1, curColumnIdx));
                        this.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().getOrElse(this::generate$$anonfun$6$$anonfun$5$$anonfun$2));
                    } else if (col.isDecimal()) {
                        sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 2, rowIdx$3.elem + 1, curColumnIdx));
                        this.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().getOrElse(this::generate$$anonfun$7$$anonfun$6$$anonfun$3));
                    } else if (col.isDate()) {
                        sheet.addValidationData(Constraints$.MODULE$.asDate(dvHelper, col, rowIdx$3.elem + 1, curColumnIdx));
                        this.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, (String)col.format().get());
                    } else if (col.length().nonEmpty()) {
                        String string = col.formular1();
                        String string2 = "0";
                        if (!(string != null ? !string.equals(string2) : string2 != null) && col.required()) {
                            col.formular1_$eq("1");
                        }
                        if (col.unique()) {
                            sheet.addValidationData(Constraints$.MODULE$.asUnique(dvHelper, col, rowIdx$3.elem + 1, curColumnIdx));
                        } else {
                            sheet.addValidationData(Constraints$.MODULE$.asNumeric(dvHelper, col, 6, rowIdx$3.elem + 1, curColumnIdx));
                        }
                        this.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, "@");
                    } else if (col.isBool()) {
                        sheet.addValidationData(Constraints$.MODULE$.asBoolean(dvHelper, col, rowIdx$3.elem + 1, curColumnIdx));
                    } else if (col.refs() != null && col.refs().nonEmpty()) {
                        this.addRefValidation(schema, (Sheet)sheet, dvHelper, col, rowIdx$3.elem + 1, curColumnIdx);
                        this.setDefaultStyle((Sheet)sheet, (Map<String, CellStyle>)defaultStyles, curColumnIdx, "@");
                    }
                } else {
                    IntRef dIdx = IntRef.create((int)1);
                    col.datas().foreach((Function1)(JProcedure1 & Serializable)data -> {
                        int n;
                        XSSFRow dataRow = sheet.getRow(dIdx$1.elem + rowIdx$5.elem);
                        if (dataRow == null) {
                            dataRow = sheet.createRow(dIdx$1.elem + rowIdx$5.elem);
                        }
                        dIdx$1.elem = n = dIdx$1.elem + 1;
                        dataRow.createCell(curColumnIdx).setCellValue(data);
                    });
                }
            });
        });
        workbook.write(os);
        os.close();
    }

    private void setDefaultStyle(Sheet sheet, Map<String, CellStyle> defaults, int columnIdx, String format) {
        CellStyle style = (CellStyle)defaults.getOrElseUpdate((Object)format, () -> this.$anonfun$1(sheet, format));
        sheet.setDefaultColumnStyle(columnIdx, style);
    }

    private boolean addRefValidation(ExcelSchema schema, Sheet sheet, XSSFDataValidationHelper helper, ExcelColumn col, int startRowIdx, int columnIdx) {
        BooleanRef finded = BooleanRef.create((boolean)false);
        schema.sheets().find((Function1 & Serializable)_$2 -> {
            String string = _$2.name();
            String string2 = sheet.getSheetName();
            return string == null ? string2 != null : !string.equals(string2);
        }).foreach((Function1)(JProcedure1 & Serializable)codeSheet -> {
            IntRef codeColIdx = IntRef.create((int)65);
            codeSheet.columns().withFilter((Function1 & Serializable)c -> !finded$2.elem).foreach((Function1)(JProcedure1 & Serializable)c -> {
                int n;
                Seq<String> seq = c.datas();
                Seq<String> seq2 = col.refs();
                if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
                    boolean bl;
                    finded$3.elem = bl = true;
                }
                codeColIdx$1.elem = n = codeColIdx$1.elem + 1;
            });
            if (finded$1.elem) {
                char refColumn = (char)(codeColIdx.elem - 1);
                String formular = codeSheet.name() + "!$" + refColumn + "$2:$" + refColumn + "$" + (col.refs().size() + 1);
                DataValidation validation = Constraints$.MODULE$.asFormular(helper, formular, col, startRowIdx, columnIdx, "\u8bf7\u9009\u62e9\u5408\u9002\u7684" + col.name());
                sheet.addValidationData(validation);
            }
        });
        return finded.elem;
    }

    private Cell writeColumnRemark(Sheet sheet, String content, Row row, int columnIdx) {
        float newHeight;
        Cell cell = row.createCell(columnIdx);
        int newLines = Strings$.MODULE$.count(content.trim(), "\n");
        if (newLines > 0 && (newHeight = (float)(newLines + 1) * sheet.getDefaultRowHeightInPoints()) > row.getHeightInPoints()) {
            row.setHeightInPoints(newHeight);
        }
        cell.setCellValue(content);
        return cell;
    }

    private Cell writeColumn(Sheet sheet, String content, Row row, int columnIdx, boolean required) {
        Cell cell = row.createCell(columnIdx);
        if (required) {
            cell.setCellValue("*" + content);
        } else {
            cell.setCellValue(content);
        }
        return cell;
    }

    private Cell writeRow(Sheet sheet, String content, int rowIdx, int colSpan) {
        CellRangeAddress mergedRegion = new CellRangeAddress(rowIdx, rowIdx, 0, colSpan - 1);
        sheet.addMergedRegion(mergedRegion);
        Row row = sheet.createRow(rowIdx);
        Cell cell = row.createCell(0);
        int newLines = Strings$.MODULE$.count(content.trim(), "\n");
        if (newLines > 0) {
            row.setHeightInPoints((float)(newLines + 1) * sheet.getDefaultRowHeightInPoints());
        }
        cell.setCellValue(content);
        return cell;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getRemarkStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.LEFT);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getTitleStyle(Workbook wb) {
        void var2_2;
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        Font font = wb.createFont();
        font.setFontHeightInPoints((short)15);
        font.setFontName("\u5b8b\u4f53");
        font.setItalic(false);
        font.setBold(true);
        style.setFont(font);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getColumnRemarkStyle(Workbook wb) {
        void var2_2;
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setWrapText(true);
        style.setFillForegroundColor(IndexedColors.AUTOMATIC.index);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private CellStyle getColumnTitleStyle(Workbook wb, boolean required) {
        void var3_3;
        XSSFCellStyle style = (XSSFCellStyle)wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        byte[] rgb = new byte[]{(byte)221, (byte)217, (byte)196};
        style.setFillForegroundColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setBold(true);
        if (required) {
            font.setColor(IndexedColors.RED.index);
        }
        style.setFont((Font)font);
        return var3_3;
    }

    private final String $anonfun$3() {
        return "";
    }

    private final String generate$$anonfun$6$$anonfun$5$$anonfun$2() {
        return "0";
    }

    private final String generate$$anonfun$7$$anonfun$6$$anonfun$3() {
        return "General";
    }

    /*
     * WARNING - void declaration
     */
    private final CellStyle $anonfun$1(Sheet sheet$6, String format$1) {
        void var3_3;
        CellStyle s = sheet$6.getWorkbook().createCellStyle();
        DataFormat df = sheet$6.getWorkbook().createDataFormat();
        s.setDataFormat(df.getFormat(format$1));
        return var3_3;
    }
}

