/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.transfer.excel;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.beangle.commons.lang.Numbers$;
import org.beangle.data.transfer.excel.ExcelStyleRegistry$;
import org.beangle.data.transfer.io.DataType;
import org.beangle.data.transfer.io.DataType$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class ExcelColumn {
    private String name;
    private Option comment;
    private Option remark;
    private DataType dataType;
    private boolean isDate;
    private boolean isInt;
    private boolean isDecimal;
    private boolean isBool;
    private Seq refs;
    private Seq datas;
    private String formular1;
    private Option formular2;
    private Option length;
    private boolean required;
    private boolean unique;
    private Option format;

    public ExcelColumn(String name) {
        this.name = name;
        this.comment = None$.MODULE$;
        this.remark = None$.MODULE$;
        this.dataType = DataType$.String;
        this.formular2 = None$.MODULE$;
        this.length = None$.MODULE$;
        this.format = None$.MODULE$;
    }

    public String name() {
        return this.name;
    }

    public void name_$eq(String x$1) {
        this.name = x$1;
    }

    public Option<String> comment() {
        return this.comment;
    }

    public void comment_$eq(Option<String> x$1) {
        this.comment = x$1;
    }

    public Option<String> remark() {
        return this.remark;
    }

    public void remark_$eq(Option<String> x$1) {
        this.remark = x$1;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public void dataType_$eq(DataType x$1) {
        this.dataType = x$1;
    }

    public boolean isDate() {
        return this.isDate;
    }

    public void isDate_$eq(boolean x$1) {
        this.isDate = x$1;
    }

    public boolean isInt() {
        return this.isInt;
    }

    public void isInt_$eq(boolean x$1) {
        this.isInt = x$1;
    }

    public boolean isDecimal() {
        return this.isDecimal;
    }

    public void isDecimal_$eq(boolean x$1) {
        this.isDecimal = x$1;
    }

    public boolean isBool() {
        return this.isBool;
    }

    public void isBool_$eq(boolean x$1) {
        this.isBool = x$1;
    }

    public Seq<String> refs() {
        return this.refs;
    }

    public void refs_$eq(Seq<String> x$1) {
        this.refs = x$1;
    }

    public Seq<String> datas() {
        return this.datas;
    }

    public void datas_$eq(Seq<String> x$1) {
        this.datas = x$1;
    }

    public String formular1() {
        return this.formular1;
    }

    public void formular1_$eq(String x$1) {
        this.formular1 = x$1;
    }

    public Option<String> formular2() {
        return this.formular2;
    }

    public void formular2_$eq(Option<String> x$1) {
        this.formular2 = x$1;
    }

    public Option<Object> length() {
        return this.length;
    }

    public void length_$eq(Option<Object> x$1) {
        this.length = x$1;
    }

    public boolean required() {
        return this.required;
    }

    public void required_$eq(boolean x$1) {
        this.required = x$1;
    }

    public boolean unique() {
        return this.unique;
    }

    public void unique_$eq(boolean x$1) {
        this.unique = x$1;
    }

    public Option<String> format() {
        return this.format;
    }

    public void format_$eq(Option<String> x$1) {
        this.format = x$1;
    }

    public ExcelColumn format(String f) {
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        return this;
    }

    public ExcelColumn remark(String r) {
        this.remark_$eq((Option<String>)Some$.MODULE$.apply((Object)r));
        return this;
    }

    public ExcelColumn unique(boolean nv) {
        this.unique_$eq(nv);
        return this;
    }

    public boolean unique$default$1() {
        return true;
    }

    public ExcelColumn required(boolean r) {
        this.required_$eq(r);
        return this;
    }

    public boolean required$default$1() {
        return true;
    }

    public ExcelColumn date(String f) {
        this.isDate_$eq(true);
        this.dataType_$eq(DataType$.Date);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        LocalDate start = LocalDate.of(1900, 1, 1);
        this.formular1_$eq(start.format(DateTimeFormatter.ofPattern(f)));
        return this;
    }

    public String date$default$1() {
        return "YYYY-MM-DD";
    }

    public ExcelColumn min(Object formular) {
        this.formular1_$eq(formular.toString());
        return this;
    }

    public ExcelColumn max(Object formular) {
        this.length_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Numbers$.MODULE$.toInt(formular.toString(), Numbers$.MODULE$.toInt$default$2()))));
        if (this.formular1() == null) {
            this.formular1_$eq("0");
        }
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)formular.toString()));
        return this;
    }

    public ExcelColumn length(int max) {
        this.length_$eq((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max)));
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"@"));
        if (this.formular1() == null) {
            this.formular1_$eq("0");
        }
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max).toString()));
        return this;
    }

    public ExcelColumn decimal(String f) {
        this.isDecimal_$eq(true);
        this.dataType_$eq(DataType$.Double);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        this.formular1_$eq("0");
        return this;
    }

    public String decimal$default$1() {
        return "0.##";
    }

    public ExcelColumn decimal(float min, float max) {
        this.isDecimal_$eq(true);
        this.dataType_$eq(DataType$.Double);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"0.##"));
        if (!(max >= min)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.formular1_$eq(BoxesRunTime.boxToFloat((float)min).toString());
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)max).toString()));
        return this;
    }

    public ExcelColumn bool() {
        this.isBool_$eq(true);
        this.dataType_$eq(DataType$.Boolean);
        return this;
    }

    public ExcelColumn integer(String f) {
        this.isInt_$eq(true);
        this.dataType_$eq(DataType$.Integer);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)f));
        this.formular1_$eq("0");
        return this;
    }

    public String integer$default$1() {
        return "0";
    }

    public ExcelColumn integer(int min, int max) {
        this.isInt_$eq(true);
        this.dataType_$eq(DataType$.Integer);
        this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)"0"));
        if (max < min) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.formular1_$eq(BoxesRunTime.boxToInteger((int)min).toString());
        this.formular2_$eq((Option<String>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max).toString()));
        return this;
    }

    public ExcelColumn ref(Seq<String> data) {
        this.refs_$eq(data);
        return this;
    }

    public ExcelColumn data(Seq<String> data) {
        this.datas_$eq(data);
        return this;
    }

    public ExcelColumn asType(Class<?> clazz) {
        return this.asType(DataType$.MODULE$.toType(clazz));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExcelColumn asType(DataType dt) {
        block25: {
            DataType dataType;
            block32: {
                DataType dataType2;
                DataType dataType3;
                block31: {
                    block30: {
                        DataType dataType4;
                        DataType dataType5;
                        block29: {
                            block28: {
                                DataType dataType6;
                                DataType dataType7;
                                block27: {
                                    block26: {
                                        DataType dataType8;
                                        DataType dataType9;
                                        block24: {
                                            block23: {
                                                block20: {
                                                    DataType dataType10;
                                                    DataType dataType11;
                                                    block22: {
                                                        block21: {
                                                            DataType dataType12;
                                                            DataType dataType13;
                                                            block19: {
                                                                block18: {
                                                                    block13: {
                                                                        DataType dataType14;
                                                                        DataType dataType15;
                                                                        block17: {
                                                                            block16: {
                                                                                DataType dataType16;
                                                                                DataType dataType17;
                                                                                block15: {
                                                                                    block14: {
                                                                                        DataType dataType18;
                                                                                        DataType dataType19;
                                                                                        block12: {
                                                                                            this.dataType_$eq(dt);
                                                                                            this.format_$eq((Option<String>)Some$.MODULE$.apply((Object)ExcelStyleRegistry$.MODULE$.defaultFormat(this.dataType())));
                                                                                            dataType = dt;
                                                                                            DataType dataType20 = DataType$.Boolean;
                                                                                            DataType dataType21 = dataType;
                                                                                            if (!(dataType20 != null ? !dataType20.equals(dataType21) : dataType21 != null)) {
                                                                                                this.isBool_$eq(true);
                                                                                                return this;
                                                                                            }
                                                                                            dataType19 = DataType$.Short;
                                                                                            dataType18 = dataType;
                                                                                            if (dataType19 != null) break block12;
                                                                                            if (dataType18 == null) break block13;
                                                                                            break block14;
                                                                                        }
                                                                                        if (dataType19.equals(dataType18)) break block13;
                                                                                    }
                                                                                    dataType17 = DataType$.Integer;
                                                                                    dataType16 = dataType;
                                                                                    if (dataType17 != null) break block15;
                                                                                    if (dataType16 == null) break block13;
                                                                                    break block16;
                                                                                }
                                                                                if (dataType17.equals(dataType16)) break block13;
                                                                            }
                                                                            dataType15 = DataType$.Long;
                                                                            dataType14 = dataType;
                                                                            if (dataType15 != null) break block17;
                                                                            if (dataType14 == null) break block13;
                                                                            break block18;
                                                                        }
                                                                        if (!dataType15.equals(dataType14)) break block18;
                                                                    }
                                                                    this.isInt_$eq(true);
                                                                    this.formular1_$eq("0");
                                                                    return this;
                                                                }
                                                                dataType13 = DataType$.Float;
                                                                dataType12 = dataType;
                                                                if (dataType13 != null) break block19;
                                                                if (dataType12 == null) break block20;
                                                                break block21;
                                                            }
                                                            if (dataType13.equals(dataType12)) break block20;
                                                        }
                                                        dataType11 = DataType$.Double;
                                                        dataType10 = dataType;
                                                        if (dataType11 != null) break block22;
                                                        if (dataType10 == null) break block20;
                                                        break block23;
                                                    }
                                                    if (!dataType11.equals(dataType10)) break block23;
                                                }
                                                this.isDecimal_$eq(true);
                                                this.formular1_$eq("0");
                                                return this;
                                            }
                                            dataType9 = DataType$.Date;
                                            dataType8 = dataType;
                                            if (dataType9 != null) break block24;
                                            if (dataType8 == null) break block25;
                                            break block26;
                                        }
                                        if (dataType9.equals(dataType8)) break block25;
                                    }
                                    dataType7 = DataType$.DateTime;
                                    dataType6 = dataType;
                                    if (dataType7 != null) break block27;
                                    if (dataType6 == null) break block25;
                                    break block28;
                                }
                                if (dataType7.equals(dataType6)) break block25;
                            }
                            dataType5 = DataType$.Time;
                            dataType4 = dataType;
                            if (dataType5 != null) break block29;
                            if (dataType4 == null) break block25;
                            break block30;
                        }
                        if (dataType5.equals(dataType4)) break block25;
                    }
                    dataType3 = DataType$.YearMonth;
                    dataType2 = dataType;
                    if (dataType3 != null) break block31;
                    if (dataType2 == null) break block25;
                    break block32;
                }
                if (dataType3.equals(dataType2)) break block25;
            }
            DataType dataType22 = DataType$.MonthDay;
            DataType dataType23 = dataType;
            if (dataType22 == null) {
                if (dataType23 != null) {
                    throw new MatchError((Object)dataType);
                }
            } else if (!dataType22.equals(dataType23)) throw new MatchError((Object)dataType);
        }
        this.isDate_$eq(true);
        LocalDate start = LocalDate.of(1900, 1, 1);
        this.formular1_$eq(start.format(DateTimeFormatter.ofPattern((String)this.format().get())));
        return this;
    }
}

