/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.query;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import org.beangle.commons.io.IOs$;
import org.beangle.commons.logging.Logger$;
import org.beangle.commons.logging.Logging;
import org.slf4j.Logger;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;

public final class ParamSetter$
implements Logging,
Serializable {
    private static Logger logger;
    public static final ParamSetter$ MODULE$;

    private ParamSetter$() {
    }

    static {
        MODULE$ = new ParamSetter$();
        Logging.$init$((Logging)MODULE$);
        Statics.releaseFence();
    }

    public Logger logger() {
        return logger;
    }

    public void org$beangle$commons$logging$Logging$_setter_$logger_$eq(Logger x$0) {
        logger = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ParamSetter$.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParam(PreparedStatement stmt, int index, Object value2, int sqltype) {
        try {
            int n = sqltype;
            switch (n) {
                case 1: 
                case 12: {
                    stmt.setString(index, (String)value2);
                    return;
                }
                case -1: {
                    stmt.setCharacterStream(index, new StringReader((String)value2));
                    return;
                }
                case -7: 
                case 16: {
                    Object object = value2;
                    if (object instanceof Boolean) {
                        boolean b = BoxesRunTime.unboxToBoolean((Object)object);
                        stmt.setBoolean(index, b);
                        return;
                    }
                    if (!(object instanceof Number)) throw new MatchError(object);
                    Number i = (Number)object;
                    stmt.setBoolean(index, i.intValue() > 0);
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger$.MODULE$.error$extension(this.logger(), this::setParam$$anonfun$1, () -> this.setParam$$anonfun$2(e));
            return;
        }
        {
            case -6: 
            case 4: 
            case 5: {
                stmt.setInt(index, ((Number)value2).intValue());
                return;
            }
            case -5: {
                stmt.setLong(index, ((Number)value2).longValue());
                return;
            }
            case 6: 
            case 8: {
                Object object = value2;
                if (object instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)object;
                    stmt.setBigDecimal(index, bd);
                    return;
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    stmt.setDouble(index, d);
                    return;
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    stmt.setFloat(index, f);
                    return;
                }
                stmt.setObject(index, value2, sqltype);
                return;
            }
            case 2: 
            case 3: {
                Object object = value2;
                if (object instanceof BigDecimal) {
                    BigDecimal bd = (BigDecimal)object;
                    stmt.setBigDecimal(index, bd);
                    return;
                }
                stmt.setObject(index, value2, sqltype);
                return;
            }
            case 91: {
                Object object = value2;
                if (object instanceof LocalDate) {
                    LocalDate ld = (LocalDate)object;
                    stmt.setDate(index, Date.valueOf(ld));
                    return;
                }
                if (object instanceof java.util.Date) {
                    java.util.Date jd = (java.util.Date)object;
                    java.util.Date date = jd;
                    if (date instanceof Date) {
                        Date jsd = (Date)date;
                        stmt.setDate(index, jsd);
                        return;
                    }
                    stmt.setDate(index, new Date(jd.getTime()));
                    return;
                }
                if (object instanceof Calendar) {
                    Calendar jc = (Calendar)object;
                    stmt.setDate(index, new Date(jc.getTime().getTime()), jc);
                    return;
                }
                if (object instanceof YearMonth) {
                    YearMonth ym = (YearMonth)object;
                    stmt.setDate(index, Date.valueOf(LocalDate.of(ym.getYear(), ym.getMonth(), 1)));
                    return;
                }
                stmt.setObject(index, value2, 91);
                return;
            }
            case 92: {
                Object object = value2;
                if (object instanceof LocalTime) {
                    LocalTime lt = (LocalTime)object;
                    stmt.setTime(index, Time.valueOf(lt));
                    return;
                }
                if (object instanceof java.util.Date) {
                    java.util.Date jd = (java.util.Date)object;
                    Object object2 = value2;
                    if (object2 instanceof Time) {
                        Time t = (Time)object2;
                        stmt.setTime(index, t);
                        return;
                    }
                    stmt.setTime(index, new Time(jd.getTime()));
                    return;
                }
                if (object instanceof Calendar) {
                    Calendar jc = (Calendar)object;
                    stmt.setTime(index, new Time(jc.getTime().getTime()), jc);
                    return;
                }
                stmt.setObject(index, value2, 92);
                return;
            }
            case 93: {
                Object object = value2;
                if (object instanceof Instant) {
                    Instant i = (Instant)object;
                    stmt.setTimestamp(index, Timestamp.from(i));
                    return;
                }
                if (object instanceof LocalDateTime) {
                    LocalDateTime ldt = (LocalDateTime)object;
                    stmt.setTimestamp(index, Timestamp.valueOf(ldt));
                    return;
                }
                if (object instanceof ZonedDateTime) {
                    ZonedDateTime zdt = (ZonedDateTime)object;
                    stmt.setTimestamp(index, Timestamp.valueOf(zdt.toLocalDateTime()));
                    return;
                }
                if (object instanceof Timestamp) {
                    Timestamp ts = (Timestamp)object;
                    stmt.setTimestamp(index, ts);
                    return;
                }
                if (object instanceof Calendar) {
                    Calendar jc = (Calendar)object;
                    stmt.setTimestamp(index, new Timestamp(jc.getTime().getTime()), jc);
                    return;
                }
                if (object instanceof java.util.Date) {
                    java.util.Date jd = (java.util.Date)object;
                    stmt.setTimestamp(index, new Timestamp(jd.getTime()));
                    return;
                }
                stmt.setObject(index, value2, 93);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                Object object = value2;
                if (!(object instanceof byte[])) {
                    if (!(object instanceof InputStream)) throw new RuntimeException("Binary cannot accept type:" + value2.getClass());
                    InputStream in = (InputStream)object;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    IOs$.MODULE$.copy(in, (OutputStream)out);
                    stmt.setBinaryStream(index, in, out.size());
                }
                byte[] ab = (byte[])object;
                stmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(ab), ab.length);
                return;
            }
            case 2005: {
                if (this.isStringType(value2.getClass())) {
                    stmt.setString(index, value2.toString());
                    return;
                }
                Clob clb = (Clob)value2;
                stmt.setString(index, clb.getSubString(1L, (int)clb.length()));
                return;
            }
            case 2004: {
                InputStream inputStream;
                Object object = value2;
                if (object instanceof byte[]) {
                    byte[] array = (byte[])object;
                    inputStream = new ByteArrayInputStream(array);
                } else if (object instanceof InputStream) {
                    InputStream is = (InputStream)object;
                    inputStream = is;
                } else {
                    if (!(object instanceof Blob)) throw new MatchError(object);
                    Blob blob = (Blob)object;
                    inputStream = blob.getBinaryStream();
                }
                InputStream in = inputStream;
                stmt.setBinaryStream(index, in);
                return;
            }
        }
        if (0 == sqltype) {
            stmt.setObject(index, value2);
            return;
        }
        stmt.setObject(index, value2, sqltype);
    }

    public void setParams(PreparedStatement stmt, Seq<Object> params, Seq<Object> types) {
        int paramsCount = params == null ? 0 : params.length();
        int stmtParamCount = types.length();
        int[] sqltypes = (int[])types.toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        if (stmtParamCount > paramsCount) {
            throw new SQLException("Wrong number of parameters: expected " + stmtParamCount + ", was given " + paramsCount);
        }
        for (int i = 0; i < stmtParamCount; ++i) {
            int index = i + 1;
            if (params.apply(i) == null) {
                stmt.setNull(index, sqltypes[i] == 0 ? 12 : sqltypes[i]);
                continue;
            }
            this.setParam(stmt, index, params.apply(i), sqltypes[i]);
        }
    }

    private boolean isStringType(Class<?> clazz) {
        return CharSequence.class.isAssignableFrom(clazz) || StringWriter.class.isAssignableFrom(clazz);
    }

    private final String setParam$$anonfun$1() {
        return "set value error";
    }

    private final Exception setParam$$anonfun$2(Exception e$1) {
        return e$1;
    }
}

