/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.meta;

import java.io.Serializable;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.meta.Database;
import org.beangle.data.jdbc.meta.Identifier;
import org.beangle.data.jdbc.meta.Schema$NameFilter$;
import org.beangle.data.jdbc.meta.Sequence;
import org.beangle.data.jdbc.meta.Table;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public class Schema {
    private Database database;
    private Identifier name;
    private Option catalog;
    private final HashMap tables;
    private final HashSet sequences;
    public final Schema$NameFilter$ NameFilter$lzy1;

    public Schema(Database database, Identifier name) {
        this.database = database;
        this.name = name;
        this.NameFilter$lzy1 = new Schema$NameFilter$();
        this.catalog = None$.MODULE$;
        if (this.name() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.tables = new HashMap();
        this.sequences = new HashSet();
    }

    public Database database() {
        return this.database;
    }

    public void database_$eq(Database x$1) {
        this.database = x$1;
    }

    public Identifier name() {
        return this.name;
    }

    public void name_$eq(Identifier x$1) {
        this.name = x$1;
    }

    public Option<Identifier> catalog() {
        return this.catalog;
    }

    public void catalog_$eq(Option<Identifier> x$1) {
        this.catalog = x$1;
    }

    public HashMap<Identifier, Table> tables() {
        return this.tables;
    }

    public HashSet<Sequence> sequences() {
        return this.sequences;
    }

    public boolean hasQuotedIdentifier() {
        return this.tables().exists((Function1 & Serializable)_$1 -> ((Table)_$1._2()).hasQuotedIdentifier());
    }

    public void cleanEmptyTables() {
        this.tables().filterInPlace((Function2 & Serializable)(_$2, table) -> table.columns().nonEmpty());
    }

    public Schema addTable(Table table) {
        this.tables().put((Object)table.name(), (Object)table);
        return this;
    }

    public Table getOrCreateTable(String tbname) {
        Table table;
        Identifier tableId = this.database().engine().toIdentifier(tbname);
        Option option = this.tables().get((Object)tableId);
        if (option instanceof Some) {
            Table table2;
            table = table2 = (Table)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            Table ntable = new Table(this, tableId);
            this.tables().put((Object)tableId, (Object)ntable);
            table = ntable;
        } else {
            throw new MatchError((Object)option);
        }
        return table;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table createTable(String tbname) {
        Table table;
        Identifier tableId = this.database().engine().toIdentifier(tbname);
        Option option = this.tables().get((Object)tableId);
        if (option instanceof Some) {
            Table table2 = (Table)((Some)option).value();
            if (!table2.phantom()) throw new RuntimeException("Table " + table2.qualifiedName() + " is existed,creation aborted.");
            table = table2;
            return table;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            Table ntable = new Table(this, tableId);
            this.tables().put((Object)tableId, (Object)ntable);
            table = ntable;
        }
        return table;
    }

    public Option<Table> getTable(String tbname) {
        Object object;
        Engine engine = this.database().engine();
        if (tbname.contains(".")) {
            Identifier identifier = this.name();
            Identifier identifier2 = engine.toIdentifier(Strings$.MODULE$.substringBefore(tbname, "."));
            object = (identifier == null ? identifier2 != null : !((Object)identifier).equals(identifier2)) ? None$.MODULE$ : this.tables().get((Object)engine.toIdentifier(Strings$.MODULE$.substringAfter(tbname, ".")));
        } else {
            object = this.tables().get((Object)engine.toIdentifier(tbname));
        }
        return object;
    }

    public Seq<Table> filterTables(Seq<String> includes, Seq<String> excludes) {
        NameFilter filter = new NameFilter(this, this.NameFilter().$lessinit$greater$default$1());
        Engine engine = this.database().engine();
        if (includes != null) {
            includes.foreach((Function1)(JProcedure1 & Serializable)include -> filter.include(engine.toIdentifier((String)include).value()));
        }
        if (excludes != null) {
            excludes.foreach((Function1)(JProcedure1 & Serializable)exclude -> filter.exclude(engine.toIdentifier((String)exclude).value()));
        }
        return filter.filter((Iterable<Identifier>)this.tables().keySet()).map((Function1 & Serializable)t -> (Table)this.tables().apply(t));
    }

    public Seq<Sequence> filterSequences(Seq<String> includes, Seq<String> excludes) {
        Engine engine = this.database().engine();
        NameFilter filter = new NameFilter(this, this.NameFilter().$lessinit$greater$default$1());
        if (includes != null) {
            includes.foreach((Function1)(JProcedure1 & Serializable)include -> filter.include(engine.toIdentifier((String)include).value()));
        }
        if (excludes != null) {
            excludes.foreach((Function1)(JProcedure1 & Serializable)exclude -> filter.exclude(engine.toIdentifier((String)exclude).value()));
        }
        Map seqMap = ((IterableOnceOps)this.sequences().map((Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)f.name(), f))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return filter.filter((Iterable<Identifier>)seqMap.keys()).map((Function1 & Serializable)s -> (Sequence)seqMap.apply(s));
    }

    public String toString() {
        return "Schema " + this.name();
    }

    public final Schema$NameFilter$ NameFilter() {
        return this.NameFilter$lzy1;
    }

    public class NameFilter {
        private final boolean lowercase;
        private final ListBuffer excludes;
        private final ListBuffer includes;
        private final /* synthetic */ Schema $outer;

        public NameFilter(Schema $outer, boolean lowercase) {
            this.lowercase = lowercase;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.excludes = new ListBuffer();
            this.includes = new ListBuffer();
        }

        public ListBuffer<String> excludes() {
            return this.excludes;
        }

        public ListBuffer<String> includes() {
            return this.includes;
        }

        public List<Identifier> filter(Iterable<Identifier> tables) {
            ListBuffer results = new ListBuffer();
            tables.foreach((Function1)(JProcedure1 & Serializable)tabId -> {
                String tableName;
                String tabame = this.lowercase ? tabId.value().toLowerCase() : tabId.value();
                String string = tableName = tabame.contains(".") ? Strings$.MODULE$.substringAfter(tabame, ".") : tabame;
                if (this.includes().exists((Function1 & Serializable)p -> {
                    String string = p;
                    String string2 = "*";
                    return !(string == null ? string2 != null : !string.equals(string2)) || tableName.startsWith((String)p) && !this.excludes().contains((Object)tableName);
                })) {
                    results.$plus$eq(tabId);
                }
            });
            return results.toList();
        }

        public void exclude(String table) {
            this.excludes().$plus$eq((Object)(this.lowercase ? table.toLowerCase() : table));
        }

        public void include(String table) {
            this.includes().$plus$eq((Object)(this.lowercase ? table.toLowerCase() : table));
        }

        public final /* synthetic */ Schema org$beangle$data$jdbc$meta$Schema$NameFilter$$$outer() {
            return this.$outer;
        }
    }
}

