/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.saga;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.test.AxonAssertionError;
import org.axonframework.test.matchers.EqualFieldsMatcher;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.saga.DescriptionUtils;
import org.axonframework.test.utils.RecordingCommandBus;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class CommandValidator {
    private final RecordingCommandBus commandBus;
    private final FieldFilter fieldFilter;

    public CommandValidator(RecordingCommandBus commandBus, FieldFilter fieldFilter) {
        this.commandBus = commandBus;
        this.fieldFilter = fieldFilter;
    }

    public void startRecording() {
        this.commandBus.clearCommands();
    }

    public void assertDispatchedEqualTo(Object ... expected) {
        List<CommandMessage<?>> actual = this.commandBus.getDispatchedCommands();
        if (actual.size() != expected.length) {
            throw new AxonAssertionError(String.format("Got wrong number of commands dispatched. Expected <%s>, got <%s>", expected.length, actual.size()));
        }
        Iterator<CommandMessage<?>> actualIterator = actual.iterator();
        Iterator<Object> expectedIterator = Arrays.asList(expected).iterator();
        int counter = 0;
        while (actualIterator.hasNext()) {
            CommandMessage<?> actualItem = actualIterator.next();
            Object expectedItem = expectedIterator.next();
            if (expectedItem instanceof CommandMessage) {
                CommandMessage expectedMessage = (CommandMessage)expectedItem;
                if (!expectedMessage.getPayloadType().equals(actualItem.getPayloadType())) {
                    throw new AxonAssertionError(String.format("Unexpected payload type of command at position %s (0-based). Expected <%s>, got <%s>", counter, expectedMessage.getPayloadType(), actualItem.getPayloadType()));
                }
                this.assertCommandEquality(counter, expectedMessage.getPayload(), actualItem.getPayload());
                if (!expectedMessage.getMetaData().equals((Object)actualItem.getMetaData())) {
                    throw new AxonAssertionError(String.format("Unexpected Meta Data of command at position %s (0-based). Expected <%s>, got <%s>", counter, expectedMessage.getMetaData(), actualItem.getMetaData()));
                }
            } else {
                this.assertCommandEquality(counter, expectedItem, actualItem.getPayload());
            }
            ++counter;
        }
    }

    public void assertDispatchedMatching(Matcher<?> matcher) {
        if (!matcher.matches(this.commandBus.getDispatchedCommands())) {
            StringDescription expectedDescription = new StringDescription();
            StringDescription actualDescription = new StringDescription();
            matcher.describeTo((Description)expectedDescription);
            DescriptionUtils.describe(this.commandBus.getDispatchedCommands(), (Description)actualDescription);
            throw new AxonAssertionError(String.format("Incorrect dispatched command. Expected <%s>, but got <%s>", expectedDescription, actualDescription));
        }
    }

    private void assertCommandEquality(int commandIndex, Object expected, Object actual) {
        if (!expected.equals(actual)) {
            if (!expected.getClass().equals(actual.getClass())) {
                throw new AxonAssertionError(String.format("Wrong command type at index %s (0-based). Expected <%s>, but got <%s>", commandIndex, expected.getClass().getSimpleName(), actual.getClass().getSimpleName()));
            }
            EqualFieldsMatcher<Object> matcher = new EqualFieldsMatcher<Object>(expected, this.fieldFilter);
            if (!matcher.matches(actual)) {
                throw new AxonAssertionError(String.format("Unexpected command at index %s (0-based). Field value of '%s.%s', expected <%s>, but got <%s>", commandIndex, expected.getClass().getSimpleName(), matcher.getFailedField().getName(), matcher.getFailedFieldExpectedValue(), matcher.getFailedFieldActualValue()));
            }
        }
    }
}

